/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.swing.units.ValueConverter;
import java.math.RoundingMode;
import java.text.Format;

class PercentageConverter
implements ValueConverter<String, Percentage> {
    PercentageConverter() {
    }

    public Percentage fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)1.0);
        return Percentage.from(value / 100.0);
    }

    public String fromModel(Percentage modelValue) {
        return String.valueOf(modelValue.asDouble() * 100.0);
    }

    public String getUnit() {
        return Units.getText().unitPerc();
    }

    public Format getFormat() {
        return DecimalFormatFactory.createDecimalFormat((String)"##0.##", (RoundingMode)RoundingMode.HALF_EVEN);
    }
}

