/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Power;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

class PowerConverter
implements ValueConverter<String, Power> {
    PowerConverter() {
    }

    public Power fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        return Power.from(value, Power.Unit.SI);
    }

    public String fromModel(Power modelValue) {
        return String.valueOf(modelValue.getIn(Power.Unit.SI));
    }

    public String getUnit() {
        return Units.getText().unitW();
    }

    public Format getFormat() {
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0");
    }
}

