/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Pressure;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

public class PressureConverter
implements ValueConverter<String, Pressure> {
    private final boolean forceSiUnits;

    public PressureConverter(boolean forceSiUnits) {
        this.forceSiUnits = forceSiUnits;
    }

    public Pressure fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (this.forceSiUnits) {
            return Pressure.from(value, Pressure.Unit.PA);
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return Pressure.from(value, Pressure.Unit.INHG);
        }
        return Pressure.from(value, Pressure.Unit.KPA);
    }

    public String fromModel(Pressure modelValue) {
        if (this.forceSiUnits) {
            return String.valueOf(modelValue.getIn(Pressure.Unit.PA));
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return String.valueOf(modelValue.getIn(Pressure.Unit.INHG));
        }
        return String.valueOf(modelValue.getIn(Pressure.Unit.KPA));
    }

    public String getUnit() {
        if (this.forceSiUnits) {
            return Units.getSiText().unitPa();
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return Units.getText().unitInhg();
        }
        return Units.getSiText().unitKpa();
    }

    public Format getFormat() {
        if (this.forceSiUnits) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.000");
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
        }
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
    }
}

