/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

class SpeedConverter
implements ValueConverter<String, Speed> {
    private final boolean forceSiUnits;

    SpeedConverter(boolean forceSiUnits) {
        this.forceSiUnits = forceSiUnits;
    }

    public Speed fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (this.forceSiUnits) {
            return Speed.from(value, Speed.Unit.SI);
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return Speed.from(value, Speed.Unit.INCH_S);
        }
        return Speed.from(value, Speed.Unit.MM_S);
    }

    public String fromModel(Speed modelValue) {
        if (this.forceSiUnits) {
            return String.valueOf(modelValue.getIn(Speed.Unit.SI));
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return String.valueOf(modelValue.getIn(Speed.Unit.INCH_S));
        }
        return String.valueOf(modelValue.getIn(Speed.Unit.MM_S));
    }

    public String getUnit() {
        if (this.forceSiUnits) {
            return Units.getSiText().unitMmS();
        }
        return Units.getText().unitMmS();
    }

    public Format getFormat() {
        if (this.forceSiUnits) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.000");
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
        }
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.0");
    }
}

