/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

class TimeConverter
implements ValueConverter<String, Time> {
    private final boolean forceSiUnits;

    TimeConverter(boolean forceSiUnits) {
        this.forceSiUnits = forceSiUnits;
    }

    public Time fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (this.forceSiUnits) {
            return Time.from(value, Time.Unit.SI);
        }
        return Time.from(value, Time.Unit.MILLI_SECONDS);
    }

    public String fromModel(Time modelValue) {
        if (this.forceSiUnits) {
            return String.valueOf(modelValue.getIn(Time.Unit.SI));
        }
        return String.valueOf(modelValue.getIn(Time.Unit.MILLI_SECONDS));
    }

    public String getUnit() {
        if (this.forceSiUnits) {
            return Units.getSiText().unitMs();
        }
        return Units.getText().unitMs();
    }

    public Format getFormat() {
        if (this.forceSiUnits) {
            return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.000");
        }
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0");
    }
}

