/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.polyscope.valueobjects.converters.ImperialUnitsResourceConverter;
import com.ur.polyscope.valueobjects.converters.SiUnitBundleConverter;
import com.ur.polyscope.valueobjects.converters.UnitType;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.polyscope.valueobjects.internal.UnitsResource;
import com.ur.polyscope.valueobjects.internal.impl.UnitsResourceImpl;
import java.util.Locale;

public class Units {
    private static UnitsResource siUnitBundle;
    private static UnitsResource metricUnitsBundle;
    private static ImperialUnitsResourceConverter imperialUnitsBundle;

    static {
        Units.loadResourceBundles();
    }

    private Units() {
    }

    private static void loadResourceBundles() {
        Locale locale = Locale.getDefault();
        siUnitBundle = new SiUnitBundleConverter(locale);
        metricUnitsBundle = new UnitsResourceImpl(locale);
        imperialUnitsBundle = new ImperialUnitsResourceConverter(locale);
    }

    public static UnitsResource getText() {
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return imperialUnitsBundle;
        }
        return metricUnitsBundle;
    }

    static UnitsResource getSiText() {
        return siUnitBundle;
    }

    public static void setUnitType(UnitType unitType) {
        UnitsValueConverterFactory.setUnitType(unitType);
    }
}

