/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.converters;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.Units;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import java.text.Format;

class WeightConverter
implements ValueConverter<String, Weight> {
    private final boolean forceSiUnits;

    WeightConverter(boolean forceSiUnits) {
        this.forceSiUnits = forceSiUnits;
    }

    public Weight fromGui(String guiValue) {
        double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
        if (this.forceSiUnits) {
            return Weight.from(value, Weight.Unit.SI);
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return Weight.from(value, Weight.Unit.LBS);
        }
        return Weight.from(value, Weight.Unit.KG);
    }

    public String fromModel(Weight modelValue) {
        if (this.forceSiUnits) {
            return String.valueOf(modelValue.getIn(Weight.Unit.SI));
        }
        if (UnitsValueConverterFactory.unitType.isUS()) {
            return String.valueOf(modelValue.getIn(Weight.Unit.LBS));
        }
        return String.valueOf(modelValue.getIn(Weight.Unit.KG));
    }

    public String getUnit() {
        if (this.forceSiUnits) {
            return Units.getSiText().unitKg();
        }
        return Units.getText().unitKg();
    }

    public Format getFormat() {
        return DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.000");
    }
}

