/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.move.MoveTabRobotModel;
import com.ur.move.RotateToolWhilePressed;
import com.ur.move.TCPDirection;
import com.ur.move.resources.LabelImageResource;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.swing.LabelUtils;
import com.ur.swing.WhilePressed;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

abstract class AbstractRotateToolPanel
extends JPanel {
    public static final String RZ_MINUS = "ROTATE_Z_MINUS";
    public static final String RZ_PLUS = "ROTATE_Z_PLUS";
    public static final String RX_MINUS = "ROTATE_X_MINUS";
    public static final String RX_PLUS = "ROTATE_X_PLUS";
    public static final String RY_MINUS = "ROTATE_Y_MINUS";
    public static final String RY_PLUS = "ROTATE_Y_PLUS";
    protected final MoveTabRobotModel robotModel;
    protected final TextResource textResource;
    protected final JPanel toolPanel = new JPanel();
    private final JPanel labeledToolPanel = new JPanel();
    private final JPanel disabledToolPanel = new JPanel();
    protected ControllerInterface controllerInterface;

    AbstractRotateToolPanel(TextResource textResource, MoveTabRobotModel robotModel, ControllerInterface controllerInterface) {
        this.robotModel = robotModel;
        this.textResource = textResource;
        this.controllerInterface = controllerInterface;
    }

    void init() {
        this.createPanels();
        this.addPanel();
    }

    private void createPanels() {
        this.createLabeledPanel();
        this.createDisabledPanel();
        this.createPanel();
    }

    protected abstract void createPanel();

    private void createLabeledPanel() {
        JLabel rzMinusLabel = this.createLabeledIcon(TCPDirection.RZMINUS, LabelImageResource.rzMinusBlueLabel(), LabelImageResource.rzMinusSelectedLabel());
        JLabel rzPlusLabel = this.createLabeledIcon(TCPDirection.RZPLUS, LabelImageResource.rzPlusBlueLabel(), LabelImageResource.rzPlusSelectedLabel());
        JLabel ryMinusLabel = this.createLabeledIcon(TCPDirection.RYMINUS, LabelImageResource.ryMinusGreenLabel(), LabelImageResource.ryMinusSelectedLabel());
        JLabel rxPlusLabel = this.createLabeledIcon(TCPDirection.RXPLUS, LabelImageResource.rxPlusRedLabel(), LabelImageResource.rxPlusSelectedLabel());
        JLabel rxMinusLabel = this.createLabeledIcon(TCPDirection.RXMINUS, LabelImageResource.rxMinusRedLabel(), LabelImageResource.rxMinusSelectedLabel());
        JLabel ryPlusLabel = this.createLabeledIcon(TCPDirection.RYPLUS, LabelImageResource.ryPlusGreenLabel(), LabelImageResource.ryPlusSelectedLabel());
        this.addLayout(this.labeledToolPanel, rzMinusLabel, rzPlusLabel, ryMinusLabel, rxPlusLabel, rxMinusLabel, ryPlusLabel);
    }

    private void createDisabledPanel() {
        JLabel rzMinusDisabled = new JLabel();
        rzMinusDisabled.setIcon(LabelImageResource.rzMinusSelected());
        JLabel rzPlusDisabled = new JLabel();
        rzPlusDisabled.setIcon(LabelImageResource.rzPlusSelected());
        JLabel ryMinusDisabled = new JLabel();
        ryMinusDisabled.setIcon(LabelImageResource.ryMinusSelected());
        JLabel rxPlusDisabled = new JLabel();
        rxPlusDisabled.setIcon(LabelImageResource.rxPlusSelected());
        JLabel rxMinusDisabled = new JLabel();
        rxMinusDisabled.setIcon(LabelImageResource.rxMinusSelected());
        JLabel ryPlusDisabled = new JLabel();
        ryPlusDisabled.setIcon(LabelImageResource.ryPlusSelected());
        this.addLayout(this.disabledToolPanel, rzMinusDisabled, rzPlusDisabled, ryMinusDisabled, rxPlusDisabled, rxMinusDisabled, ryPlusDisabled);
    }

    abstract void addLayout(JPanel var1, JLabel var2, JLabel var3, JLabel var4, JLabel var5, JLabel var6, JLabel var7);

    private JLabel createLabeledIcon(TCPDirection tcpDirection, Icon icon, Icon selectedIcon) {
        JLabel label = new JLabel();
        LabelUtils.bindIconButton((JLabel)label, (Icon)icon, (Icon)selectedIcon, (WhilePressed)new RotateToolWhilePressed(this.robotModel, tcpDirection, this.controllerInterface));
        return label;
    }

    public void update() {
        this.updateAndShowPanelWithAxes();
    }

    private void updateAndShowPanelWithAxes() {
        this.removeAll();
        this.addPanel();
        this.revalidate();
        this.repaint();
    }

    public void updateAndShowDisabledPanel() {
        this.removeAll();
        this.addDisabledPanel();
        this.revalidate();
        this.repaint();
    }

    private void addPanel() {
        if (this.showAxes()) {
            this.addLabeledPanel();
        } else {
            this.addUnlabeledPanel();
        }
    }

    private void addLabeledPanel() {
        this.add(this.labeledToolPanel);
    }

    private void addUnlabeledPanel() {
        this.add(this.toolPanel);
    }

    private void addDisabledPanel() {
        this.add(this.disabledToolPanel);
    }

    protected boolean showAxes() {
        return this.robotModel.getJoggableGeomFeature() != null && this.robotModel.getJoggableGeomFeature().getShowAxes();
    }

    protected void setLabelNames(JLabel rzMinusLabel, JLabel rzPlusLabel, JLabel ryMinusLabel, JLabel rxPlusLabel, JLabel rxMinusLabel, JLabel ryPlusLabel) {
        rzMinusLabel.setName(RZ_MINUS);
        rzPlusLabel.setName(RZ_PLUS);
        rxMinusLabel.setName(RX_MINUS);
        rxPlusLabel.setName(RX_PLUS);
        ryMinusLabel.setName(RY_MINUS);
        ryPlusLabel.setName(RY_PLUS);
    }
}

