/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.move.MoveBehavior;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.TCPDirection;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.swing.WhilePressed;
import com.ur.util.logging.Log;
import javax.vecmath.Vector3d;

public class AbstractToolWhilePressed
implements WhilePressed {
    protected final MoveTabRobotModel robotModel;
    protected final TCPDirection direction;
    private ControllerInterface controllerInterface;

    AbstractToolWhilePressed(MoveTabRobotModel robotModel, TCPDirection direction, ControllerInterface controllerInterface) {
        this.robotModel = robotModel;
        this.direction = direction;
        this.controllerInterface = controllerInterface;
    }

    public void perform() {
        if (!this.robotModel.runningRobotRequirement().checkAndNotify()) {
            return;
        }
        Vector3d translationSpeed = new Vector3d(0.0, 0.0, 0.0);
        Vector3d rotationSpeed = new Vector3d(0.0, 0.0, 0.0);
        if (this.applyColourToTranslation(translationSpeed) || this.applyColourToRotation(rotationSpeed)) {
            this.robotModel.stopProgramBeforeMove();
            StringBuffer sb = new StringBuffer();
            this.robotModel.getJoggableGeomFeature().appendSpeedJogScriptCode(sb, translationSpeed, rotationSpeed);
            this.robotModel.setMoveBehavior(MoveBehavior.LINEAR_MOVING);
            try {
                this.controllerInterface.runScript(sb.toString());
            }
            catch (Exception e) {
                Log.error((String)"", (Throwable)e);
            }
        }
    }

    protected boolean applyColourToTranslation(Vector3d vector3d) {
        return false;
    }

    protected boolean applyColourToRotation(Vector3d vector3d) {
        return false;
    }

    public void stop() {
        this.robotModel.linearStop();
    }
}

