/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.move.MoveTabRobotModel;
import com.ur.move.TCPDirection;
import com.ur.move.TranslateToolWhilePressed;
import com.ur.move.resources.LabelImageResource;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.swing.LabelUtils;
import com.ur.swing.WhilePressed;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractTranslateToolPanel
extends JPanel {
    public static final String Z_MINUS = "TRANSLATE_Z_MINUS";
    public static final String Z_PLUS = "TRANSLATE_Z_PLUS";
    public static final String X_MINUS = "TRANSLATE_X_MINUS";
    public static final String X_PLUS = "TRANSLATE_X_PLUS";
    public static final String Y_MINUS = "TRANSLATE_Y_MINUS";
    public static final String Y_PLUS = "TRANSLATE_Y_PLUS";
    protected final MoveTabRobotModel robotModel;
    protected final TextResource textResource;
    protected final ControllerInterface controllerInterface;
    final JPanel toolPanel = new JPanel();
    private final JPanel labeledToolPanel = new JPanel();
    private final JPanel disabledToolPanel = new JPanel();

    AbstractTranslateToolPanel(TextResource textResource, MoveTabRobotModel robotModel, ControllerInterface controllerInterface) {
        this.robotModel = robotModel;
        this.textResource = textResource;
        this.controllerInterface = controllerInterface;
    }

    void init() {
        this.createPanels();
        this.addPanel();
    }

    private void createPanels() {
        this.createLabeledPanel();
        this.createDisabledPanel();
        this.createPanel();
    }

    protected abstract void createPanel();

    private void createLabeledPanel() {
        JLabel zMinusLabel = this.createLabeledIcon(TCPDirection.DOWN, LabelImageResource.zMinusBlueLabel(), LabelImageResource.zMinusSelectedLabel());
        JLabel zPlusLabel = this.createLabeledIcon(TCPDirection.UP, LabelImageResource.zPlusBlueLable(), LabelImageResource.zPlusSelectedLabel());
        JLabel xMinusLabel = this.createLabeledIcon(TCPDirection.BACKWARD, LabelImageResource.xMinusRedLabel(), LabelImageResource.xMinusSelectedLabel());
        JLabel xPlusLabel = this.createLabeledIcon(TCPDirection.FORWARD, LabelImageResource.xPlusRedLabel(), LabelImageResource.xPlusSelectedLabel());
        JLabel yMinusLabel = this.createLabeledIcon(TCPDirection.LEFT, LabelImageResource.yMinusGreenLabel(), LabelImageResource.yMinusSelectedLabel());
        JLabel yPlusLabel = this.createLabeledIcon(TCPDirection.RIGHT, LabelImageResource.yPlusGreenLabel(), LabelImageResource.yPlusSelectedLabel());
        JLabel blankLabel = new JLabel();
        this.addLayout(this.labeledToolPanel, zMinusLabel, zPlusLabel, xMinusLabel, xPlusLabel, yMinusLabel, yPlusLabel, blankLabel);
    }

    private JLabel createLabeledIcon(TCPDirection tcpDirection, Icon icon, Icon selectedIcon) {
        JLabel label = new JLabel();
        LabelUtils.bindIconButton((JLabel)label, (Icon)icon, (Icon)selectedIcon, (WhilePressed)new TranslateToolWhilePressed(this.robotModel, tcpDirection, this.controllerInterface));
        return label;
    }

    private void createDisabledPanel() {
        JLabel zMinusLabel = new JLabel();
        zMinusLabel.setIcon(LabelImageResource.zMinusSelected());
        JLabel zPlusLabel = new JLabel();
        zPlusLabel.setIcon(LabelImageResource.zPlusSelected());
        JLabel xMinusLabel = new JLabel();
        xMinusLabel.setIcon(LabelImageResource.xMinusSelected());
        JLabel xPlusLabel = new JLabel();
        xPlusLabel.setIcon(LabelImageResource.xPlusSelected());
        JLabel yMinusLabel = new JLabel();
        yMinusLabel.setIcon(LabelImageResource.yMinusSelected());
        JLabel yPlusLabel = new JLabel();
        yPlusLabel.setIcon(LabelImageResource.yPlusSelected());
        JLabel blankLabel = new JLabel();
        this.addLayout(this.disabledToolPanel, zMinusLabel, zPlusLabel, xMinusLabel, xPlusLabel, yMinusLabel, yPlusLabel, blankLabel);
    }

    abstract void addLayout(JPanel var1, JLabel var2, JLabel var3, JLabel var4, JLabel var5, JLabel var6, JLabel var7, JLabel var8);

    protected boolean showAxes() {
        return this.robotModel.getJoggableGeomFeature() != null && this.robotModel.getJoggableGeomFeature().getShowAxes();
    }

    public void update() {
        this.updateAndShowPanelWithAxes();
    }

    private void updateAndShowPanelWithAxes() {
        this.removeAll();
        this.addPanel();
        this.revalidate();
        this.repaint();
    }

    public void updateAndShowDisabledPanel() {
        this.removeAll();
        this.addDisabledPanel();
        this.revalidate();
        this.repaint();
    }

    private void addPanel() {
        if (this.showAxes()) {
            this.addLabeledPanel();
        } else {
            this.addUnlabeledPanel();
        }
    }

    private void addLabeledPanel() {
        this.add(this.labeledToolPanel);
    }

    private void addUnlabeledPanel() {
        this.add(this.toolPanel);
    }

    private void addDisabledPanel() {
        this.add(this.disabledToolPanel);
    }

    protected void setLabelNames(JLabel zMinusLabel, JLabel zPlusLabel, JLabel xMinusLabel, JLabel xPlusLabel, JLabel yMinusLabel, JLabel yPlusLabel) {
        zMinusLabel.setName(Z_MINUS);
        zPlusLabel.setName(Z_PLUS);
        xMinusLabel.setName(X_MINUS);
        xPlusLabel.setName(X_PLUS);
        yMinusLabel.setName(Y_MINUS);
        yPlusLabel.setName(Y_PLUS);
    }
}

