/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.move.AcceptOrCancelRenderer;
import com.ur.move.OKCancelConfirmationListener;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.visualizer.j3dcomponents.J3DButton;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.j3dcomponents.J3DPanel;
import com.ur.swing.resources.ImageResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;

public class AcceptOrCancelJ3DRenderer
extends J3DPanel
implements AcceptOrCancelRenderer {
    private static final int BUTTON_SIZE = 48;
    private static final int BUTTON_SPACING = 42;
    private final Component robotCanvas3D;
    private final J3DButton ok;
    private final J3DButton cancel;

    public AcceptOrCancelJ3DRenderer(final OKCancelConfirmationListener listener, String okButtonText, String cancelButtonText, Component robotCanvas3D) {
        this.robotCanvas3D = robotCanvas3D;
        this.ok = new J3DButton(okButtonText, ((ImageIcon)ImageResource.approve()).getImage(), 48, 48);
        this.ok.setName("ok.MoveTab");
        this.ok.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                listener.okAction();
            }
        });
        this.cancel = new J3DButton(cancelButtonText, ((ImageIcon)ImageResource.cancel()).getImage(), 48, 48);
        this.cancel.setName("cancel.MoveTab");
        this.cancel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                listener.cancelAction();
            }
        });
        this.add((J3DComponent)this.ok);
        this.add((J3DComponent)this.cancel);
    }

    public AcceptOrCancelJ3DRenderer(OKCancelConfirmationListener listener, TextResource textResource, Component robotCanvas3D) {
        this(listener, textResource.OK(), textResource.Cancel(), robotCanvas3D);
    }

    @Override
    public void showButtons(boolean showOK, boolean showCancel) {
        this.ok.setVisible(showOK);
        this.cancel.setVisible(showCancel);
    }

    @Override
    public void setEnabled(boolean enableOK, boolean enableCancel) {
        this.ok.setEnabled(enableOK);
        this.cancel.setEnabled(enableCancel);
    }

    public void render(Graphics2D g2d) {
        Dimension dimensions = this.robotCanvas3D.getSize();
        g2d.setColor(Color.BLACK);
        if (this.ok.isVisible() && this.cancel.isVisible()) {
            int startX = dimensions.width - 96 + 84 - 180;
            int startY = dimensions.height - 48 + 42 - 80;
            this.ok.setLocation(startX, startY);
            this.ok.render(g2d);
            this.cancel.setLocation(startX + 48 + 42, startY);
            this.cancel.render(g2d);
        } else if (this.ok.isVisible()) {
            int startX = dimensions.width - 48 + 42 - 180;
            int startY = dimensions.height - 48 + 42 - 80;
            this.ok.setLocation(startX, startY);
            this.ok.render(g2d);
        }
    }
}

