/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.controllerinterface.ControllerConnectionListener;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class ControllerSocketSender {
    private static final String INKOGNITO = "inkognito";
    public static final int TIMEOUT = 1500;
    private static List<StopRobotListener> stopRobotListeners = new ArrayList<StopRobotListener>();
    private static TextResource textResource;
    private static ControllerInterface controllerInterface;
    private static HMCInterface hmcInterface;

    @Inject
    public static void setTextResource(TextResource textResource) {
        ControllerSocketSender.textResource = textResource;
    }

    @Inject
    public static void setControllerInterface(ControllerInterface controllerInterface) {
        ControllerSocketSender.controllerInterface = controllerInterface;
    }

    @Inject
    public static void setHmcInterface(HMCInterface hmcInterface) {
        ControllerSocketSender.hmcInterface = hmcInterface;
    }

    public static void setRealRobotBlocking() {
        if (controllerInterface.isConnected()) {
            try {
                controllerInterface.runScript("set real\n");
            }
            catch (Exception e) {
                Log.error((String)"Could not send \"set real\": ", (Throwable)e);
                throw new RuntimeException(textResource.failedToActivateRealRobot() + ":" + e.getMessage());
            }
            if (!Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                public boolean itHappened() {
                    return RobotState.getLatestRobotState().real;
                }
            }, (int)1500, (TimeUnit)TimeUnit.MILLISECONDS)) {
                EventNotificationService.notify(ControllerConnectionListener.class, (NotificationStrategy)new NotificationStrategy<ControllerConnectionListener>(){

                    public void notify(ControllerConnectionListener controllerConnectionListener) {
                        controllerConnectionListener.failedToSendMessage("set real");
                    }
                });
            }
        }
    }

    public static void sendSpeedJoint(double[] jointSpeed, double acceleration, double minTime) {
        StringBuffer b = new StringBuffer();
        b.append("def inkognito():\n");
        b.append("  speedj([");
        b.append(jointSpeed[0] + ", ");
        b.append(jointSpeed[1] + ", ");
        b.append(jointSpeed[2] + ", ");
        b.append(jointSpeed[3] + ", ");
        b.append(jointSpeed[4] + ", ");
        b.append(jointSpeed[5] + "], ");
        b.append(acceleration + ", " + minTime + ")\n");
        b.append("end\n");
        controllerInterface.runScript(b.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pose6d getTCPPose(JointPositionVector jpv) {
        if (jpv == null || jpv.isUndefined()) {
            return null;
        }
        String s = "get_tcp_pose(" + jpv + ")";
        HMCResponse hmcResponseMessage = hmcInterface.sendHMCMessageAndWait(s);
        if (hmcResponseMessage != null) {
            FilterInputStream dis = null;
            if (hmcResponseMessage.getResponseData() == null) {
                Log.error((String)"HMC Message buffer is null!?");
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
                dis = new DataInputStream(bais);
                Pose6d pose6d = new Pose6d(((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble());
                return pose6d;
            }
            catch (IOException e) {
                Log.error((String)("HMC.getJointPath: Parse error (or similar) " + e));
            }
            finally {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static void sendStopJoint(double acceleration) {
        StringBuffer b = new StringBuffer();
        b.append("def inkognito():\n");
        b.append("  stopj(" + acceleration + ")\n");
        b.append("end\n");
        controllerInterface.runScript(b.toString());
    }

    public static void sendStopLinear(double acceleration) {
        StringBuffer b = new StringBuffer();
        b.append("def inkognito():\n");
        b.append("  stopl(" + acceleration + ")\n");
        b.append("end\n");
        controllerInterface.runScript(b.toString());
    }

    public static boolean sendStopProgram() {
        boolean didWritBytes = controllerInterface.runScript("stop program\n");
        for (StopRobotListener stopRobotListener : stopRobotListeners) {
            stopRobotListener.stopProgramSent();
        }
        if (didWritBytes) {
            controllerInterface.setUserProgramOnRobot(false);
        }
        return didWritBytes;
    }

    @Deprecated
    public static void sendRestartSCB() {
        controllerInterface.runScript("restart scb\n");
    }

    public static void sendSetTCPTransform(ToolPosition toolPosition) {
        ControllerSocketSender.sendSetTCPTransform(new Pose6d(toolPosition.asArray()));
    }

    public static void sendSetTCPTransform(Pose6d pose) {
        StringBuffer b = new StringBuffer();
        b.append("sec setTCPTransform():\n");
        b.append("  set_tcp(" + pose + ")\n");
        b.append("end\n");
        controllerInterface.runScript(b.toString());
    }

    public static interface StopRobotListener {
        public void stopProgramSent();
    }
}

