/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.move.MoveTabRobotModel;
import com.ur.move.MoveToolPanel;
import com.ur.move.SelectedFeatureListener;
import com.ur.move.UpdateFeatureRunnable;
import com.ur.move.viewfacade.MoveCameraView;
import com.ur.polyscope.geomfeature.ToolSpatialFeature;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.GeomFeatureChangedListener;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class FeatureSelectionListener
implements ItemListener {
    private final MoveToolPanel moveToolPanel;
    private final MoveTabRobotModel robotModel;
    private final RobotCanvas3D robotCanvas3D;
    private ProgramVisualization programVisualization;

    public FeatureSelectionListener(MoveToolPanel moveToolPanel, MoveTabRobotModel robotModel, RobotCanvas3D robotCanvas3D, ProgramVisualization programVisualization) {
        this.moveToolPanel = moveToolPanel;
        this.robotModel = robotModel;
        this.robotCanvas3D = robotCanvas3D;
        this.programVisualization = programVisualization;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            ViewableGeomFeature newJoggableGeomFeature = (ViewableGeomFeature)event.getItem();
            if (this.robotModel.getJoggableGeomFeature() != newJoggableGeomFeature) {
                ViewableGeomFeature joggableGeomFeature = this.robotModel.getJoggableGeomFeature();
                if (joggableGeomFeature instanceof ToolSpatialFeature) {
                    joggableGeomFeature.removeGeomFeatureChangedListener((GeomFeatureChangedListener)this.programVisualization);
                }
                this.robotModel.setJoggableGeomFeature(newJoggableGeomFeature);
                this.robotModel.setJoggableFeatureWithTransitionEnabled(true);
                boolean showAxes = !(newJoggableGeomFeature instanceof MoveCameraView);
                boolean isJoggableFeatureWithTransitionEnabled = true;
                UpdateFeatureRunnable runnable = new UpdateFeatureRunnable(isJoggableFeatureWithTransitionEnabled, showAxes, newJoggableGeomFeature, this.robotCanvas3D, this.programVisualization, true);
                this.robotCanvas3D.addQueue((Runnable)runnable);
                this.notifyFeatureSelected((GeomFeature)event.getItem());
                this.moveToolPanel.update();
            }
        }
    }

    private void notifyFeatureSelected(final GeomFeature selectedFeature) {
        EventNotificationService.notify(SelectedFeatureListener.class, (NotificationStrategy)new NotificationStrategy<SelectedFeatureListener>(){

            public void notify(SelectedFeatureListener selectedFeatureListener) {
                selectedFeatureListener.featureSelected(selectedFeature);
            }
        });
    }
}

