/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.polyscope.visualizer.element.VisualizerElement;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class FeatureVisualization
implements VisualizerElement {
    private TransformGroup transformGroup;
    private BranchGroup branchGroup;

    public VisualizerElementType getElementType() {
        return null;
    }

    private LineArray getArrowFromPointToPoint(Vector3d start, Vector3d end, Vector3d axis1In, Vector3d axis2In) {
        Vector3d axis1 = new Vector3d(axis1In);
        axis1.normalize();
        axis1.scale(0.015);
        Vector3d axis2 = new Vector3d(axis2In);
        axis2.normalize();
        axis2.scale(0.015);
        Vector3d pointAlongLineCloseToEnd = new Vector3d();
        pointAlongLineCloseToEnd.sub((Tuple3d)end, (Tuple3d)start);
        pointAlongLineCloseToEnd.scale(0.8);
        pointAlongLineCloseToEnd.add((Tuple3d)start);
        Point3d[] zPointArray = new Point3d[10];
        zPointArray[0] = new Point3d((Tuple3d)start);
        zPointArray[1] = new Point3d((Tuple3d)end);
        Vector3d tempPoint1 = new Vector3d();
        tempPoint1.add((Tuple3d)pointAlongLineCloseToEnd, (Tuple3d)axis1);
        zPointArray[2] = new Point3d((Tuple3d)end);
        zPointArray[3] = new Point3d((Tuple3d)tempPoint1);
        Vector3d tempPoint2 = new Vector3d();
        tempPoint2.scale(-1.0, (Tuple3d)axis1);
        tempPoint2.add((Tuple3d)pointAlongLineCloseToEnd);
        zPointArray[4] = new Point3d((Tuple3d)end);
        zPointArray[5] = new Point3d((Tuple3d)tempPoint2);
        Vector3d tempPoint3 = new Vector3d();
        tempPoint3.add((Tuple3d)pointAlongLineCloseToEnd, (Tuple3d)axis2);
        zPointArray[6] = new Point3d((Tuple3d)end);
        zPointArray[7] = new Point3d((Tuple3d)tempPoint3);
        Vector3d tempPoint4 = new Vector3d();
        tempPoint4.scale(-1.0, (Tuple3d)axis2);
        tempPoint4.add((Tuple3d)pointAlongLineCloseToEnd);
        zPointArray[8] = new Point3d((Tuple3d)end);
        zPointArray[9] = new Point3d((Tuple3d)tempPoint4);
        LineArray arrow = new LineArray(10, 1);
        arrow.setCoordinates(0, zPointArray);
        return arrow;
    }

    private Appearance createAxisAppearance(Color color) {
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(new Color3f(color), 0));
        appearance.setLineAttributes(new LineAttributes(3.0f, 0, false));
        this.setTransparency(appearance);
        return appearance;
    }

    protected void setTransparency(Appearance appearance) {
    }

    public Node getElementNode() {
        Vector3d origo = new Vector3d();
        Vector3d xAxis = new Vector3d(1.0, 0.0, 0.0);
        xAxis.scale(0.2);
        Vector3d yAxis = new Vector3d(0.0, 1.0, 0.0);
        yAxis.scale(0.2);
        Vector3d zAxis = new Vector3d(0.0, 0.0, 1.0);
        zAxis.scale(0.2);
        Vector3d pointForEndOfXAxis = new Vector3d();
        pointForEndOfXAxis.add((Tuple3d)origo, (Tuple3d)xAxis);
        Vector3d pointForEndOfYAxis = new Vector3d();
        pointForEndOfYAxis.add((Tuple3d)origo, (Tuple3d)yAxis);
        Vector3d pointForEndOfZAxis = new Vector3d();
        pointForEndOfZAxis.add((Tuple3d)origo, (Tuple3d)zAxis);
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(17);
        LineArray xLine = this.getArrowFromPointToPoint(origo, pointForEndOfXAxis, yAxis, zAxis);
        Appearance xAppearance = this.createAxisAppearance(Color.RED);
        Shape3D xShape = new Shape3D((Geometry)xLine, xAppearance);
        this.branchGroup.addChild((Node)xShape);
        LineArray yLine = this.getArrowFromPointToPoint(origo, pointForEndOfYAxis, xAxis, zAxis);
        Appearance yAppearance = this.createAxisAppearance(Color.GREEN);
        Shape3D yShape = new Shape3D((Geometry)yLine, yAppearance);
        this.branchGroup.addChild((Node)yShape);
        LineArray zLine = this.getArrowFromPointToPoint(origo, pointForEndOfZAxis, xAxis, yAxis);
        Appearance zAppearance = this.createAxisAppearance(Color.BLUE);
        Shape3D zShape = new Shape3D((Geometry)zLine, zAppearance);
        this.branchGroup.addChild((Node)zShape);
        this.transformGroup = new TransformGroup();
        this.transformGroup.setCapability(18);
        this.transformGroup.setCapability(13);
        this.transformGroup.setCapability(14);
        return this.transformGroup;
    }

    public void update() {
    }

    public void setPosition(ViewableGeomFeature viewableGeomFeature) {
        if (viewableGeomFeature == null || this.transformGroup == null) {
            return;
        }
        this.transformGroup.setTransform(viewableGeomFeature.getTransform());
        if (viewableGeomFeature.isDefined() && this.branchGroup.getParent() == null) {
            this.transformGroup.addChild((Node)this.branchGroup);
        } else if (!viewableGeomFeature.isDefined() && this.branchGroup.getParent() != null) {
            this.branchGroup.detach();
        }
    }
}

