/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.move.MoveTabRobotModel;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

class GeomFeatureComboBox
extends JComboBox {
    private final MoveTabRobotModel robotModel;
    private FeaturesLookup featuresLookup;

    GeomFeatureComboBox(MoveTabRobotModel robotModel, FeaturesLookup featuresLookup) {
        super(new DefaultComboBoxModel<String>(new String[]{"No feature"}));
        this.robotModel = robotModel;
        this.featuresLookup = featuresLookup;
    }

    void updateFeatureComboboxWithCurrentInstallation() {
        this.setModel(new DefaultComboBoxModel<GeomFeature>(this.featuresLookup.getFeatureContainer().getJoggableGeomNodes()));
        if (this.robotModel.getJoggableGeomFeature() == null) {
            this.robotModel.setJoggableGeomFeature((ViewableGeomFeature)this.getItemAt(0));
        } else {
            this.robotModel.setJoggableGeomFeature(this.updateReferenceToGeomFeature(this.robotModel.getJoggableGeomFeature().getName()));
            if (GeomFeatureComboBox.isNotJoggable(this.robotModel.getJoggableGeomFeature())) {
                this.robotModel.setJoggableGeomFeature((ViewableGeomFeature)this.getItemAt(0));
            }
        }
        this.setSelectedItem(this.robotModel.getJoggableGeomFeature());
    }

    private ViewableGeomFeature updateReferenceToGeomFeature(String geomFeatureName) {
        return (ViewableGeomFeature)this.featuresLookup.getFeatureContainer().getFeatureByName(geomFeatureName);
    }

    private static boolean isNotJoggable(ViewableGeomFeature geomFeature) {
        return geomFeature == null || !geomFeature.isJoggableEnabled();
    }

    ViewableGeomFeature getSelectedFeature() {
        return (ViewableGeomFeature)this.getSelectedItem();
    }
}

