/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.lang.DecimalFormatFactory;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.JointType;
import com.ur.move.JointPositionIndicator;
import com.ur.move.internal.TextFieldUtils;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.joint.JointPositionRangeProvider;
import com.ur.swing.units.Units;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class JointPaintStrategy {
    private static final DecimalFormat degFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
    private final JointPositionRangeProvider jointPositionRangeProvider;
    private final JointPositionIndicator[] jointProgress;
    private final JTextField[] jointText;
    private final JTextField[] positionText;
    private final JLabel[] revolutionLabels;
    private boolean lastPaintedReducedMode;

    public JointPaintStrategy(JointPositionRangeProvider jointPositionRangeProvider, JointPositionIndicator[] jointProgress, JTextField[] jointText, JTextField[] positionText, JLabel[] revolutionLabels) {
        this.jointPositionRangeProvider = jointPositionRangeProvider;
        this.jointProgress = jointProgress;
        this.jointText = jointText;
        this.positionText = positionText;
        this.revolutionLabels = revolutionLabels;
    }

    public void setConfigurationSettings(JointConfigurationSettings settings) {
        for (JointPositionIndicator each : this.jointProgress) {
            each.setConfigurationLookupService(settings);
        }
    }

    public void paintJointText(JointPositionVector jpv, boolean reducedMode) {
        for (JointType each : JointType.values()) {
            double degreesPerRad = 57.29577951308232;
            if (this.jointPositionRangeProvider.isRestricted(each, reducedMode)) {
                TextFieldUtils.setText(this.jointText[each.getJointNumber()], degFormat.format(jpv.getJoint(each) * degreesPerRad));
                this.revolutionLabels[each.getJointNumber()].setText("");
                continue;
            }
            int revolutions = (int)(jpv.getJoint(each) / (Math.PI * 2));
            if (jpv.getJoint(each) < 0.0) {
                --revolutions;
            }
            TextFieldUtils.setText(this.jointText[each.getJointNumber()], degFormat.format((jpv.getJoint(each) - (double)revolutions * (Math.PI * 2)) * degreesPerRad));
            this.revolutionLabels[each.getJointNumber()].setText(" " + revolutions + Units.getText().revolutions());
        }
    }

    public void hideTargetPositions() {
        for (JointPositionIndicator each : this.jointProgress) {
            each.setShowTargetPosition(false);
        }
    }

    public void setEnabledOnAllTextFields(boolean enabled) {
        for (JTextField each : this.jointText) {
            if (each.isEnabled() == enabled) continue;
            each.setEnabled(enabled);
        }
        for (JTextField each : this.positionText) {
            if (each.isEnabled() == enabled) continue;
            each.setEnabled(enabled);
        }
    }

    public void setTargetPositions(JointPositionVector shadowJPV) {
        for (int i = 0; i < this.jointProgress.length; ++i) {
            this.jointProgress[i].setTargetPosition(shadowJPV.getJoint(i));
        }
    }

    public void setPositionsValues(JointPositionVector jpv) {
        for (int i = 0; i < this.jointProgress.length; ++i) {
            this.jointProgress[i].setValue(jpv.getJoint(i));
        }
    }

    public void paintJointLimits(boolean reducedMode, boolean forcePaint) {
        if (forcePaint || this.lastPaintedReducedMode != reducedMode) {
            this.lastPaintedReducedMode = reducedMode;
            this.paintJointLimits(reducedMode);
        }
    }

    protected void paintJointLimits(boolean reducedMode) {
        if (this.jointPositionRangeProvider.hasRestrictions()) {
            for (JointType each : JointType.values()) {
                this.jointProgress[each.getJointNumber()].setFixedRange(this.jointPositionRangeProvider.isRestricted(each, reducedMode));
                if (this.jointPositionRangeProvider.withPositionLimits(each)) {
                    this.jointProgress[each.getJointNumber()].setMovementRangeLimit(this.jointPositionRangeProvider.getMinimumPosition(each, reducedMode), this.jointPositionRangeProvider.getMaximumPosition(each, reducedMode));
                    continue;
                }
                this.jointProgress[each.getJointNumber()].setShowMovementRangeLimit(false);
            }
        } else {
            for (JointType each : JointType.values()) {
                this.jointProgress[each.getJointNumber()].setFixedRange(this.jointPositionRangeProvider.isRestricted(each, reducedMode));
                this.jointProgress[each.getJointNumber()].setShowMovementRangeLimit(false);
            }
        }
    }
}

