/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.lang.PrimitiveUtils;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JProgressBar;
import javax.swing.border.LineBorder;

public class JointPositionIndicator
extends JProgressBar {
    private static final LineBorder BORDER = new LineBorder(Color.DARK_GRAY, 1);
    private static final Color TARGET_POSITION_COLOR = new Color(0, 150, 0);
    private static final Color RANGE_LIMIT_COLOR = new Color(255, 0, 0);
    private static final Color BACKGROUND_COLOR = new Color(240, 240, 240);
    private int targetPosition = 50;
    private boolean showTargetPosition = true;
    private int minimum;
    private int maximum;
    private boolean showMovementRangeLimit = false;
    private final JointType selectedJointType;
    private double actualValue;
    private double actualTargetPosition;
    private double actualMinimum;
    private double actualMaximum;
    private JointConfigurationSettings configurationService;
    private boolean isFixedRange = true;
    private Ruler ruler;

    public JointPositionIndicator() {
        this(JointType.BASE);
    }

    public JointPositionIndicator(JointType selectedJointType) {
        this.selectedJointType = selectedJointType;
        this.setBorder(BORDER);
        this.setLayout(new BorderLayout());
        this.setBackground(BACKGROUND_COLOR);
        this.setMinimum(0);
        this.setMaximum(1000);
        this.ruler = new Ruler();
    }

    public void setConfigurationLookupService(JointConfigurationSettings configurationSettings) {
        this.configurationService = configurationSettings;
    }

    public void setValue(double actualValue) {
        double oldActualValue = this.actualValue;
        this.actualValue = actualValue;
        if (!this.isFixedRange()) {
            double xOffset = oldActualValue - actualValue;
            this.ruler.adjustRuler(actualValue);
            if (xOffset != 0.0) {
                this.targetPosition = this.convertValueToProgressBar(this.actualTargetPosition);
                this.minimum = this.convertValueToProgressBar(this.actualMinimum);
                this.maximum = this.convertValueToProgressBar(this.actualMaximum);
                this.repaint();
            }
        }
        super.setValue(this.convertValueToProgressBar(actualValue));
    }

    public void setTargetPosition(double targetPosition) {
        this.actualTargetPosition = targetPosition;
        this.targetPosition = PrimitiveUtils.between((int)this.convertValueToProgressBar(targetPosition), (int)this.getMinimum(), (int)this.getMaximum());
        this.showTargetPosition = true;
        this.repaint();
    }

    public void setShowTargetPosition(boolean showTargetPosition) {
        this.showTargetPosition = showTargetPosition;
    }

    public void setFixedRange(boolean fixedRangeState) {
        if (this.isFixedRange != fixedRangeState) {
            this.isFixedRange = fixedRangeState;
            this.ruler = new Ruler();
        }
    }

    public boolean isFixedRange() {
        return this.isFixedRange;
    }

    public void setMovementRangeLimit(double min, double max) {
        this.actualMinimum = min;
        this.actualMaximum = max;
        if (min == (double)this.minimum && max == (double)this.maximum && this.showMovementRangeLimit) {
            return;
        }
        this.minimum = Math.max(this.getMinimum(), this.convertValueToProgressBar(min));
        if (this.minimum > this.getMaximum()) {
            this.minimum = this.getMinimum();
        }
        this.maximum = Math.min(this.getMaximum(), this.convertValueToProgressBar(max));
        if (this.maximum < this.getMinimum()) {
            this.maximum = this.getMaximum();
        }
        this.showMovementRangeLimit = true;
        this.repaint();
    }

    public void setShowMovementRangeLimit(boolean showMovementRangeLimit) {
        this.showMovementRangeLimit = showMovementRangeLimit;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintRulerMarks(g);
        this.paintIndicators(g);
        g.setColor(Color.BLACK);
        if (this.isFixedRange()) {
            this.renderArrowIndicator(g, (int)(this.getPercentComplete() * (double)this.getWidth()), Arrow.UP);
        } else {
            this.renderArrowIndicator(g, this.getWidth() / 2, Arrow.UP);
        }
        this.paintBorder(g);
    }

    private void paintRulerMarks(Graphics g) {
        g.setColor(Color.LIGHT_GRAY);
        for (Tick each : this.ruler) {
            int xValue = (int)((double)this.convertValueToProgressBar(each.getPosition()) / (double)this.getMaximum() * (double)this.getWidth());
            g.drawRect(xValue, 1, 1, each.getLength());
        }
    }

    private void paintIndicators(Graphics g) {
        if (this.showTargetPosition) {
            g.setColor(TARGET_POSITION_COLOR);
            this.renderArrowIndicator(g, Math.round(this.targetPosition * this.getWidth() / this.getMaximum()), Arrow.DOWN);
        }
        if (this.showMovementRangeLimit) {
            g.setColor(RANGE_LIMIT_COLOR);
            if (this.minimum != this.getMinimum()) {
                this.drawIndicator(g, this.minimum);
                this.drawLineFrom(g, 0, this.minimum);
            }
            if (this.maximum != this.getMaximum()) {
                this.drawIndicator(g, this.maximum);
                this.drawLineFrom(g, this.maximum, this.getMaximum());
            }
        }
    }

    protected void renderArrowIndicator(Graphics g, int mark, Arrow direction) {
        Polygon p = new Polygon();
        p.addPoint(++mark - 3, direction.getBase(this));
        p.addPoint(mark, (int)((double)this.getHeight() * 0.5));
        p.addPoint(mark + 3, direction.getBase(this));
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillPolygon(p);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    protected void drawIndicator(Graphics g, int indicator) {
        int xPos = this.getWidth() * indicator / this.getMaximum();
        g.fillRect(xPos - 1, 1, 2, this.getHeight() - 2);
    }

    private void drawLineFrom(Graphics g, int start, int end) {
        int startX = this.getWidth() * start / this.getMaximum();
        int endX = this.getWidth() * end / this.getMaximum();
        g.fillRect(startX, this.getHeight() / 2 - 2, endX - startX, 4);
    }

    private int convertValueToProgressBar(double givenValue) {
        if (this.isFixedRange()) {
            double ratio = (givenValue - this.minimumJointPosition()) / (this.maximumJointPosition() - this.minimumJointPosition());
            return (int)Math.round(ratio * (double)(this.getMaximum() - this.getMinimum()));
        }
        double maximumVisibleJointPosition = this.actualValue + Math.PI * 2;
        double minimumVisibleJointPosition = this.actualValue + Math.PI * -2;
        double ratio = (givenValue - minimumVisibleJointPosition) / (maximumVisibleJointPosition - minimumVisibleJointPosition);
        return (int)Math.round(ratio * (double)(this.getMaximum() - this.getMinimum()));
    }

    private double maximumJointPosition() {
        if (this.configurationService == null) {
            return Math.PI * 2;
        }
        return this.configurationService.getMaximumJointLimit(this.selectedJointType);
    }

    private double minimumJointPosition() {
        if (this.configurationService == null) {
            return Math.PI * -2;
        }
        return this.configurationService.getMinimumJointLimit(this.selectedJointType);
    }

    private static class Tick {
        private double position;
        private int length;

        public Tick(double position, int length) {
            this.position = position;
            this.length = length;
        }

        public void movePosition(double moveBy) {
            if (this.position - moveBy >= Math.PI * 2) {
                this.position -= Math.PI * 4;
            } else if (this.position - moveBy <= Math.PI * -2) {
                this.position += Math.PI * 4;
            }
        }

        public double getPosition() {
            return this.position;
        }

        public int getLength() {
            return this.length;
        }
    }

    private static class Ruler
    implements Iterable<Tick> {
        List<Tick> ticks = new ArrayList<Tick>();

        public Ruler() {
            double doublePi = Math.PI * 2;
            this.ticks.add(new Tick(-doublePi, 10));
            this.ticks.add(new Tick(-doublePi / 4.0 * 3.0, 3));
            this.ticks.add(new Tick(-doublePi / 2.0, 5));
            this.ticks.add(new Tick(-doublePi / 4.0, 3));
            this.ticks.add(new Tick(0.0, 10));
            this.ticks.add(new Tick(doublePi / 4.0, 3));
            this.ticks.add(new Tick(doublePi / 2.0, 5));
            this.ticks.add(new Tick(doublePi / 4.0 * 3.0, 3));
            this.ticks.add(new Tick(doublePi, 10));
        }

        public void adjustRuler(double xOffset) {
            for (Tick each : this.ticks) {
                each.movePosition(xOffset);
            }
        }

        @Override
        public Iterator<Tick> iterator() {
            return this.ticks.iterator();
        }
    }

    public static enum Arrow {
        UP{

            @Override
            public int getBase(JointPositionIndicator indicator) {
                return indicator.getHeight();
            }
        }
        ,
        DOWN{

            @Override
            public int getBase(JointPositionIndicator indicator) {
                return 0;
            }
        };


        public abstract int getBase(JointPositionIndicator var1);
    }
}

