/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.monitor.model.JointType;
import com.ur.move.GridBagConstraintsBuilder;
import com.ur.move.JointPositionIndicator;
import com.ur.move.JointPositionVectorPanel;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.PoseTextFieldMouseListener;
import com.ur.move.RotateWhilePressed;
import com.ur.move.SafetyModeIcon;
import com.ur.move.poseeditor.PoseRequester;
import com.ur.move.resources.LabelImageResource;
import com.ur.polyscope.viewfacade.monitor.SafetyModeChangeService;
import com.ur.swing.LabelUtils;
import com.ur.swing.WhilePressed;
import com.ur.swing.units.Units;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.SafetyMode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.EnumMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class JointPositionPanel
extends JPanel
implements SafetyModeChangeService.SafetyModeListener {
    private final JointPositionIndicator jointPositionIndicator;
    private final JTextField jointPositionField;
    private final JLabel jointRevolutionLabel;
    private JLabel leftLabel;
    private JLabel rightLabel;
    private JLabel leftLabelDisabled;
    private JLabel rightLabelDisabled;
    private EnumMap<JointPositionVectorPanel.ClickEditPose, JLabel> labelMap = new EnumMap(JointPositionVectorPanel.ClickEditPose.class);
    private EnumMap<JointPositionVectorPanel.ClickEditPose, Icon> safetyIconMap = new EnumMap(JointPositionVectorPanel.ClickEditPose.class);
    private EnumMap<JointPositionVectorPanel.ClickEditPose, Icon> selectedIconMap = new EnumMap(JointPositionVectorPanel.ClickEditPose.class);
    private GridBagConstraintsBuilder gbc = new GridBagConstraintsBuilder();

    JointPositionPanel(MoveTabRobotModel robotModel, PoseRequester poseRequester, JointType jointType, String name) {
        this.jointPositionIndicator = new JointPositionIndicator(jointType);
        this.jointPositionField = new JTextField();
        this.jointPositionField.setFocusable(false);
        this.jointPositionField.setEditable(false);
        this.jointPositionField.setPreferredSize(new Dimension(100, 28));
        this.jointPositionField.setHorizontalAlignment(4);
        if (poseRequester != null) {
            this.jointPositionField.addMouseListener(new PoseTextFieldMouseListener(poseRequester, this.jointPositionField, robotModel));
        }
        this.jointRevolutionLabel = new JLabel();
        this.leftLabel = new JLabel();
        this.leftLabel.setName(JointPositionVectorPanel.ClickEditPose.LEFT.componentNameFor(jointType));
        this.rightLabel = new JLabel();
        this.rightLabel.setName(JointPositionVectorPanel.ClickEditPose.RIGHT.componentNameFor(jointType));
        this.leftLabelDisabled = new JLabel();
        this.leftLabelDisabled.setIcon(LabelImageResource.leftArrow3Selected());
        this.rightLabelDisabled = new JLabel();
        this.rightLabelDisabled.setIcon(LabelImageResource.rightArrow3Selected());
        JLabel nameLabel = new JLabel(name);
        this.putInMaps(JointPositionVectorPanel.ClickEditPose.LEFT, this.leftLabel, LabelImageResource.leftArrow3(), LabelImageResource.leftArrow3Yellow(), LabelImageResource.leftArrow3Selected());
        this.putInMaps(JointPositionVectorPanel.ClickEditPose.RIGHT, this.rightLabel, LabelImageResource.rightArrow3(), LabelImageResource.rightArrow3Yellow(), LabelImageResource.rightArrow3Selected());
        for (JointPositionVectorPanel.ClickEditPose direction : JointPositionVectorPanel.ClickEditPose.values()) {
            LabelUtils.bindIconButton((JLabel)this.labelMap.get((Object)direction), (Icon)this.safetyIconMap.get((Object)direction), (Icon)this.selectedIconMap.get((Object)direction), (WhilePressed)new RotateWhilePressed(robotModel, jointType.getJointNumber(), direction.getDirection()));
        }
        this.setLayout(new GridBagLayout());
        this.addButtons();
        this.add((Component)nameLabel, this.gbc.createExpanding(1, 0));
        this.add((Component)this.jointPositionField, this.gbc.createCollapsing(2, 0));
        this.add((Component)new JLabel(Units.getText().unitDegrees()), this.gbc.createCollapsing(3, 0));
        this.add((Component)this.jointPositionIndicator, this.gbc.createCollapsing(1, 1, 3, 1));
        this.gbc.setDefaultAnchor(10);
        this.gbc.setDefaultFill(0);
        this.add((Component)this.jointRevolutionLabel, this.gbc.createCollapsing(0, 2, 5, 1));
        EventNotificationService.register((Object)this, SafetyModeChangeService.SafetyModeListener.class, (Object)this);
    }

    JointPositionIndicator getJointPositionIndicator() {
        return this.jointPositionIndicator;
    }

    JTextField getJointPositionField() {
        return this.jointPositionField;
    }

    JLabel getJointRevolutionLabel() {
        return this.jointRevolutionLabel;
    }

    JLabel getLeftLabel() {
        return this.leftLabel;
    }

    JLabel getRightLabel() {
        return this.rightLabel;
    }

    void updateIcons(SafetyMode newValue) {
        for (JointPositionVectorPanel.ClickEditPose direction : JointPositionVectorPanel.ClickEditPose.values()) {
            ((SafetyModeIcon)this.safetyIconMap.get((Object)direction)).setSafetyMode(newValue);
        }
        this.repaint();
    }

    public void updateAndShowButtons() {
        this.remove(this.leftLabelDisabled);
        this.remove(this.rightLabelDisabled);
        this.addButtons();
        this.revalidate();
        this.repaint();
    }

    public void updateAndShowDisabledButtons() {
        this.remove(this.leftLabel);
        this.remove(this.rightLabel);
        this.addDisabledButtons();
        this.revalidate();
        this.repaint();
    }

    private void addButtons() {
        this.add((Component)this.leftLabel, this.gbc.createCollapsing(0, 0, 1, 1));
        this.add((Component)this.rightLabel, this.gbc.createCollapsing(4, 0, 1, 1));
    }

    private void addDisabledButtons() {
        this.add((Component)this.leftLabelDisabled, this.gbc.createCollapsing(0, 0, 1, 1));
        this.add((Component)this.rightLabelDisabled, this.gbc.createCollapsing(4, 0, 1, 1));
    }

    private void putInMaps(JointPositionVectorPanel.ClickEditPose direction, JLabel jLabel, Icon blueIcon, Icon yellowIcon, Icon selectedIcon) {
        this.labelMap.put(direction, jLabel);
        this.safetyIconMap.put(direction, new SafetyModeIcon(blueIcon, yellowIcon, SafetyMode.NORMAL));
        this.selectedIconMap.put(direction, selectedIcon);
    }

    public void safetyModeChanged(SafetyMode oldValue, SafetyMode newValue) {
        SwingUtilities.invokeLater(() -> this.updateIcons(newValue));
    }
}

