/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.monitor.model.JointType;
import com.ur.move.GridBagConstraintsBuilder;
import com.ur.move.JointPositionIndicator;
import com.ur.move.JointPositionPanel;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.poseeditor.PoseRequester;
import com.ur.move.resources.TextResource;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class JointPositionVectorPanel
extends JPanel {
    private final List<JointPositionPanel> joints = new ArrayList<JointPositionPanel>();

    public JointPositionVectorPanel(ViewContext context, MoveTabRobotModel robotModel) {
        this(context, robotModel, null);
    }

    JointPositionVectorPanel(ViewContext context, MoveTabRobotModel robotModel, PoseRequester poseRequester) {
        TextResource textResource = (TextResource)context.getTextResource(TextResource.class);
        this.joints.add(new JointPositionPanel(robotModel, poseRequester, JointType.BASE, textResource.joint0Name()));
        this.joints.add(new JointPositionPanel(robotModel, poseRequester, JointType.SHOULDER, textResource.joint1Name()));
        this.joints.add(new JointPositionPanel(robotModel, poseRequester, JointType.ELBOW, textResource.joint2Name()));
        this.joints.add(new JointPositionPanel(robotModel, poseRequester, JointType.WRIST1, textResource.joint3Name()));
        this.joints.add(new JointPositionPanel(robotModel, poseRequester, JointType.WRIST2, textResource.joint4Name()));
        this.joints.add(new JointPositionPanel(robotModel, poseRequester, JointType.WRIST3, textResource.joint5Name()));
        this.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder gbc = new GridBagConstraintsBuilder();
        gbc.setDefaultInsets(new Insets(5, 15, 0, 15));
        for (int i = 0; i < this.joints.size(); ++i) {
            this.add((Component)this.joints.get(i), gbc.createCollapsing(0, i));
        }
        this.add(Box.createGlue(), gbc.createExpanding(0, this.joints.size() + 1, 1, 1));
        this.setBorder((Border)new CardBorder(textResource.jointPosition()));
    }

    public List<JointPositionIndicator> getJointPositionIndicators() {
        ArrayList<JointPositionIndicator> r = new ArrayList<JointPositionIndicator>(this.joints.size());
        for (JointPositionPanel p : this.joints) {
            r.add(p.getJointPositionIndicator());
        }
        return r;
    }

    public List<JTextField> getJointPositionFields() {
        ArrayList<JTextField> result = new ArrayList<JTextField>(this.joints.size());
        for (JointPositionPanel p : this.joints) {
            result.add(p.getJointPositionField());
        }
        return result;
    }

    public List<JLabel> getJointRevolutionLabels() {
        ArrayList<JLabel> result = new ArrayList<JLabel>(this.joints.size());
        for (JointPositionPanel p : this.joints) {
            result.add(p.getJointRevolutionLabel());
        }
        return result;
    }

    public void update() {
        this.joints.forEach(JointPositionPanel::updateAndShowButtons);
    }

    public void updateAndShowDisabledButtons() {
        this.joints.forEach(JointPositionPanel::updateAndShowDisabledButtons);
    }

    public static enum ClickEditPose {
        LEFT(-1),
        RIGHT(1);

        private int direction;

        private ClickEditPose(int direction) {
            this.direction = direction;
        }

        public int getDirection() {
            return this.direction;
        }

        public String componentNameFor(JointType type) {
            return "ClickOnPosTo" + this.name() + '.' + (type != null ? type.name() : UUID.randomUUID().toString()) + '.' + JointPositionVectorPanel.class.getSimpleName();
        }
    }
}

