/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.FreedrivePinButton;
import com.ur.move.MoveToAction;
import com.ur.move.SafeHomeMoveToAction;
import com.ur.move.SelectedFeatureListener;
import com.ur.move.automove.AutoMoveTab;
import com.ur.move.automove.AutoMoveTitleComposite;
import com.ur.move.resources.MoveImageResource;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.initializerobot.poweron.PoweredOnRobotRequirement;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.event.EventNotificationService;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MoveTabFooterPanel
extends JPanel
implements SelectedFeatureListener {
    private List<JComponent> requiredComponents = new ArrayList<JComponent>();
    private final JButton safeHomeButton;
    private final JButton alignButton;
    private final CardPanel cardPanel;
    private final SafeHomeMoveToAction safeHomeMoveToAction;
    private final TextResource textResource;
    private static final double ROTATION_EPS = 0.001;
    private GeomFeature selectedFeature;
    private final MessageDialogCreator dialogCreator;
    private final InverseKinematicProviderExt inverseKinematicProviderExt;

    MoveTabFooterPanel(PoweredOnRobotRequirement poweredOnRobotRequirement, CardPanel cardPanel, ViewContext viewContext, SafeHomeMoveToAction safeHomeMoveToAction, FeaturesLookup featuresLookup, MessageDialogCreator dialogCreator, FreedrivePinButton freedrivePinButton, InverseKinematicProviderExt inverseKinematicProviderExt) {
        this.cardPanel = cardPanel;
        this.safeHomeMoveToAction = safeHomeMoveToAction;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.dialogCreator = dialogCreator;
        this.inverseKinematicProviderExt = inverseKinematicProviderExt;
        this.safeHomeButton = this.createMoveToButton(poweredOnRobotRequirement, safeHomeMoveToAction);
        AlignMoveToActionProvider alignMoveToAction = new AlignMoveToActionProvider();
        this.alignButton = this.createMoveToButton(poweredOnRobotRequirement, alignMoveToAction);
        this.requiredComponents.add(this.safeHomeButton);
        this.requiredComponents.add(this.alignButton);
        this.requiredComponents.add(freedrivePinButton);
        this.selectedFeature = featuresLookup.getFeatureContainer().getCameraView();
        EventNotificationService.register((Object)this, SelectedFeatureListener.class, (Object)this);
        this.setLayout(new GridLayout(1, -1, 5, 1));
        this.setPreferredSize(new Dimension(-1, 72));
        this.initButtons();
    }

    private void initButtons() {
        this.removeAll();
        for (JComponent c : this.requiredComponents) {
            this.add(c);
        }
        this.revalidate();
    }

    private JButton createMoveToButton(PoweredOnRobotRequirement poweredOnRobotRequirement, MoveToAction moveToAction) {
        moveToAction.setRobotStateRequirement(poweredOnRobotRequirement);
        moveToAction.setCardPanel(this.cardPanel);
        JButton moveToPositionButton = new JButton(moveToAction);
        moveToPositionButton.setName((String)moveToAction.getValue("InternalName"));
        return moveToPositionButton;
    }

    public void setManualMove(boolean manualMove) {
        if (this.safeHomeMoveToAction.getJointPositionVector() != null) {
            this.safeHomeButton.setEnabled(!manualMove);
            this.alignButton.setEnabled(!manualMove);
        }
    }

    JButton getSafeHomeButton() {
        return this.safeHomeButton;
    }

    JButton getAlignButton() {
        return this.alignButton;
    }

    @Override
    public void featureSelected(GeomFeature selectedFeature) {
        this.selectedFeature = selectedFeature;
    }

    private class AlignMoveToActionProvider
    extends MoveToAction {
        public AlignMoveToActionProvider() {
            super(MoveTabFooterPanel.this.textResource.Align(), MoveImageResource.moveAlign(), "MoveTab.alignButton");
        }

        @Override
        public JointPositionVector getJointPositionVector() {
            Pose6d alignedPose = new Pose6d();
            Pose6d currentPose = RobotState.getLatestRobotState().tool;
            Pose6d poseInFeatureFrame = MoveTabFooterPanel.this.selectedFeature.calculateToolPoseInFeatureCoordinates(currentPose);
            double RXRYLength = Math.sqrt(Math.pow(poseInFeatureFrame.getRX(), 2.0) + Math.pow(poseInFeatureFrame.getRY(), 2.0));
            if (Math.abs(poseInFeatureFrame.getRZ()) < 0.001 && Math.abs(RXRYLength - Math.PI) < 0.005 || Math.abs(poseInFeatureFrame.getRX()) < 0.001 && Math.abs(poseInFeatureFrame.getRY()) < 0.001) {
                return RobotState.getLatestRobotState().jointPosition;
            }
            double newRY = Math.sqrt(Math.pow(Math.PI, 2.0) - Math.pow(poseInFeatureFrame.getRX(), 2.0));
            Pose6d alignedPoseInFeatureFrame1 = new Pose6d(0.0, 0.0, 0.0, poseInFeatureFrame.getRX(), newRY, 0.0);
            Pose6d alignedPoseInFeatureFrame2 = new Pose6d(0.0, 0.0, 0.0, poseInFeatureFrame.getRX(), -1.0 * newRY, 0.0);
            double newRX = Math.sqrt(Math.pow(Math.PI, 2.0) - Math.pow(poseInFeatureFrame.getRY(), 2.0));
            Pose6d alignedPoseInFeatureFrame4 = new Pose6d(0.0, 0.0, 0.0, newRX, poseInFeatureFrame.getRY(), 0.0);
            Pose6d alignedPoseInFeatureFrame5 = new Pose6d(0.0, 0.0, 0.0, -1.0 * newRX, poseInFeatureFrame.getRY(), 0.0);
            Pose6d alignedPose1 = MoveTabFooterPanel.this.selectedFeature.transformPoseInFeatureFrameToPoseInBaseFrame(alignedPoseInFeatureFrame1);
            alignedPose1.setPos(currentPose.getPos());
            Pose6d alignedPose2 = MoveTabFooterPanel.this.selectedFeature.transformPoseInFeatureFrameToPoseInBaseFrame(alignedPoseInFeatureFrame2);
            alignedPose2.setPos(currentPose.getPos());
            Pose6d alignedPose4 = MoveTabFooterPanel.this.selectedFeature.transformPoseInFeatureFrameToPoseInBaseFrame(alignedPoseInFeatureFrame4);
            alignedPose4.setPos(currentPose.getPos());
            Pose6d alignedPose5 = MoveTabFooterPanel.this.selectedFeature.transformPoseInFeatureFrameToPoseInBaseFrame(alignedPoseInFeatureFrame5);
            alignedPose5.setPos(currentPose.getPos());
            Pose6d alignedPoseInFeatureFrame3 = new Pose6d(0.0, 0.0, 0.0, 0.0, 0.0, poseInFeatureFrame.getRZ());
            Pose6d alignedPose3 = MoveTabFooterPanel.this.selectedFeature.transformPoseInFeatureFrameToPoseInBaseFrame(alignedPoseInFeatureFrame3);
            alignedPose3.setPos(currentPose.getPos());
            Pose6d[] poseArray = new Pose6d[]{alignedPose1, alignedPose2, alignedPose3, alignedPose4, alignedPose5};
            alignedPose.set(this.getClosestPose6d(currentPose, poseArray));
            return MoveTabFooterPanel.this.inverseKinematicProviderExt.getInverseKinematics(alignedPose, RobotState.getLatestRobotState().jointPosition);
        }

        private Pose6d getClosestPose6d(Pose6d currentPose, Pose6d[] poseArr) {
            if (poseArr == null || currentPose == null) {
                return null;
            }
            Pose6d closestPose = poseArr[0];
            double closestDistance = Pose6dTransformUtils.aggregatedDistanceTo((Pose6d)currentPose, (Pose6d)closestPose);
            for (int i = 0; i < poseArr.length; ++i) {
                if (!(Pose6dTransformUtils.aggregatedDistanceTo((Pose6d)currentPose, (Pose6d)poseArr[i]) < closestDistance)) continue;
                closestPose = poseArr[i];
                closestDistance = Pose6dTransformUtils.aggregatedDistanceTo((Pose6d)currentPose, (Pose6d)closestPose);
            }
            return closestPose;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.robotStateRequirement.checkAndNotify()) {
                JointPositionVector jointPositionVector = this.getJointPositionVector();
                if (jointPositionVector != null) {
                    AutoMoveTitleComposite composite = new AutoMoveTitleComposite(jointPositionVector, MoveTabFooterPanel.this.textResource.alignedZAxis());
                    this.cardPanel.stackCurrentCardAndSwitchTo(AutoMoveTab.class, (Object)composite);
                } else {
                    MoveTabFooterPanel.this.dialogCreator.showMessageDialog(new DialogMessage(MoveTabFooterPanel.this.textResource.Message(), MoveTabFooterPanel.this.textResource.unreachablePose()), MessageDialogType.MESSAGE, new OkDialogListener());
                }
            }
        }
    }
}

