/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.ControllerSocketSender;
import com.ur.move.MoveTab;
import com.ur.move.MoveTabCardPanel;
import com.ur.move.MoveTabPointStrategy;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.OKCancelConfirmationListener;
import com.ur.move.poseeditor.PoseRequester;
import com.ur.polyscope.move.legacy.MoveCallback;
import com.ur.polyscope.simulation.RobotDeviceService;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.swing.SwingUtil;
import com.ur.swing.ValueRequest;
import com.ur.swing.aspects.UIInvokeAndWait;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import java.util.Set;
import java.util.Stack;

public abstract class MoveTabPanel
extends MoveTabCardPanel
implements OKCancelConfirmationListener {
    private final RobotDeviceService robotDeviceService;
    private Set<MoveTabPointStrategy> strategySet;
    private final MoveTabRobotModel robotModel;
    private final PoseRequester poseRequester;
    private final Stack<Object> pointerToReturnPositionNodeStack = new Stack();

    protected MoveTabPanel(Set<MoveTabPointStrategy> strategySet, RobotDeviceService robotDeviceService, MoveTabRobotModel robotModel, EventManager eventManager, PoseRequester poseRequester) {
        this.strategySet = strategySet;
        this.robotModel = robotModel;
        this.poseRequester = poseRequester;
        this.robotDeviceService = robotDeviceService;
        poseRequester.setCardPanel(this);
        eventManager.addStrongListener(ProgramEventListener.class, (Object)new ProgramEventListener.Template(){

            @UIInvokeAndWait
            public void onPostNewProgram() {
                MoveTabPanel.this.pointerToReturnPositionNodeStack.clear();
            }
        });
    }

    protected Set<MoveTabPointStrategy> getStrategySet() {
        return this.strategySet;
    }

    public abstract void setOKCancelEnabled(boolean var1, boolean var2);

    public abstract void clearButtons();

    public abstract void showOkPanel();

    public abstract void showOkCancelPanel();

    public RobotDeviceService getRobotDeviceService() {
        return this.robotDeviceService;
    }

    public MoveTabRobotModel getRobotModel() {
        return this.robotModel;
    }

    public PoseRequester getPoseRequester() {
        return this.poseRequester;
    }

    public void push(Object o) {
        this.pointerToReturnPositionNodeStack.push(o);
    }

    int getStackSize() {
        return this.pointerToReturnPositionNodeStack.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void okAction() {
        if (!this.isVisible()) {
            return;
        }
        if (this.pointerToReturnPositionNodeStack.size() > 0) {
            Object o = this.pointerToReturnPositionNodeStack.pop();
            RobotState robotState = RobotState.getLatestRobotState();
            if (o instanceof MoveCallback) {
                try {
                    final Pose6d pose = robotState.tool;
                    final JointPositionVector jointPositionVector = robotState.targetJointPosition;
                    final Pose6d tcpOffset = robotState.tcpOffset;
                    final MoveCallback laterCallback = (MoveCallback)o;
                    SwingUtil.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            laterCallback.onOk(pose, jointPositionVector, tcpOffset);
                        }
                    });
                }
                finally {
                    this.pointerToReturnPositionNodeStack.clear();
                }
            } else {
                for (MoveTabPointStrategy each : this.strategySet) {
                    if (!each.useStrategy(o)) continue;
                    each.setPosition(o, robotState);
                }
            }
        }
        this.navigateBack();
    }

    @Override
    public void cancelAction() {
        if (!this.isVisible()) {
            return;
        }
        if (this.pointerToReturnPositionNodeStack.size() > 0) {
            Object o = this.pointerToReturnPositionNodeStack.pop();
            if (o instanceof ValueRequest) {
                ValueRequest valueRequest = (ValueRequest)o;
                valueRequest.setReturnValue(null);
                this.navigateBack();
                valueRequest.returned();
                return;
            }
            if (o instanceof MoveCallback) {
                try {
                    final MoveCallback laterCallback = (MoveCallback)o;
                    SwingUtil.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            laterCallback.onCancel();
                        }
                    });
                }
                finally {
                    this.pointerToReturnPositionNodeStack.clear();
                }
            }
        }
        this.navigateBack();
    }

    void makeSureRealRobotIsActivated() {
        try {
            ControllerSocketSender.setRealRobotBlocking();
            if (this.robotDeviceService != null) {
                this.robotDeviceService.addSimulatedDeviceVeto(MoveTab.class);
            }
        }
        catch (Exception e) {
            Log.error((String)"Could not send \"set real\" to controller", (Throwable)e);
        }
    }

    void setJoggableGeomFeatureWithoutTransition(ViewableGeomFeature newJoggableGeomFeature) {
        if (newJoggableGeomFeature != null && this.getRobotModel().getJoggableGeomFeature() != newJoggableGeomFeature) {
            this.getRobotModel().setJoggableGeomFeature(newJoggableGeomFeature);
            this.getRobotModel().setJoggableFeatureWithTransitionEnabled(false);
        }
    }

    boolean isPoseEditorCallback() {
        return this.getPoseRequester().getPoseRequest() != null;
    }
}

