/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.RobotMode;
import com.ur.move.AcceptOrCancelJ3DRenderer;
import com.ur.move.AcceptOrCancelRenderer;
import com.ur.move.AcceptOrCancelSwingRenderer;
import com.ur.move.ControllerSocketSender;
import com.ur.move.FeatureComboBoxPopupListener;
import com.ur.move.FeatureSelectionListener;
import com.ur.move.FreedrivePinButton;
import com.ur.move.JointPaintStrategy;
import com.ur.move.JointPositionIndicator;
import com.ur.move.MoveBehavior;
import com.ur.move.MoveTab;
import com.ur.move.MoveTabFooterPanel;
import com.ur.move.MoveTabPanel;
import com.ur.move.MoveTabPointStrategy;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.MoveTabRobotView;
import com.ur.move.MoveToolPanel;
import com.ur.move.PositionPanel;
import com.ur.move.RequestManualMove;
import com.ur.move.RobotStateView;
import com.ur.move.SafeHomeMoveToAction;
import com.ur.move.freedrive.DisableJogWhenInFreedrive;
import com.ur.move.poseeditor.PoseRequester;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.initializerobot.poweron.PoweredOnRobotRequirement;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.move.legacy.MoveCallback;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.joint.JointPositionRangeProvider;
import com.ur.polyscope.simulation.RobotDeviceService;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomRenderer;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.panel.ElementsVisualizerAggregator;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.SafetyMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Set;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

@Singleton
@ExtensionPoint(value="MoveFooter")
public class MoveTabPanelImpl
extends MoveTabPanel {
    public static final String MOVE_TAB_PANEL_ROBOT_VIEW = "G5MoveTabPanel.MoveTabRobotView";
    private final MoveTabRobotView robotView;
    private final MoveToolPanel moveToolPanel;
    private final PositionPanel positionPanel;
    private final MoveTabFooterPanel footerPanel;
    private final Set<MoveTabPointStrategy> strategySet;
    private final InstallationComponentLookup installationLookup;
    private final JointPaintStrategy paintJointsStrategy;
    private final AcceptOrCancelRenderer acceptOrCancelRenderer;
    private final RobotStateView robotStateView;
    private JointPositionVector shadowJPV;
    private final Stack<Object> enterObjects = new Stack();

    @Inject
    public MoveTabPanelImpl(Set<MoveTabPointStrategy> strategySet, ViewContext viewContext, FeaturesLookup featuresLookup, JointPositionRangeProvider rangeProvider, ElementsVisualizerAggregator elementsVisualizerAggregator, JointConfigurationSettings settings, InstallationComponentLookup installationLookup, RobotDeviceService robotDeviceService, MoveTabRobotModel robotModel, EventManager eventManager, PoweredOnRobotRequirement poweredOnRobotRequirement, PoseRequester poseRequester, RobotCanvas3DFactory robotCanvas3DFactory, SafeHomeMoveToAction safeHomeMoveToAction, ControllerInterface controllerInterface, MessageDialogCreator dialogCreator, FreedrivePinButton freedrivePinButton, InverseKinematicProviderExt inverseKinematicProviderExt, @Source(value=RobotMode.class) Recipe<RobotMode> robotModeRecipe) {
        super(strategySet, robotDeviceService, robotModel, eventManager, poseRequester);
        this.strategySet = strategySet;
        this.installationLookup = installationLookup;
        this.positionPanel = new PositionPanel(viewContext, this.getRobotModel(), this.getPoseRequester());
        this.moveToolPanel = new MoveToolPanel(viewContext, this.getRobotModel(), controllerInterface, robotModeRecipe);
        this.footerPanel = new MoveTabFooterPanel(poweredOnRobotRequirement, this, viewContext, safeHomeMoveToAction, featuresLookup, dialogCreator, freedrivePinButton, inverseKinematicProviderExt);
        this.robotView = new MoveTabRobotView(elementsVisualizerAggregator, this.getRobotModel(), robotCanvas3DFactory, false, controllerInterface, "G5 Move 3D Canvas");
        this.robotView.setName(MOVE_TAB_PANEL_ROBOT_VIEW);
        this.robotStateView = new RobotStateView(viewContext, this.getRobotModel(), featuresLookup, new FeatureSelectionListener(this.moveToolPanel, robotModel, this.robotView.getRobotCanvas3D(), this.robotView.getProgramVisualization()), new FeatureComboBoxPopupListener(this.positionPanel, this.moveToolPanel));
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        RobotCanvas3D robotCanvas3D = this.robotView.getRobotCanvas3D();
        this.acceptOrCancelRenderer = robotCanvas3D.isActualCanvas() ? new AcceptOrCancelJ3DRenderer(this, textResource, robotCanvas3D.getComponent()) : new AcceptOrCancelSwingRenderer(this, textResource);
        robotCanvas3D.addJ3DComponent((J3DComponent)this.acceptOrCancelRenderer);
        for (MoveTabPointStrategy each : strategySet) {
            if (!each.hasVisualComponent()) continue;
            robotCanvas3D.addJ3DComponent(each.getComponent());
        }
        robotCanvas3D.addJ3DComponent((J3DComponent)new ZoomRenderer(robotCanvas3D.getComponent(), (ViewBehaviorHolder)this.getRobotModel()));
        this.robotView.setBorder((Border)new CardBorder(textResource.Robot()));
        robotCanvas3D.showStaticElements(Arrays.asList(VisualizerElementType.CONSTRAINED_FREE_DRIVE, VisualizerElementType.PAYLOAD_COG, VisualizerElementType.TCP, VisualizerElementType.SAFETY_SPHERES));
        this.paintJointsStrategy = new JointPaintStrategy(rangeProvider, this.positionPanel.getJointPositionIndicators().toArray(new JointPositionIndicator[this.positionPanel.getJointPositionIndicators().size()]), this.positionPanel.getJointPositionFields().toArray(new JTextField[this.positionPanel.getJointPositionFields().size()]), this.positionPanel.getToolPositionFields().toArray(new JTextField[this.positionPanel.getToolPositionFields().size()]), this.positionPanel.getJointRevolutionLabels().toArray(new JLabel[this.positionPanel.getJointRevolutionLabels().size()]));
        this.paintJointsStrategy.setConfigurationSettings(settings);
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.setBorder(new MatteBorder(5, 5, 5, 5, G5LookAndFeel.BETWEEN_CARD_COLOR));
        this.add(this.moveToolPanel, "West");
        this.add(this.robotView, "Center");
        this.add(this.positionPanel, "East");
        this.robotView.add((Component)this.robotStateView.getPanel(), "North");
        this.robotView.add((Component)this.footerPanel, "South");
        this.initHelpIds((HelpIdAssigner)viewContext.getHelpIdAssigner());
        DisableJogWhenInFreedrive disableJogWhenInFreedrive = new DisableJogWhenInFreedrive(this.moveToolPanel, this.positionPanel);
        robotModeRecipe.executeOnUIThread().forEach((Consumer)disableJogWhenInFreedrive);
    }

    private void initHelpIds(HelpIdAssigner helpIdAssigner) {
        helpIdAssigner.assignHelpId((JComponent)this.moveToolPanel, "gui:movetab_translatetool");
        helpIdAssigner.assignHelpId((JComponent)this.positionPanel.getToolPositionPanel().getPanel(), "gui:movetab_feature");
        helpIdAssigner.assignHelpId((JComponent)this.positionPanel.getJointPositionVectorPanel(), "gui:movetab_jointcontrol");
        helpIdAssigner.assignHelpId((JComponent)this.footerPanel.getSafeHomeButton(), "gui:movetab_home");
        helpIdAssigner.assignHelpId((JComponent)this.footerPanel.getAlignButton(), "gui:movetab_align");
        helpIdAssigner.assignHelpId((JComponent)this.robotView, "gui:movetab_3drobot");
    }

    public void enter(Object o) {
        super.enter(o);
        this.setVisible(true);
        this.showGotoInitializeRobotIfRobotNotRunning();
        this.handleEnterObject(o);
        this.shadowJPV = null;
        this.makeSureRealRobotIsActivated();
        this.paintJointsStrategy.paintJointLimits(RobotState.getLatestRobotState().reducedModeActive, true);
        this.robotView.updateRobotState(RobotState.getLatestRobotState());
        this.getRobotModel().setDisplayedTCP(((TCPSettings)this.installationLookup.getComponent(TCPSettings.class)).getActiveTCP());
        if (o != null) {
            this.getRobotModel().stopProgramBeforeMove();
        }
        boolean isComingBack = this.initializeMovetab(o, true);
        this.checkIfReentering(o, isComingBack);
        if (this.getRobotModel().getDisplayedTCP() != null) {
            this.robotStateView.setDisplayedTCP(this.getRobotModel().getDisplayedTCP().getDisplayName());
        }
        if (this.isPoseEditorCallback()) {
            this.setJoggableGeomFeatureWithoutTransition(this.getPoseRequester().getPoseRequest().getJoggableGeomFeature());
        } else {
            this.getRobotModel().setShadow(this.shadowJPV);
        }
        this.robotStateView.updateFeatureComboboxWithCurrentInstallation();
        this.getRobotModel().setJoggableFeatureWithTransitionEnabled(false);
        this.getRobotModel().setLongArrowsEnabled(true);
        this.getPoseRequester().setCallStackDepth(this.getStackSize());
        this.robotView.enter();
        EventNotificationService.register((Object)this, RobotStateListener.class, (Object)new MoveTabRobotStateListener());
        this.getPoseRequester().handlePoseRequests();
    }

    private void showGotoInitializeRobotIfRobotNotRunning() {
        if (!RobotState.getLatestRobotState().hasReceivedPositionData) {
            this.getRobotModel().runningRobotRequirement().checkAndNotify();
        }
    }

    private void handleEnterObject(Object o) {
        if (o != null) {
            if (this.isReenteringMovePanel()) {
                this.handleReentringMovePanel(o);
            } else {
                this.enterObjects.push(o);
            }
        } else if (this.isReturningToMoveTab()) {
            this.enterObjects.pop();
        }
    }

    private boolean isReenteringMovePanel() {
        return !this.enterObjects.empty();
    }

    private void handleReentringMovePanel(Object enterObject) {
        if (this.isEnterObjectTypeTheSameAsLast(enterObject)) {
            if (!this.isSteppingBackFromSameMoveTab(enterObject)) {
                this.enterObjects.push(enterObject);
            }
        } else {
            this.enterObjects.push(enterObject);
        }
    }

    private boolean isEnterObjectTypeTheSameAsLast(Object enterObject) {
        return this.enterObjects.peek().getClass() == enterObject.getClass();
    }

    private boolean isSteppingBackFromSameMoveTab(Object enterObject) {
        return this.enterObjects.peek().equals(enterObject);
    }

    private boolean isReturningToMoveTab() {
        return this.enterObjects.size() > this.getStackSize();
    }

    private void checkIfReentering(Object o, boolean isComingBack) {
        if (o == null && !this.enterObjects.isEmpty() && isComingBack) {
            this.initializeMovetab(this.enterObjects.peek(), false);
        }
    }

    private boolean initializeMovetab(Object o, boolean isOpenedAsNewPanel) {
        if (o instanceof RequestManualMove) {
            this.footerPanel.setManualMove(true);
            o = ((RequestManualMove)o).getValueContained();
            this.paintJointsStrategy.setEnabledOnAllTextFields(false);
            if (isOpenedAsNewPanel) {
                this.getPoseRequester().cancelPoseRequest();
            }
        } else {
            this.footerPanel.setManualMove(false);
            this.paintJointsStrategy.setEnabledOnAllTextFields(true);
        }
        boolean foundStrategy = false;
        for (MoveTabPointStrategy each : this.strategySet) {
            if (!each.useStrategy(o)) continue;
            this.shadowJPV = each.getShadowJPV(o);
            each.onEnter(o, this.paintJointsStrategy, this);
            if (isOpenedAsNewPanel) {
                this.push(o);
            }
            foundStrategy = true;
            break;
        }
        if (!foundStrategy) {
            if (o instanceof MoveCallback) {
                this.paintJointsStrategy.hideTargetPositions();
                if (isOpenedAsNewPanel) {
                    this.push(o);
                }
                this.showOkCancelPanel();
            } else if (o != null) {
                Log.error((String)("Class of argument not supported: " + o.getClass() + " :  Strategies " + Arrays.toString(this.strategySet.toArray())), (Throwable)new Exception());
                this.paintJointsStrategy.hideTargetPositions();
                if (isOpenedAsNewPanel) {
                    this.push(null);
                }
                this.showOkPanel();
            } else {
                if (this.getStackSize() > 0) {
                    this.paintJointsStrategy.hideTargetPositions();
                    this.showOkCancelPanel();
                    this.getRobotModel().setDisplayedTCP(null);
                    return true;
                }
                this.paintJointsStrategy.hideTargetPositions();
                this.clearButtons();
            }
        }
        return false;
    }

    @Override
    public void clearButtons() {
        this.acceptOrCancelRenderer.showButtons(false, false);
    }

    @Override
    public void showOkPanel() {
        this.acceptOrCancelRenderer.showButtons(true, false);
    }

    @Override
    public void showOkCancelPanel() {
        this.acceptOrCancelRenderer.showButtons(true, true);
        this.acceptOrCancelRenderer.setEnabled(true, true);
    }

    public Object exit() {
        if (this.getRobotModel().getMoveBehavior() != MoveBehavior.NO_MOVING) {
            ControllerSocketSender.sendStopProgram();
            this.getRobotModel().setMoveBehavior(MoveBehavior.NO_MOVING);
        }
        this.setOKCancelEnabled(true, false);
        this.clearButtons();
        this.getRobotModel().setJoggableFeatureWithTransitionEnabled(false);
        EventNotificationService.unregister((Object)this, RobotStateListener.class);
        if (this.getStackSize() == 0 && !this.enterObjects.isEmpty()) {
            this.enterObjects.clear();
        }
        if (this.getRobotDeviceService() != null) {
            this.getRobotDeviceService().removeSimulatedDeviceVeto(MoveTab.class);
        }
        for (MoveTabPointStrategy each : this.strategySet) {
            each.onExit();
        }
        this.robotView.exit();
        this.setVisible(false);
        return super.exit();
    }

    @Override
    public void setOKCancelEnabled(boolean okButtonEnabled, boolean cancelButtonEnabled) {
        this.acceptOrCancelRenderer.setEnabled(okButtonEnabled, cancelButtonEnabled);
    }

    private class MoveTabRobotStateListener
    implements RobotStateListener {
        private boolean performUpdateOfTextField = true;

        private MoveTabRobotStateListener() {
        }

        public void updateRobotState(RobotState rs) {
            this.performUpdateOfTextField = !this.performUpdateOfTextField;
            JointPositionVector jpv = rs.jointPosition;
            MoveTabPanelImpl.this.robotView.updateRobotState(rs);
            MoveTabPanelImpl.this.paintJointsStrategy.setEnabledOnAllTextFields(rs.masterSafetyState != SafetyMode.RECOVERY);
            MoveTabPanelImpl.this.paintJointsStrategy.paintJointLimits(rs.reducedModeActive, false);
            MoveTabPanelImpl.this.paintJointsStrategy.setPositionsValues(jpv);
            if (this.performUpdateOfTextField) {
                MoveTabPanelImpl.this.paintJointsStrategy.paintJointText(jpv, rs.reducedModeActive);
            }
            if (MoveTabPanelImpl.this.getRobotModel().getJoggableGeomFeature() != null && this.performUpdateOfTextField) {
                Pose6d toolPoseInBaseCoordinates = new Pose6d(rs.tool);
                Pose6d currentFeaturePose = MoveTabPanelImpl.this.getRobotModel().getJoggableGeomFeature().calculateToolPoseInFeatureCoordinates(toolPoseInBaseCoordinates);
                MoveTabPanelImpl.this.positionPanel.updateFeaturePose(currentFeaturePose);
            }
        }
    }
}

