/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.requirements.RunningRobotRequirement;
import com.ur.move.ControllerSocketSender;
import com.ur.move.MoveBehavior;
import com.ur.polyscope.initializerobot.poweron.PoweredOnRobotRequirement;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.tcp.TCP;
import com.ur.polyscope.viewfacade.program.ProgramUiControl;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehavior;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.util.logging.Log;
import javax.inject.Inject;

public class MoveTabRobotModel
implements ViewBehaviorHolder {
    private static final double MIN_TIME = 100.0;
    private final RunningRobotRequirement runningRobotRequirement;
    private final JointConfigurationSettings configuration;
    private final ProgramUiControl programUiControl;
    private ViewBehavior viewBehavior = ViewBehavior.NONE;
    private MoveBehavior moveBehavior = MoveBehavior.NO_MOVING;
    private boolean joggableFeatureWithTransitionEnabled = false;
    private JointPositionVector shadow;
    private ViewableGeomFeature joggableGeomFeature;
    private TCP displayedTCP;
    private PoweredOnRobotRequirement poweredOnRobotRequirement;
    private boolean longArrows = false;

    @Inject
    public MoveTabRobotModel(RunningRobotRequirement runningRobotRequirement, PoweredOnRobotRequirement poweredOnRobotRequirement, JointConfigurationSettings configuration, ProgramUiControl programUiControl) {
        this.runningRobotRequirement = runningRobotRequirement;
        this.poweredOnRobotRequirement = poweredOnRobotRequirement;
        this.configuration = configuration;
        this.programUiControl = programUiControl;
    }

    private static double getMaxValue(double[] testValues) {
        if (testValues == null || testValues.length == 0) {
            Log.error((String)"Array argument was either null or empty, returning 0.0");
            return 0.0;
        }
        double maxVal = testValues[0];
        for (double testValue : testValues) {
            if (!(testValue > maxVal)) continue;
            maxVal = testValue;
        }
        return maxVal;
    }

    public ViewBehavior getViewBehavior() {
        return this.viewBehavior;
    }

    public void setViewBehavior(ViewBehavior viewBehavior) {
        this.viewBehavior = viewBehavior;
    }

    public MoveBehavior getMoveBehavior() {
        return this.moveBehavior;
    }

    public void setMoveBehavior(MoveBehavior moveBehavior) {
        this.moveBehavior = moveBehavior;
    }

    public boolean isJoggableFeatureWithTransitionEnabled() {
        return this.joggableFeatureWithTransitionEnabled;
    }

    public void setJoggableFeatureWithTransitionEnabled(boolean joggableFeatureWithTransitionEnabled) {
        this.joggableFeatureWithTransitionEnabled = joggableFeatureWithTransitionEnabled;
    }

    public boolean isLongArrowsEnabled() {
        return this.longArrows;
    }

    public void setLongArrowsEnabled(boolean longArrowsEnabled) {
        this.longArrows = longArrowsEnabled;
    }

    public JointPositionVector getShadow() {
        return this.shadow;
    }

    public void setShadow(JointPositionVector shadow) {
        this.shadow = shadow;
    }

    public ViewableGeomFeature getJoggableGeomFeature() {
        return this.joggableGeomFeature;
    }

    public void setJoggableGeomFeature(ViewableGeomFeature joggableGeomFeature) {
        this.joggableGeomFeature = joggableGeomFeature;
    }

    public TCP getDisplayedTCP() {
        return this.displayedTCP;
    }

    public void setDisplayedTCP(TCP displayedTCP) {
        this.displayedTCP = displayedTCP;
    }

    public void jointRotate(int joint, int dir) {
        double speed = 0.2 * (this.configuration.getJointMaxSpeed()[joint] / MoveTabRobotModel.getMaxValue(this.configuration.getJointMaxSpeed()));
        double[] jointSpeed = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        jointSpeed[joint] = speed * (double)dir;
        try {
            ControllerSocketSender.sendSpeedJoint(jointSpeed, 1.5, 100.0);
        }
        catch (Exception e) {
            Log.error((String)"MoveTab.jointRotate() Error: ", (Throwable)e);
        }
        this.moveBehavior = MoveBehavior.JOINT_MOVING;
    }

    public void linearStop() {
        try {
            ControllerSocketSender.sendStopLinear(1.5 / this.ensureNotZeroSquare(RobotState.getLatestRobotState().speedFraction, 5.0));
        }
        catch (Exception e) {
            Log.error((String)"MoveTab.linearStop() Error: ", (Throwable)e);
        }
        this.moveBehavior = MoveBehavior.NO_MOVING;
    }

    private double ensureNotZeroSquare(double speedFraction, double defaultValue) {
        if (speedFraction == 0.0) {
            return defaultValue;
        }
        return Math.pow(speedFraction, 2.0);
    }

    public void jointStop() {
        try {
            ControllerSocketSender.sendStopJoint(1.5 / this.ensureNotZeroSquare(RobotState.getLatestRobotState().speedFraction, 180.0));
        }
        catch (Exception e) {
            Log.error((String)"MoveTab.jointStop() Error: ", (Throwable)e);
        }
        this.moveBehavior = MoveBehavior.NO_MOVING;
    }

    public RunningRobotRequirement runningRobotRequirement() {
        return this.runningRobotRequirement;
    }

    public PoweredOnRobotRequirement poweredOnRobotRequirement() {
        return this.poweredOnRobotRequirement;
    }

    void stopProgramBeforeMove() {
        this.programUiControl.stopProgram();
    }
}

