/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.RobotState;
import com.ur.move.Clear3DCanvasRunnable;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.MoveTabRobotZoomPanel;
import com.ur.move.Render3DCanvasRunnable;
import com.ur.move.Update3DCanvasRunnable;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.URCanvas3DFingerDragViewShifter;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import com.ur.polyscope.visualizer.panel.ElementsVisualizerAggregator;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class MoveTabRobotView
extends JPanel {
    private static final String INKOGNITO = "inkognito";
    private final ElementsVisualizer elementVisualizers;
    private final MoveTabRobotModel robotModel;
    private final RobotCanvas3D robotCanvas3D;
    private final ProgramVisualization programVisualization;
    private ControllerInterface controllerInterface;

    public MoveTabRobotView(ElementsVisualizerAggregator elementVisualizers, MoveTabRobotModel robotModel, RobotCanvas3DFactory robotCanvas3DFactory, boolean zoomPanel, ControllerInterface controllerInterface, String debugCanvasName) {
        this.elementVisualizers = elementVisualizers;
        this.robotModel = robotModel;
        this.robotCanvas3D = robotCanvas3DFactory.buildMetalRobot();
        this.robotCanvas3D.setDebugName(debugCanvasName);
        this.controllerInterface = controllerInterface;
        this.robotCanvas3D.getComponent().setName("robotCanvas.MoveTab");
        JPanel robotPanel = new JPanel();
        robotPanel.setLayout(new BorderLayout());
        robotPanel.add(this.robotCanvas3D.getComponent(), "Center");
        new URCanvas3DFingerDragViewShifter(this.robotCanvas3D);
        this.programVisualization = new ProgramVisualization(this.robotCanvas3D.isActualCanvas());
        if (this.robotCanvas3D.isActualCanvas()) {
            this.robotCanvas3D.addNodeToScene(this.programVisualization.getElementNode());
        }
        this.robotCanvas3D.addNodeToScene(elementVisualizers.getElementNode());
        this.setLayout(new BorderLayout());
        if (zoomPanel) {
            this.add((Component)new MoveTabRobotZoomPanel(robotModel), "North");
        }
        this.add((Component)robotPanel, "Center");
    }

    public void enter() {
        this.elementVisualizers.initialize();
        this.getRobotCanvas3D().enter();
        this.getRobotCanvas3D().setTransitionEnabled(this.robotModel.isJoggableFeatureWithTransitionEnabled());
        this.getRobotCanvas3D().setVisible(this.robotModel.getJoggableGeomFeature(), true);
        this.getRobotCanvas3D().addQueue((Runnable)new Update3DCanvasRunnable(this.robotModel, this));
        this.getRobotCanvas3D().alwaysRun((Runnable)new Render3DCanvasRunnable(this.robotModel, this));
    }

    public void exit() {
        this.getRobotCanvas3D().clearAlwaysRun();
        this.getRobotCanvas3D().addQueue((Runnable)new Clear3DCanvasRunnable(this));
        this.getRobotCanvas3D().addQueue((Runnable)new ClearVisualizationRunnable());
        this.getRobotCanvas3D().setVisible(this.robotModel.getJoggableGeomFeature(), false);
        this.getRobotCanvas3D().exit();
    }

    public void updateRobotState(RobotState robotState) {
        if (!this.controllerInterface.isControllerAvailable() || !robotState.hasReceivedPositionData || robotState.programRunning && !EqualsUtil.equals((Object)robotState.getCurrentProgramName(), (Object)INKOGNITO)) {
            this.elementVisualizers.clearVisualization();
        } else {
            this.elementVisualizers.displayProximity(robotState.tool);
        }
    }

    public ProgramVisualization getProgramVisualization() {
        return this.programVisualization;
    }

    public RobotCanvas3D getRobotCanvas3D() {
        return this.robotCanvas3D;
    }

    private class ClearVisualizationRunnable
    implements Runnable {
        private ClearVisualizationRunnable() {
        }

        @Override
        public void run() {
            MoveTabRobotView.this.elementVisualizers.clearVisualization();
        }
    }
}

