/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.IPositionChangeListener;
import com.ur.util.logging.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.vecmath.Point3d;

public abstract class Position
implements Serializable {
    private transient List<IPositionChangeListener> subscribers = new ArrayList<IPositionChangeListener>();

    @Inject
    public Position() {
    }

    public abstract Position clone();

    public abstract Pose6d getOutputFlangePose();

    public void setSubscribers(List<IPositionChangeListener> subscribers) {
        this.subscribers = subscribers;
    }

    public List<IPositionChangeListener> getSubscribers() {
        return this.subscribers;
    }

    public void subscribeForChanges(IPositionChangeListener listener) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<IPositionChangeListener>();
        }
        this.subscribers.add(listener);
    }

    public void unsubscribeForChanges(IPositionChangeListener listener) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<IPositionChangeListener>();
        }
        if (this.subscribers.contains(listener)) {
            this.subscribers.remove(listener);
        } else {
            Log.error((String)("Position.unsubscribeForChanges() Error: Tried to remove position change subscriber " + listener + " but it was not subscribed."));
        }
    }

    protected void notifyListeners() {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<IPositionChangeListener>();
        }
        ArrayList<IPositionChangeListener> nodesToRemove = new ArrayList<IPositionChangeListener>();
        for (IPositionChangeListener pn : this.subscribers) {
            if (pn.getPositionReference() == this) {
                pn.positionHasChanged();
                continue;
            }
            nodesToRemove.add(pn);
        }
        if (nodesToRemove.size() > 0) {
            this.subscribers.removeAll(nodesToRemove);
        }
    }

    public abstract boolean isUndefined();

    public abstract JointPositionVector getJointPositionVector();

    public abstract Point3d getToolPosition();

    public abstract Point3d getToolAxisAngle();
}

