/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.monitor.model.Pose6d;
import com.ur.move.JointPositionIndicator;
import com.ur.move.JointPositionVectorPanel;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.ToolPositionPanel;
import com.ur.move.poseeditor.PoseRequester;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PositionPanel
extends JPanel {
    private final ToolPositionPanel toolPositionPanel;
    private final JointPositionVectorPanel jointPositionVectorPanel;

    public PositionPanel(ViewContext context, MoveTabRobotModel robotModel, PoseRequester poseRequester) {
        this.toolPositionPanel = new ToolPositionPanel(context, robotModel, poseRequester);
        this.jointPositionVectorPanel = new JointPositionVectorPanel(context, robotModel, poseRequester);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(380, -1));
        this.setMinimumSize(new Dimension(380, -1));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.add((Component)this.toolPositionPanel.getPanel(), "North");
        this.add((Component)this.jointPositionVectorPanel, "Center");
    }

    public List<JTextField> getToolPositionFields() {
        return this.toolPositionPanel.getToolPositionFields();
    }

    public List<JointPositionIndicator> getJointPositionIndicators() {
        return this.jointPositionVectorPanel.getJointPositionIndicators();
    }

    public List<JTextField> getJointPositionFields() {
        return this.jointPositionVectorPanel.getJointPositionFields();
    }

    public List<JLabel> getJointRevolutionLabels() {
        return this.jointPositionVectorPanel.getJointRevolutionLabels();
    }

    public void updateFeaturePose(Pose6d featurePose) {
        this.toolPositionPanel.updateFeaturePose(featurePose);
    }

    public ToolPositionPanel getToolPositionPanel() {
        return this.toolPositionPanel;
    }

    public JointPositionVectorPanel getJointPositionVectorPanel() {
        return this.jointPositionVectorPanel;
    }

    public void update() {
        this.jointPositionVectorPanel.update();
    }

    public void updateAndShowDisabledButtons() {
        this.jointPositionVectorPanel.updateAndShowDisabledButtons();
    }
}

