/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.monitor.RobotState;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.MoveTabRobotView;
import com.ur.util.logging.Log;

public final class Render3DCanvasRunnable
implements Runnable {
    private final MoveTabRobotView robot3D;
    private final MoveTabRobotModel robotModel;
    private RobotState lastRS = null;

    Render3DCanvasRunnable(MoveTabRobotModel robotModel, MoveTabRobotView robotView) {
        this.robotModel = robotModel;
        this.robot3D = robotView;
    }

    @Override
    public void run() {
        RobotState rs = RobotState.getLatestRobotState();
        if (rs == this.lastRS) {
            return;
        }
        this.lastRS = rs;
        this.robot3D.getRobotCanvas3D().setJointAngleVector(rs.jointPosition);
        this.robotModel.getJoggableGeomFeature().setTransformAccordingToRobotState(rs.tool);
        switch (this.robotModel.getViewBehavior()) {
            case NONE: {
                break;
            }
            case ZOOMING_IN: {
                this.robotModel.getJoggableGeomFeature().moveView(-0.05, 0.0, 0.0);
                break;
            }
            case ZOOMING_OUT: {
                this.robotModel.getJoggableGeomFeature().moveView(0.05, 0.0, 0.0);
                break;
            }
            case PANNING_LEFT: {
                this.robotModel.getJoggableGeomFeature().moveView(0.0, -0.05, 0.0);
                break;
            }
            case PANNING_RIGHT: {
                this.robotModel.getJoggableGeomFeature().moveView(0.0, 0.05, 0.0);
                break;
            }
            case PANNING_UP: {
                this.robotModel.getJoggableGeomFeature().moveView(0.0, 0.0, 0.025);
                break;
            }
            case PANNING_DOWN: {
                this.robotModel.getJoggableGeomFeature().moveView(0.0, 0.0, -0.025);
                break;
            }
            default: {
                Log.warning((String)("Value of viewBehavior = " + this.robotModel.getViewBehavior() + " not supported"));
            }
        }
    }
}

