/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.lang.react.Consumer;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.monitor.model.RobotMode;
import com.ur.move.AbstractRotateToolPanel;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.RotateToolWhilePressed;
import com.ur.move.SafetyModeIcon;
import com.ur.move.TCPDirection;
import com.ur.move.resources.LabelImageResource;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.viewfacade.monitor.SafetyModeChangeService;
import com.ur.swing.LabelUtils;
import com.ur.swing.WhilePressed;
import com.ur.swing.g5.CardBorder;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.ControlMode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class RotateToolPanel
extends AbstractRotateToolPanel
implements SafetyModeChangeService.SafetyModeListener,
Consumer<RobotMode> {
    private static final List<TCPDirection> USED_DIRECTIONS = Arrays.asList(TCPDirection.RXMINUS, TCPDirection.RXPLUS, TCPDirection.RYMINUS, TCPDirection.RYPLUS, TCPDirection.RZMINUS, TCPDirection.RZPLUS);
    private final EnumMap<TCPDirection, JLabel> labelMap = new EnumMap(TCPDirection.class);
    private final EnumMap<TCPDirection, Icon> safetyIconMap = new EnumMap(TCPDirection.class);
    private final EnumMap<TCPDirection, Icon> selectedIconMap = new EnumMap(TCPDirection.class);
    private SafetyMode safetyMode = SafetyMode.UNDEFINED_SAFETY_MODE;
    private ControlMode currentControlMode;

    RotateToolPanel(TextResource textResource, MoveTabRobotModel robotModel, ControllerInterface controllerInterface) {
        super(textResource, robotModel, controllerInterface);
        this.init();
    }

    @Override
    void init() {
        super.init();
        this.setBorder((Border)new CardBorder(this.textResource.tcpOrientation()));
        EventNotificationService.register((Object)this, SafetyModeChangeService.SafetyModeListener.class, (Object)this);
    }

    @Override
    protected void createPanel() {
        JLabel rzMinusLabel = new JLabel();
        JLabel rzPlusLabel = new JLabel();
        JLabel ryMinusLabel = new JLabel();
        JLabel rxPlusLabel = new JLabel();
        JLabel rxMinusLabel = new JLabel();
        JLabel ryPlusLabel = new JLabel();
        this.setLabelNames(rzMinusLabel, rzPlusLabel, ryMinusLabel, rxPlusLabel, rxMinusLabel, ryPlusLabel);
        this.putInMaps(TCPDirection.RXMINUS, rxMinusLabel, LabelImageResource.rxMinusBlue(), LabelImageResource.rxMinusYellow(), LabelImageResource.rxMinusSelected());
        this.putInMaps(TCPDirection.RXPLUS, rxPlusLabel, LabelImageResource.rxPlusBlue(), LabelImageResource.rxPlusYellow(), LabelImageResource.rxPlusSelected());
        this.putInMaps(TCPDirection.RYMINUS, ryMinusLabel, LabelImageResource.ryMinusBlue(), LabelImageResource.ryMinusYellow(), LabelImageResource.ryMinusSelected());
        this.putInMaps(TCPDirection.RYPLUS, ryPlusLabel, LabelImageResource.ryPlusBlue(), LabelImageResource.ryPlusYellow(), LabelImageResource.ryPlusSelected());
        this.putInMaps(TCPDirection.RZMINUS, rzMinusLabel, LabelImageResource.rzMinusBlue(), LabelImageResource.rzMinusYellow(), LabelImageResource.rzMinusSelected());
        this.putInMaps(TCPDirection.RZPLUS, rzPlusLabel, LabelImageResource.rzPlusBlue(), LabelImageResource.rzPlusYellow(), LabelImageResource.rzPlusSelected());
        for (TCPDirection tcpDirection : USED_DIRECTIONS) {
            LabelUtils.bindIconButton((JLabel)this.labelMap.get((Object)tcpDirection), (Icon)this.safetyIconMap.get((Object)tcpDirection), (Icon)this.selectedIconMap.get((Object)tcpDirection), (WhilePressed)new RotateToolWhilePressed(this.robotModel, tcpDirection, this.controllerInterface));
        }
        this.addLayout(this.toolPanel, rzMinusLabel, rzPlusLabel, ryMinusLabel, rxPlusLabel, rxMinusLabel, ryPlusLabel);
    }

    private void putInMaps(TCPDirection tcpDirection, JLabel jLabel, Icon blueIcon, Icon yellowIcon, Icon selectedIcon) {
        this.labelMap.put(tcpDirection, jLabel);
        this.safetyIconMap.put(tcpDirection, new SafetyModeIcon(blueIcon, yellowIcon, SafetyMode.NORMAL));
        this.selectedIconMap.put(tcpDirection, selectedIcon);
    }

    @Override
    void addLayout(JPanel panel, JLabel rzMinus, JLabel rzPlus, JLabel ryMinus, JLabel rxPlus, JLabel rxMinus, JLabel ryPlus) {
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new EmptyBorder(10, 0, 10, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(-25, 0, 0, 0);
        gbc.anchor = 10;
        panel.add((Component)ryMinus, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)rzPlus, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        panel.add((Component)rzMinus, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(-24, 0, 0, 20);
        panel.add((Component)rxPlus, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(-24, 20, 0, 0);
        panel.add((Component)rxMinus, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(-24, 0, 0, 0);
        gbc.anchor = 10;
        panel.add((Component)ryPlus, gbc);
    }

    JLabel getDirectionLabel(TCPDirection direction) {
        return this.labelMap.get((Object)direction);
    }

    void updateIcons(SafetyMode newValue) {
        this.safetyMode = newValue;
        if (ControlMode.TEACH.equals((Object)this.currentControlMode)) {
            return;
        }
        this.update();
        for (TCPDirection tcpDirection : USED_DIRECTIONS) {
            ((SafetyModeIcon)this.safetyIconMap.get((Object)tcpDirection)).setSafetyMode(newValue);
        }
        this.repaint();
    }

    @Override
    protected boolean showAxes() {
        return super.showAxes() && !SafetyModes.isSafetyStop((SafetyMode)this.safetyMode);
    }

    public void safetyModeChanged(SafetyMode oldValue, SafetyMode newValue) {
        SwingUtilities.invokeLater(() -> this.updateIcons(newValue));
    }

    public void accept(RobotMode robotMode) {
        this.currentControlMode = robotMode.getControlMode();
    }
}

