/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.monitor.model.Pose6d;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.PoseTextFieldMouseListener;
import com.ur.move.poseeditor.PoseRequester;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.internaltcp.rotation.RotationVectorRadRepresentation;
import com.ur.polyscope.valueobjects.Angle;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.number.NumberField;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.vecmath.Vector3d;

public class ToolPositionPanel {
    public static final String SHOW_EDIT_POSE_ACTION = "showEditPoseAction." + ToolPositionPanel.class.getSimpleName();
    private final List<NumberField> xyzFields = new ArrayList<NumberField>();
    private final List<NumberField> rotationFields = new ArrayList<NumberField>();
    private final JPanel panel;

    ToolPositionPanel(ViewContext context, MoveTabRobotModel robotModel, PoseRequester poseRequester) {
        WidgetFactory factory = context.createWidgetFactory();
        for (int i = 0; i < 3; ++i) {
            NumberField coordinate = factory.createNumberField(null, UnitsValueConverterFactory.getLengthConverter());
            coordinate.setText("-888.88");
            coordinate.setEditable(false);
            this.xyzFields.add(coordinate);
            NumberField rotation = factory.createNumberField(null, UnitsValueConverterFactory.getAngleConverter((boolean)true));
            this.rotationFields.add(rotation);
            rotation.setText("-8.8888");
            rotation.setEditable(false);
        }
        this.xyzFields.get(0).setName(SHOW_EDIT_POSE_ACTION);
        JPanel positions = context.createFormBuilder().end().componentWithLabel("X", (JComponent)this.xyzFields.get(0), new FormBuilder.PanelConstraints[0]).componentWithLabel("RX", (JComponent)this.rotationFields.get(0), new FormBuilder.PanelConstraints[0]).end(2).componentWithLabel("Y", (JComponent)this.xyzFields.get(1), new FormBuilder.PanelConstraints[0]).componentWithLabel("RY", (JComponent)this.rotationFields.get(1), new FormBuilder.PanelConstraints[0]).end(2).componentWithLabel("Z", (JComponent)this.xyzFields.get(2), new FormBuilder.PanelConstraints[0]).componentWithLabel("RZ", (JComponent)this.rotationFields.get(2), new FormBuilder.PanelConstraints[0]).end().groupColumns(new int[]{2, 4}).fixedSizeColumnAndWidthPairs(new int[]{1, 5, 2, 52}).getPanel();
        this.bindPoseEditorAction(poseRequester, robotModel, this.xyzFields, this.rotationFields);
        positions.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        this.panel = new JPanel();
        this.panel.add(positions);
        this.panel.setBorder((Border)new CardBorder(((TextResource)context.getTextResource(TextResource.class)).toolPosition()));
    }

    public List<JTextField> getToolPositionFields() {
        ArrayList<JTextField> result = new ArrayList<JTextField>();
        result.addAll(this.xyzFields);
        result.addAll(this.rotationFields);
        return result;
    }

    public void updateFeaturePose(Pose6d featurePose) {
        this.xyzFields.get(0).setValue((Object)Length.from((double)featurePose.getX(), (Length.Unit)Length.Unit.M));
        this.xyzFields.get(1).setValue((Object)Length.from((double)featurePose.getY(), (Length.Unit)Length.Unit.M));
        this.xyzFields.get(2).setValue((Object)Length.from((double)featurePose.getZ(), (Length.Unit)Length.Unit.M));
        Vector3d rotation = RotationVectorRadRepresentation.getPresentableRotation((Vector3d)featurePose.getRot());
        this.rotationFields.get(0).setValue((Object)Angle.from((double)rotation.getX(), (Angle.Unit)Angle.Unit.RADIANS));
        this.rotationFields.get(1).setValue((Object)Angle.from((double)rotation.getY(), (Angle.Unit)Angle.Unit.RADIANS));
        this.rotationFields.get(2).setValue((Object)Angle.from((double)rotation.getZ(), (Angle.Unit)Angle.Unit.RADIANS));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void bindPoseEditorAction(PoseRequester poseRequester, MoveTabRobotModel robotModel, List<NumberField> ... fieldsList) {
        for (List<NumberField> eachList : fieldsList) {
            for (NumberField each : eachList) {
                each.addMouseListener((MouseListener)new PoseTextFieldMouseListener(poseRequester, (JTextField)each, robotModel));
            }
        }
    }
}

