/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move;

import com.ur.lang.react.Consumer;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.monitor.model.RobotMode;
import com.ur.move.AbstractTranslateToolPanel;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.SafetyModeIcon;
import com.ur.move.TCPDirection;
import com.ur.move.TranslateToolWhilePressed;
import com.ur.move.resources.LabelImageResource;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.viewfacade.monitor.SafetyModeChangeService;
import com.ur.swing.LabelUtils;
import com.ur.swing.WhilePressed;
import com.ur.swing.g5.CardBorder;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.ControlMode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class TranslateToolPanel
extends AbstractTranslateToolPanel
implements SafetyModeChangeService.SafetyModeListener,
Consumer<RobotMode> {
    private static final List<TCPDirection> USED_DIRECTIONS = Arrays.asList(TCPDirection.LEFT, TCPDirection.RIGHT, TCPDirection.UP, TCPDirection.DOWN, TCPDirection.BACKWARD, TCPDirection.FORWARD);
    private EnumMap<TCPDirection, JLabel> labelMap = new EnumMap(TCPDirection.class);
    private EnumMap<TCPDirection, Icon> safetyIconMap = new EnumMap(TCPDirection.class);
    private EnumMap<TCPDirection, Icon> selectedIconMap = new EnumMap(TCPDirection.class);
    private SafetyMode safetyMode = SafetyMode.UNDEFINED_SAFETY_MODE;
    private ControlMode currentControlMode = null;

    TranslateToolPanel(TextResource textResource, MoveTabRobotModel robotModel, ControllerInterface controllerInterface) {
        super(textResource, robotModel, controllerInterface);
        this.init();
        EventNotificationService.register((Object)this, SafetyModeChangeService.SafetyModeListener.class, (Object)this);
    }

    @Override
    void init() {
        super.init();
        this.setBorder((Border)new CardBorder(this.textResource.tcpPosition()));
    }

    @Override
    protected void createPanel() {
        JLabel zMinusLabel = new JLabel();
        JLabel zPlusLabel = new JLabel();
        JLabel xMinusLabel = new JLabel();
        JLabel xPlusLabel = new JLabel();
        JLabel yMinusLabel = new JLabel();
        JLabel yPlusLabel = new JLabel();
        JLabel blankLabel = new JLabel();
        this.setLabelNames(zMinusLabel, zPlusLabel, xMinusLabel, xPlusLabel, yMinusLabel, yPlusLabel);
        this.putInMaps(TCPDirection.BACKWARD, xMinusLabel, LabelImageResource.xMinusBlue(), LabelImageResource.xMinusYellow(), LabelImageResource.xMinusSelected());
        this.putInMaps(TCPDirection.FORWARD, xPlusLabel, LabelImageResource.xPlusBlue(), LabelImageResource.xPlusYellow(), LabelImageResource.xPlusSelected());
        this.putInMaps(TCPDirection.LEFT, yMinusLabel, LabelImageResource.yMinusBlue(), LabelImageResource.yMinusYellow(), LabelImageResource.yMinusSelected());
        this.putInMaps(TCPDirection.RIGHT, yPlusLabel, LabelImageResource.yPlusBlue(), LabelImageResource.yPlusYellow(), LabelImageResource.yPlusSelected());
        this.putInMaps(TCPDirection.DOWN, zMinusLabel, LabelImageResource.zMinusBlue(), LabelImageResource.zMinusYellow(), LabelImageResource.zMinusSelected());
        this.putInMaps(TCPDirection.UP, zPlusLabel, LabelImageResource.zPlusBlue(), LabelImageResource.zPlusYellow(), LabelImageResource.zPlusSelected());
        for (TCPDirection tcpDirection : USED_DIRECTIONS) {
            LabelUtils.bindIconButton((JLabel)this.labelMap.get((Object)tcpDirection), (Icon)this.safetyIconMap.get((Object)tcpDirection), (Icon)this.selectedIconMap.get((Object)tcpDirection), (WhilePressed)new TranslateToolWhilePressed(this.robotModel, tcpDirection, this.controllerInterface));
        }
        this.addLayout(this.toolPanel, zMinusLabel, zPlusLabel, xMinusLabel, xPlusLabel, yMinusLabel, yPlusLabel, blankLabel);
    }

    private void putInMaps(TCPDirection tcpDirection, JLabel jLabel, Icon blueIcon, Icon yellowIcon, Icon selectedIcon) {
        this.labelMap.put(tcpDirection, jLabel);
        this.safetyIconMap.put(tcpDirection, new SafetyModeIcon(blueIcon, yellowIcon, SafetyMode.NORMAL));
        this.selectedIconMap.put(tcpDirection, selectedIcon);
    }

    @Override
    void addLayout(JPanel translateToolPanel, JLabel zMinusLabel, JLabel zPlusLabel, JLabel xMinusLabel, JLabel xPlusLabel, JLabel yMinusLabel, JLabel yPlusLabel, JLabel blankLabel) {
        translateToolPanel.setName("moveTabTranslateToolLabel");
        translateToolPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        translateToolPanel.add((Component)zPlusLabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        translateToolPanel.add((Component)zMinusLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(0, 0, -7, 0);
        gbc.anchor = 10;
        translateToolPanel.add((Component)xMinusLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        translateToolPanel.add((Component)yMinusLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.ipadx = 48;
        translateToolPanel.add((Component)blankLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        translateToolPanel.add((Component)yPlusLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(-11, 0, 0, 0);
        gbc.anchor = 10;
        translateToolPanel.add((Component)xPlusLabel, gbc);
        translateToolPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
    }

    JLabel getDirectionLabel(TCPDirection direction) {
        return this.labelMap.get((Object)direction);
    }

    void updateIcons(SafetyMode newValue) {
        this.safetyMode = newValue;
        if (ControlMode.TEACH.equals((Object)this.currentControlMode)) {
            return;
        }
        this.update();
        for (TCPDirection tcpDirection : USED_DIRECTIONS) {
            ((SafetyModeIcon)this.safetyIconMap.get((Object)tcpDirection)).setSafetyMode(newValue);
        }
        this.repaint();
    }

    @Override
    protected boolean showAxes() {
        return super.showAxes() && !SafetyModes.isSafetyStop((SafetyMode)this.safetyMode);
    }

    public void safetyModeChanged(SafetyMode oldValue, SafetyMode newValue) {
        SwingUtilities.invokeLater(() -> this.updateIcons(newValue));
    }

    public void accept(RobotMode robotMode) {
        this.currentControlMode = robotMode.getControlMode();
    }
}

