/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove;

import com.ur.lang.StringUtils;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.RobotMode;
import com.ur.monitor.requirements.RunningRobotRequirement;
import com.ur.move.StartingNodeTitle;
import com.ur.move.automove.AutoMoveContinuePanel;
import com.ur.move.resources.MoveImageResource;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.safety.threepositiondevice.ThreePositionDevice;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.viewfacade.program.ProgramUiControl;
import com.ur.swing.URFontFactory;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JPanel;

@Singleton
public class AutoMoveAndPlay
extends AutoMoveContinuePanel {
    private static final int TRUNCATE_LENGTH = 20;
    private final ProgramUiControl dashBoard;
    private final StartingNodeTitle startingNodeTitle;
    private final RunningRobotRequirement runningRobotRequirement;
    private PlayButtonAction playButtonAction;

    @Inject
    public AutoMoveAndPlay(WidgetFactory widgetFactory, TextResource textResource, URFontFactory fontFactory, @Source(value=ThreePositionDevice.class) Recipe<ThreePositionDevice> threePositionDeviceRecipe, @Source(value=RobotMode.class) Recipe<RobotMode> robotModeRecipe, ProgramUiControl dashBoard, StartingNodeTitle startingNodeTitle, RunningRobotRequirement runningRobotRequirement, UserAccessControl userAccessControl) {
        super(widgetFactory, textResource, fontFactory, threePositionDeviceRecipe, robotModeRecipe, userAccessControl);
        this.dashBoard = dashBoard;
        this.startingNodeTitle = startingNodeTitle;
        this.runningRobotRequirement = runningRobotRequirement;
    }

    @Override
    protected AbstractAction getActionForActionButton() {
        return this.playButtonAction;
    }

    @Override
    public JPanel createPanel() {
        this.playButtonAction = new PlayButtonAction();
        this.appendButton(this.playButtonAction);
        this.appendWarning(this.textResource.Play());
        this.appendButton(new AutoMoveContinuePanel.ExitButtonAction(this));
        this.setBackground(G5LookAndFeel.DEFAULT_BACKGROUND);
        return this;
    }

    @Override
    public String getTitle() {
        return this.textResource.tabAutomoveTitlePlay();
    }

    @Override
    public Icon getIcon() {
        return MoveImageResource.playIcon();
    }

    @Override
    public String getDescription() {
        return this.textResource.OnTargetStartMovingDescription(this.textResource.Play());
    }

    @Override
    public void tpButtonPressed() {
        this.playButtonAction.actionPerformed(new ActionEvent(this, 1001, ""));
    }

    @Override
    public void updateActionName() {
        String text = "<html>" + this.textResource.tabAutomoveTitlePlayFrom() + ":<br>" + this.truncate(this.startingNodeTitle.getStartingNodeTitle()) + "</html>";
        this.playButtonAction.updateName(text);
    }

    private String truncate(String input) {
        return StringUtils.safeLimitedSizeStringWithDots((int)20, (String)input);
    }

    class PlayButtonAction
    extends AutoMoveContinuePanel.ContinueButtonAction {
        PlayButtonAction() {
            super(AutoMoveAndPlay.this);
            this.putValue("Name", AutoMoveAndPlay.this.textResource.Play());
            this.putValue("SmallIcon", new Icon(){
                private final Icon icon = MoveImageResource.playIcon();

                @Override
                public void paintIcon(Component component, Graphics graphics, int x, int y) {
                    this.icon.paintIcon(component, graphics, x, y);
                }

                @Override
                public int getIconWidth() {
                    return this.icon.getIconWidth() + 10;
                }

                @Override
                public int getIconHeight() {
                    return this.icon.getIconHeight();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoMoveAndPlay.this.runningRobotRequirement.checkAndNotify()) {
                super.actionPerformed(actionEvent);
                AutoMoveAndPlay.this.dashBoard.playProgram();
            }
        }

        void updateName(String text) {
            this.putValue("Name", text);
        }
    }
}

