/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.RobotMode;
import com.ur.move.automove.AutoMoveContinuePanel;
import com.ur.move.resources.MoveImageResource;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.safety.threepositiondevice.ThreePositionDevice;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.viewfacade.program.ProgramUiControl;
import com.ur.swing.URFontFactory;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JPanel;

@Singleton
public class AutoMoveAndStep
extends AutoMoveContinuePanel {
    private final ProgramUiControl dashBoard;
    private StepButtonAction stepButtonAction;

    @Inject
    public AutoMoveAndStep(WidgetFactory widgetFactory, TextResource textResource, URFontFactory fontFactory, @Source(value=ThreePositionDevice.class) Recipe<ThreePositionDevice> threePositionDeviceRecipe, @Source(value=RobotMode.class) Recipe<RobotMode> robotModeRecipe, ProgramUiControl dashBoard, UserAccessControl userAccessControl) {
        super(widgetFactory, textResource, fontFactory, threePositionDeviceRecipe, robotModeRecipe, userAccessControl);
        this.dashBoard = dashBoard;
    }

    @Override
    protected AbstractAction getActionForActionButton() {
        return this.stepButtonAction;
    }

    @Override
    public JPanel createPanel() {
        this.stepButtonAction = new StepButtonAction();
        this.appendButton(this.stepButtonAction);
        this.appendWarning(this.textResource.Step());
        this.appendButton(new AutoMoveContinuePanel.ExitButtonAction(this));
        this.setBackground(G5LookAndFeel.DEFAULT_BACKGROUND);
        return this;
    }

    @Override
    public String getDescription() {
        return this.textResource.OnTargetStartMovingDescription(this.textResource.Step());
    }

    @Override
    public void tpButtonPressed() {
        this.stepButtonAction.actionPerformed(new ActionEvent(this, 1001, ""));
    }

    private class StepButtonAction
    extends AutoMoveContinuePanel.ContinueButtonAction {
        private StepButtonAction() {
            super(AutoMoveAndStep.this);
            this.putValue("Name", AutoMoveAndStep.this.textResource.Step());
            this.putValue("SmallIcon", new Icon(){
                private final Icon icon = MoveImageResource.stepIcon();

                @Override
                public void paintIcon(Component component, Graphics graphics, int x, int y) {
                    this.icon.paintIcon(component, graphics, x, y);
                }

                @Override
                public int getIconWidth() {
                    return this.icon.getIconWidth() + 10;
                }

                @Override
                public int getIconHeight() {
                    return this.icon.getIconHeight();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            AutoMoveAndStep.this.dashBoard.stepProgram();
        }
    }
}

