/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.RobotMode;
import com.ur.move.automove.AutoMoveActionResult;
import com.ur.move.automove.AutoMoveDone;
import com.ur.move.automove.AutoMoveDoneUiExtension;
import com.ur.move.automove.AutoMoveTab;
import com.ur.move.automove.NeedToAutoMoveRobot;
import com.ur.move.automove.requestmove.ThreePositionDeviceManager;
import com.ur.move.resources.MoveImageResource;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.safety.threepositiondevice.ThreePositionDevice;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.swing.URFontFactory;
import com.ur.swing.WidgetFactory;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.constants.runtime.ControlMode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

@Singleton
public class AutoMoveContinuePanel
extends JPanel
implements AutoMoveDoneUiExtension,
NeedToAutoMoveRobot,
ThreePositionDeviceManager {
    protected final TextResource textResource;
    private final URFontFactory fontFactory;
    private final WidgetFactory widgetFactory;
    private AutoMoveDone autoMoveDone;
    private ContinueButtonAction continueButtonAction;
    private JButton actionButton;
    private final UserAccessControl userAccessControl;
    private final AtomicReference<ControlMode> controlMode = new AtomicReference<Object>(null);

    @Inject
    public AutoMoveContinuePanel(WidgetFactory widgetFactory, TextResource textResource, URFontFactory fontFactory, @Source(value=ThreePositionDevice.class) Recipe<ThreePositionDevice> threePositionDeviceRecipe, @Source(value=RobotMode.class) Recipe<RobotMode> robotModeRecipe, UserAccessControl userAccessControl) {
        this.widgetFactory = widgetFactory;
        this.textResource = textResource;
        this.fontFactory = fontFactory;
        this.userAccessControl = userAccessControl;
        this.setLayout(new GridBagLayout());
        this.manageButtonActivationWith3PE(threePositionDeviceRecipe);
        robotModeRecipe.subscribe(robotMode -> this.controlMode.set(robotMode.getControlMode()));
    }

    @Override
    public void handleActionButton(ThreePositionDevice threePositionDevice) {
        if (this.controlMode.get() == ControlMode.TEACH) {
            this.enableActionButton(false);
            return;
        }
        OperationalMode operationalMode = this.userAccessControl.getCurrentOperationalMode();
        this.enableActionButton(!operationalMode.equals((Object)OperationalMode.MANUAL) || threePositionDevice.isTriggered());
    }

    private void enableActionButton(boolean enable) {
        if (!this.isActionButtonDefined()) {
            return;
        }
        if (this.isActionButtonEnabled() != enable) {
            this.getActionForActionButton().setEnabled(enable);
            this.actionButton.setEnabled(enable);
        }
    }

    private boolean isActionButtonDefined() {
        return this.getActionForActionButton() != null && this.actionButton != null;
    }

    private boolean isActionButtonEnabled() {
        return this.getActionForActionButton().isEnabled() && this.actionButton.isEnabled();
    }

    protected AbstractAction getActionForActionButton() {
        return this.continueButtonAction;
    }

    @Override
    public void bind(AutoMoveDone autoMoveDone) {
        this.autoMoveDone = autoMoveDone;
    }

    @Override
    public JPanel createPanel() {
        this.continueButtonAction = new ContinueButtonAction();
        this.appendButton(this.continueButtonAction);
        return this;
    }

    @Override
    public void updateActionName() {
    }

    private static Dimension createButtonDimension() {
        return new Dimension(320, 70);
    }

    @Override
    public String getTitle() {
        return this.textResource.tabAutomoveTitle();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.textResource.TargetPosition();
    }

    @Override
    public void tpButtonPressed() {
        this.continueButtonAction.actionPerformed(new ActionEvent(this, 1001, ""));
    }

    void appendButton(ContinueButtonAction continueButtonAction) {
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 1;
        gb.gridy = 0;
        gb.anchor = 11;
        this.actionButton = this.widgetFactory.createButton((Action)continueButtonAction);
        this.actionButton.setMaximumSize(AutoMoveContinuePanel.createButtonDimension());
        this.actionButton.setPreferredSize(AutoMoveContinuePanel.createButtonDimension());
        this.actionButton.setMinimumSize(AutoMoveContinuePanel.createButtonDimension());
        this.add((Component)this.actionButton, gb);
    }

    void appendButton(ExitButtonAction exitButtonAction) {
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 1;
        gb.gridy = 2;
        gb.insets = new Insets(20, 0, 0, 0);
        gb.anchor = 11;
        JButton exitButton = this.widgetFactory.createButton((Action)exitButtonAction);
        exitButton.setMaximumSize(AutoMoveContinuePanel.createButtonDimension());
        exitButton.setPreferredSize(AutoMoveContinuePanel.createButtonDimension());
        exitButton.setMinimumSize(AutoMoveContinuePanel.createButtonDimension());
        this.add((Component)exitButton, gb);
    }

    void appendWarning(String button) {
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 1;
        gb.gridy = 1;
        gb.insets = new Insets(5, 0, 0, 0);
        gb.anchor = 10;
        JLabel warningLabel = new JLabel(this.textResource.StandClearWarning(button));
        warningLabel.setIcon(MoveImageResource.formWarning());
        warningLabel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Size.SMALL));
        warningLabel.setHorizontalAlignment(0);
        warningLabel.setMaximumSize(new Dimension(400, 20));
        warningLabel.setPreferredSize(new Dimension(400, 20));
        warningLabel.setMinimumSize(new Dimension(400, 20));
        this.add((Component)warningLabel, gb);
    }

    @Override
    public AutoMoveActionResult moveTo(JointPositionVector jointPositionVector, String nodeTitle) {
        return new AutoMoveActionResult(jointPositionVector, this, nodeTitle);
    }

    class ExitButtonAction
    extends AbstractAction {
        ExitButtonAction() {
            this.putValue("Name", AutoMoveContinuePanel.this.textResource.Cancel());
            this.putValue("SmallIcon", MoveImageResource.gtkCancel());
            this.putValue("InternalName", AutoMoveTab.EXIT_BUTTON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoMoveContinuePanel.this.autoMoveDone.exitPressed();
        }
    }

    class ContinueButtonAction
    extends AbstractAction {
        ContinueButtonAction() {
            this.putValue("Name", AutoMoveContinuePanel.this.textResource.Continue());
            this.putValue("InternalName", AutoMoveTab.CONTINUE_BUTTON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AutoMoveContinuePanel.this.autoMoveDone.continuePressed();
        }
    }
}

