/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove;

import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.RobotMode;
import com.ur.monitor.requirements.RunningRobotRequirement;
import com.ur.move.ControllerSocketSender;
import com.ur.move.MoveTab;
import com.ur.move.RequestManualMove;
import com.ur.move.automove.AutoMoveActionResult;
import com.ur.move.automove.AutoMoveContinuePanel;
import com.ur.move.automove.AutoMoveDone;
import com.ur.move.automove.AutoMoveDoneUiExtension;
import com.ur.move.automove.AutoMoveTab;
import com.ur.move.automove.AutoMoveTabSubPanel;
import com.ur.move.automove.AutoMoveTitleComposite;
import com.ur.move.automove.MoveRobotControllerRPC;
import com.ur.move.poseeditor.PoseRequest;
import com.ur.move.resources.MoveImageResource;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.initializerobot.RobotInitializationService;
import com.ur.polyscope.move.AutoMoveCallback;
import com.ur.polyscope.move.MoveRequest;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.safety.threepositiondevice.ThreePositionConfiguration;
import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.viewfacade.program.ProgramUiControl;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.swing.CardPanel;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogOnScreen;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.constants.runtime.ControlMode;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class AutoMoveTabSubPanelImpl
extends CardPanel
implements AutoMoveDone,
AutoMoveTabSubPanel {
    private static final String MAIN_PANEL = "main_panel";
    private final JointPositionVector realRobotJointPosition = new JointPositionVector();
    private final RunningRobotRequirement runningRobotRequirement;
    private final MoveRobotControllerRPC moveRobotControllerRPC;
    private final RobotCanvas3DFactory robotCanvas3DFactory;
    private final Privileges privileges;
    private final PayloadService payloadService;
    private final TextResource textResource;
    private final MessageDialogCreator dialogCreator;
    private final HelpIdAssigner helpIdAssigner;
    private final DialogOnScreen moveDialog;
    private final ProgramUiControl programUiControl;
    private final ExitButtonAction exitButtonAction;
    private final AutoMoveContinuePanel continuePanel;
    private final Set<AutoMoveDoneUiExtension> autoMoveDoneUiExtensions;
    private final Recipe<ArmModeComposite> armModeCompositeRecipe;
    private final InverseKinematicProviderExt inverseKinematicProviderExt;
    private final UserAccessControl userAccessControl;
    private final ThreePositionConfiguration threePositionConfiguration;
    protected JButton autoMoveButton;
    protected JLabel autoMoveLabel;
    private final RobotInitializationService initializationRobotDialog;
    private final WidgetFactory widgetFactory;
    private RobotCanvas3D robotCanvas3D;
    private final JointPositionVector oldTargetJointPosition = new JointPositionVector();
    private JointPositionVector targetJointPosition = new JointPositionVector();
    private Pose6d targetPose;
    private Speed robotMoveSpeed;
    private boolean requestSimAutomaticMoveRun = true;
    private boolean automaticMoveRunning;
    private boolean autoMoveButtonPressed;
    private boolean isDrivenByPose;
    private boolean isAPoseRequestWithJointPosition;
    private boolean onEnterWasRealRobot;
    private boolean isAutoMoving;
    private boolean isNear;
    private JButton manualButton;
    private JPanel cardPanel;
    private JPanel robotPanel;
    private JPanel centerPanel;
    private JLabel titleLabel;
    private JLabel illustrationLabel;
    private JLabel payloadWarningLabel;
    private AutoMoveDoneUiExtension activeAutoMoveDoneUiExtension;
    private Subscription armModeInfoCompositeSubscription;
    private AutoMoveCallback moveRequestCallback;

    @Inject
    protected AutoMoveTabSubPanelImpl(MoveRobotControllerRPC moveRobotControllerRPC, RobotCanvas3DFactory robotCanvas3DFactory, Privileges privileges, RunningRobotRequirement runningRobotRequirement, RobotInitializationService initializationRobotDialog, @Source(value=Arm.class) Recipe<Arm> armRecipe, @Source(value=RobotMode.class) Recipe<RobotMode> robotModeRecipe, DialogOnScreen moveDialog, ProgramUiControl programUiControl, AutoMoveContinuePanel continuePanel, Set<AutoMoveDoneUiExtension> autoMoveDoneUiExtensions, PayloadService payloadService, ViewContext viewContext, InverseKinematicProviderExt inverseKinematicProviderExt, UserAccessControl userAccessControl, ThreePositionConfiguration threePositionConfiguration) {
        this.moveRobotControllerRPC = moveRobotControllerRPC;
        this.robotCanvas3DFactory = robotCanvas3DFactory;
        this.privileges = privileges;
        this.runningRobotRequirement = runningRobotRequirement;
        this.initializationRobotDialog = initializationRobotDialog;
        this.dialogCreator = viewContext.getDialogCreator();
        this.moveDialog = moveDialog;
        this.programUiControl = programUiControl;
        this.continuePanel = continuePanel;
        this.autoMoveDoneUiExtensions = autoMoveDoneUiExtensions;
        this.payloadService = payloadService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.widgetFactory = viewContext.createWidgetFactory();
        this.inverseKinematicProviderExt = inverseKinematicProviderExt;
        this.userAccessControl = userAccessControl;
        this.threePositionConfiguration = threePositionConfiguration;
        this.exitButtonAction = new ExitButtonAction();
        this.initComponents();
        this.initHelpIds();
        this.armModeCompositeRecipe = Recipe.combineLatest(armRecipe, robotModeRecipe, ArmModeComposite::new);
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.autoMoveButton, "gui:automovetab_auto_button");
        this.helpIdAssigner.assignHelpId((JComponent)this.manualButton, "gui:automovetab_manual_button");
        this.helpIdAssigner.assignHelpId((JComponent)this.robotPanel, "gui:automovetab_animation");
        this.helpIdAssigner.assignHelpId((JComponent)this.titleLabel, "gui:automovetab_explained");
    }

    private void updateRobotState(ArmModeComposite composite) {
        Arm arm = composite.arm;
        RobotMode robotMode = composite.robotMode;
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        if (this.shouldAbortAutomove(robotMode.isReal())) {
            this.autoMoveButtonPressed = false;
            this.stopAutomaticMove();
        }
        this.updateNear(arm);
        boolean isRobotInRunningState = this.isRobotInRunningState(robotMode);
        if (this.isRobotAtRequestedPosition(arm, robotMode)) {
            this.autoMoveButton.setEnabled(false);
            this.manualButton.setEnabled(false);
            this.activeAutoMoveDoneUiExtension.updateActionName();
            cardLayout.show(this.cardPanel, this.activeAutoMoveDoneUiExtension.getClass().getName());
            this.titleLabel.setIcon(this.activeAutoMoveDoneUiExtension.getIcon());
            this.titleLabel.setText(HTML.html((String)HTML.h1((String)this.activeAutoMoveDoneUiExtension.getTitle())));
            this.titleLabel.setHorizontalAlignment(0);
            this.autoMoveLabel.setText(HTML.html((String)this.activeAutoMoveDoneUiExtension.getDescription()));
            this.autoMoveLabel.setHorizontalAlignment(0);
        } else if (this.isFreedriveEnabled(robotMode)) {
            this.autoMoveButtonPressed = false;
            this.autoMoveButton.setEnabled(false);
            this.manualButton.setEnabled(false);
        } else if (!this.autoMoveButtonPressed && !robotMode.isProgramRunning()) {
            if (!robotMode.isSecurityStopped() && isRobotInRunningState) {
                this.sendSimulatedMoveProgram(arm);
            }
            this.autoMoveButton.setEnabled(isRobotInRunningState);
            this.manualButton.setEnabled(this.shouldEnableManualButton(isRobotInRunningState));
            this.updateTextAndIllustration();
            cardLayout.show(this.cardPanel, MAIN_PANEL);
        } else {
            if (this.isNotDriving()) {
                this.autoMoveButton.setEnabled(isRobotInRunningState);
                this.manualButton.setEnabled(this.shouldEnableManualButton(isRobotInRunningState));
            }
            this.updateTextAndIllustration();
            cardLayout.show(this.cardPanel, MAIN_PANEL);
        }
        this.robotCanvas3D.addQueue((Runnable)new UpdateTCPAndJointAngles(arm));
    }

    private boolean shouldEnableManualButton(boolean isRobotInRunningState) {
        return this.isManualMoveAllowed() && isRobotInRunningState;
    }

    private boolean isFreedriveEnabled(RobotMode robotMode) {
        return robotMode.getControlMode().equals((Object)ControlMode.TEACH);
    }

    private boolean shouldAbortAutomove(boolean isRealRobot) {
        boolean dialogShowed = this.automaticMoveRunning && this.moveDialog.isShowingADialog();
        boolean automoveButtonNotPressed = this.automaticMoveRunning && !this.autoMoveButtonPressed && isRealRobot;
        return dialogShowed || automoveButtonNotPressed;
    }

    private boolean isNotDriving() {
        return !this.autoMoveButtonPressed && !this.autoMoveButton.isEnabled();
    }

    private void updateNear(Arm arm) {
        this.isNear = false;
        if (this.isDrivenByPose) {
            Pose6d currentPose = new Pose6d(arm.getTool().getCartesianInfo().getTool());
            boolean bl = this.isNear = Pose6dTransformUtils.aggregatedDistanceTo((Pose6d)currentPose, (Pose6d)this.targetPose) < 0.005;
            if (this.targetJointPosition != null) {
                this.isNear &= arm.getActualJointsPosition().epsilonEquals(this.targetJointPosition, 0.005);
            }
        } else if (arm.getActualJointsPosition().epsilonEquals(this.targetJointPosition, 0.005)) {
            this.isNear = true;
        }
    }

    boolean isRobotAtRequestedPosition(Arm arm, RobotMode robotMode) {
        return arm.isRealRobot() && !robotMode.isProgramRunning() && this.isNear;
    }

    protected void updateTextAndIllustration() {
        OperationalMode operationalMode = this.userAccessControl.getCurrentOperationalMode();
        if (this.threePositionConfiguration.isConfigured() && operationalMode.equals((Object)OperationalMode.MANUAL)) {
            this.handle3PETextAndIllustration();
        } else {
            this.autoMoveLabel.setText(this.textResource.automoveExplanationG5());
            this.setTPIllustrationVisible(false);
        }
        this.titleLabel.setIcon(null);
        this.titleLabel.setText(this.textResource.tabAutomoveTitle());
    }

    private void handle3PETextAndIllustration() {
        if (this.threePositionConfiguration.isSafetyIOConfigured()) {
            this.updateExternal3PETextAndIllustration();
            return;
        }
        this.autoMoveLabel.setText(this.textResource.automoveExplanation3pe());
        this.setTPIllustrationVisible(true);
    }

    private void updateExternal3PETextAndIllustration() {
        this.autoMoveLabel.setText(this.textResource.automoveExplanationExternal3pe());
        this.setTPIllustrationVisible(false);
    }

    private boolean isBackFromManualMove(Object o) {
        return o == null && this.activeAutoMoveDoneUiExtension != null;
    }

    public Object exit() {
        this.unsubscribeFromRobotEvents();
        this.robotCanvas3D.exit();
        return super.exit();
    }

    public void enter(Object o) {
        this.programUiControl.stopProgram();
        this.exitButtonAction.setEnabled(true);
        this.onEnterWasRealRobot = RobotState.getLatestRobotState().real;
        this.isAPoseRequestWithJointPosition = false;
        this.isAutoMoving = false;
        if (!this.isBackFromManualMove(o)) {
            this.activeAutoMoveDoneUiExtension = this.continuePanel;
        }
        String subTitle = this.textResource.NewPosition();
        if (o instanceof AutoMoveTitleComposite) {
            AutoMoveTitleComposite otc = (AutoMoveTitleComposite)o;
            subTitle = otc.title;
            o = otc.o;
        }
        this.autoMoveButton.setText(this.createAutomoveButtonText(subTitle));
        if (o instanceof AutoMoveActionResult) {
            AutoMoveActionResult autoMoveActionResult = (AutoMoveActionResult)o;
            this.activeAutoMoveDoneUiExtension = autoMoveActionResult.getAutoMoveDoneUiExtension();
            this.oldTargetJointPosition.set(this.targetJointPosition);
            this.targetJointPosition.set(autoMoveActionResult.getDesiredPosition());
        } else if (o instanceof JointPositionVector) {
            this.oldTargetJointPosition.set(this.targetJointPosition);
            this.targetJointPosition.set((JointPositionVector)o);
        } else if (o instanceof Pose6d) {
            Point3d r;
            this.targetPose = (Pose6d)o;
            Point3d p = new Point3d((Tuple3d)this.targetPose.getPos());
            JointPositionVector jpv = this.inverseKinematicProviderExt.getInverseKinematicsMoveL(p, r = new Point3d((Tuple3d)this.targetPose.getRot()), RobotState.getLatestRobotState().jointPosition);
            if (jpv != null) {
                this.targetJointPosition = jpv;
            }
        } else if (o instanceof PoseRequest) {
            PoseRequest poseRequest = (PoseRequest)o;
            this.targetPose = poseRequest.getTargetToolPose();
            if (poseRequest.getTargetJointPosition() != null) {
                this.targetJointPosition = poseRequest.getTargetJointPosition();
                this.isAPoseRequestWithJointPosition = true;
            }
        } else if (o instanceof MoveRequest) {
            MoveRequest moveRequest = (MoveRequest)o;
            this.moveRequestCallback = moveRequest.getCallback();
            this.robotMoveSpeed = moveRequest.getSpeed().orElse(null);
            if (moveRequest.getTargetJointConfiguration() != null) {
                this.oldTargetJointPosition.set(this.targetJointPosition);
                this.targetJointPosition.set(new JointPositionVector(moveRequest.getTargetJointConfiguration().asArray()));
            }
            if (moveRequest.getTargetPose() != null) {
                this.targetPose = new Pose6d(moveRequest.getTargetPose().asArray());
                JointPositionVector jpv = this.inverseKinematicProviderExt.getInverseKinematics(this.targetPose, RobotState.getLatestRobotState().jointPosition);
                if (jpv != null) {
                    this.targetJointPosition = jpv;
                }
            }
        }
        this.isDrivenByPose = this.targetPose != null;
        this.requestSimAutomaticMoveRun = true;
        this.initializationRobotDialog.initializeRobot(true);
        this.autoMoveButton.setEnabled(true);
        this.manualButton.setEnabled(this.isManualMoveAllowed());
        this.robotCanvas3D.setVisible(true);
        this.robotCanvas3D.enter();
        this.robotCanvas3D.addQueue((Runnable)new DisplayShadowRobot(this.targetJointPosition, this.targetPose));
        this.armModeInfoCompositeSubscription = this.armModeCompositeRecipe.subscribe(armModeComposite -> {
            this.updateRobotState((ArmModeComposite)armModeComposite);
            this.updateAutoMove((ArmModeComposite)armModeComposite);
        });
        this.setPayloadWarningVisible(this.showPayloadWarning());
    }

    private void setPayloadWarningVisible(boolean visible) {
        this.payloadWarningLabel.setVisible(visible);
    }

    protected boolean showPayloadWarning() {
        return this.payloadService.getInstallationDefaultPayload().getMass().equals((Object)Weight.ZERO);
    }

    private String createAutomoveButtonText(String subTitle) {
        return "<html>" + this.textResource.tabAutomoveMoveRobotTo() + ":<br>" + subTitle + "</html>";
    }

    private void updateAutoMove(ArmModeComposite composite) {
        Arm arm = composite.arm;
        if (this.isAutoMoveButtonPressed()) {
            this.autoMoveButtonPressed(arm.isRealRobot());
        } else if (this.isAutoMoving && !this.isAutoMoveButtonPressed()) {
            this.autoMoveButtonReleased(arm.isRealRobot());
        }
    }

    private boolean isAutoMoveButtonPressed() {
        return this.autoMoveButton.getModel().isPressed();
    }

    private void setTPIllustrationVisible(boolean visible) {
        if (visible) {
            this.centerPanel.add((Component)this.illustrationLabel, 1);
        } else {
            this.centerPanel.remove(this.illustrationLabel);
        }
        this.centerPanel.validate();
        this.centerPanel.repaint();
    }

    private boolean isRobotInRunningState(RobotMode robotMode) {
        return com.ur.view.constants.dev.RobotMode.RUNNING.equals((Object)robotMode.getRobotMode());
    }

    private boolean isManualMoveAllowed() {
        return this.privileges.getPrivilege((RestrictedPoint)LockableRestrictedPoint.MOVE).getLevel() != LockablePrivilegeLevel.DENIED && Objects.isNull(this.robotMoveSpeed);
    }

    private void sendSimulatedMoveProgram(Arm robotArm) {
        if (robotArm.isRealRobot()) {
            this.moveRobotControllerRPC.sendSetSimulatedRobot();
            this.requestSimAutomaticMoveRun = true;
        } else {
            this.realRobotJointPosition.set(robotArm.getActualJointsPosition());
            if (!this.realRobotJointPosition.epsilonEquals(this.targetJointPosition, 0.005)) {
                this.manualButton.setEnabled(this.isManualMoveAllowed());
                if (this.requestSimAutomaticMoveRun) {
                    this.requestSimAutomaticMoveRun = false;
                    if (this.realRobotJointPosition.isUndefined() || this.targetJointPosition.isUndefined() && this.targetPose == null) {
                        this.showCannotMoveToUndefinedPositionError();
                    } else if (this.isDrivenByPose) {
                        this.moveRobotControllerRPC.sendSimulatedRobotProgram(this.realRobotJointPosition, this.targetPose, this.robotMoveSpeed);
                    } else {
                        this.moveRobotControllerRPC.sendSimulatedRobotProgram(this.targetJointPosition);
                    }
                }
            } else {
                this.moveRobotControllerRPC.sendSetRealRobot();
            }
        }
    }

    private void showCannotMoveToUndefinedPositionError() {
        this.dialogCreator.showMessageDialog(new DialogMessage(this.textResource.Message(), this.textResource.cannotAutomoveToUndefinedPosition()), MessageDialogType.MESSAGE, new OkDialogListener());
    }

    private void startAutoMove() {
        Log.debug((String)"start automatic move");
        if (this.runningRobotRequirement.checkAndNotify()) {
            this.manualButton.setEnabled(false);
            this.programUiControl.stopProgram();
            this.sendMoveProgram();
            this.automaticMoveRunning = true;
        }
    }

    private void sendMoveProgram() {
        if (this.isDrivenByPose && this.isAPoseRequestWithJointPosition) {
            this.moveRobotControllerRPC.sendMoveLProgram(this.targetPose, this.targetJointPosition, this.robotMoveSpeed);
        } else if (this.isDrivenByPose) {
            this.moveRobotControllerRPC.sendMoveLProgram(this.targetPose, null, this.robotMoveSpeed);
        } else {
            this.moveRobotControllerRPC.sendMoveJProgram(this.targetJointPosition);
        }
        this.requestSimAutomaticMoveRun = true;
    }

    private void stopAutomaticMove() {
        if (this.automaticMoveRunning) {
            Log.debug((String)"stop automatic move");
            if (this.isDrivenByPose) {
                ControllerSocketSender.sendStopLinear(1.5);
            } else {
                ControllerSocketSender.sendStopJoint(1.5);
            }
            this.automaticMoveRunning = false;
        }
    }

    private void recreateRobotSimulationState() {
        if (this.onEnterWasRealRobot) {
            this.moveRobotControllerRPC.sendSetRealRobot();
        } else {
            this.moveRobotControllerRPC.sendSetSimulatedRobot();
        }
    }

    private static Dimension createButtonDimension() {
        return new Dimension(320, 70);
    }

    private void initComponents() {
        this.illustrationLabel = new JLabel(MoveImageResource.autoMove3pe());
        this.illustrationLabel.setPreferredSize(new Dimension(246, 181));
        JPanel mainPanel = this.createMainPanel(this.createTopPanel(), this.createCenterPanel());
        this.setName(this.textResource.tabAutomove());
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.add(mainPanel, "Center");
    }

    private JPanel createMainPanel(JPanel topPanel, JPanel centerPanel) {
        JPanel outerCenterPanel = new JPanel(new BorderLayout());
        outerCenterPanel.add((Component)centerPanel, "Center");
        outerCenterPanel.add((Component)this.createPayloadWarningPanel(), "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)outerCenterPanel, "Center");
        mainPanel.add((Component)this.createSpacer(), "West");
        mainPanel.add((Component)this.createSpacer(), "East");
        return mainPanel;
    }

    private JPanel createMoveButtonsPanel() {
        this.autoMoveButton = new JButton();
        this.autoMoveButton.setName(AutoMoveTab.AUTO_MOVE_BUTTON);
        this.autoMoveButton.setText(this.textResource.Auto());
        this.autoMoveButton.setHorizontalAlignment(0);
        this.autoMoveButton.setMaximumSize(AutoMoveTabSubPanelImpl.createButtonDimension());
        this.autoMoveButton.setMinimumSize(AutoMoveTabSubPanelImpl.createButtonDimension());
        this.autoMoveButton.setPreferredSize(AutoMoveTabSubPanelImpl.createButtonDimension());
        this.autoMoveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (AutoMoveTabSubPanelImpl.this.autoMoveButtonPressed) {
                    AutoMoveTabSubPanelImpl.this.autoMoveButton.getModel().setPressed(false);
                }
            }
        });
        this.manualButton = new JButton();
        this.manualButton.setName(AutoMoveTab.MANUAL_MOVE_BUTTON);
        this.manualButton.setText(this.textResource.Manual());
        this.manualButton.setHorizontalAlignment(0);
        this.manualButton.setMaximumSize(AutoMoveTabSubPanelImpl.createButtonDimension());
        this.manualButton.setPreferredSize(AutoMoveTabSubPanelImpl.createButtonDimension());
        this.manualButton.setMinimumSize(AutoMoveTabSubPanelImpl.createButtonDimension());
        this.manualButton.addActionListener(evt -> this.manualButtonActionPerformed());
        JButton exitButton = this.widgetFactory.createButton((Action)this.exitButtonAction);
        exitButton.setMaximumSize(AutoMoveTabSubPanelImpl.createButtonDimension());
        exitButton.setPreferredSize(AutoMoveTabSubPanelImpl.createButtonDimension());
        exitButton.setMinimumSize(AutoMoveTabSubPanelImpl.createButtonDimension());
        JPanel moveButtonsPanel = new JPanel();
        moveButtonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        gb.insets = new Insets(0, 0, 0, 0);
        gb.anchor = 11;
        moveButtonsPanel.add((Component)this.autoMoveButton, gb);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 1;
        gb.insets = new Insets(20, 0, 0, 0);
        gb.anchor = 11;
        moveButtonsPanel.add((Component)this.manualButton, gb);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 2;
        gb.insets = new Insets(20, 0, 0, 0);
        gb.anchor = 11;
        moveButtonsPanel.add((Component)exitButton, gb);
        return moveButtonsPanel;
    }

    private JPanel createCenterPanel() {
        this.robotCanvas3D = this.robotCanvas3DFactory.buildMetalRobot();
        this.robotCanvas3D.setDebugName("G5 Automove 3D Canvas");
        this.robotCanvas3D.showStaticElements(Arrays.asList(VisualizerElementType.PAYLOAD_COG, VisualizerElementType.TCP));
        this.robotPanel = new JPanel();
        this.robotPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.robotPanel.setLayout(new BorderLayout());
        this.robotPanel.add(this.robotCanvas3D.getComponent());
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(this.createCardLayout());
        this.cardPanel.add((Component)this.createMoveButtonsPanel(), MAIN_PANEL);
        for (AutoMoveDoneUiExtension autoMoveDoneUiExtension : this.autoMoveDoneUiExtensions) {
            autoMoveDoneUiExtension.bind(this);
            JPanel panel = autoMoveDoneUiExtension.createPanel();
            this.cardPanel.add((Component)panel, panel.getClass().getName());
        }
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show(this.cardPanel, MAIN_PANEL);
        this.centerPanel = new JPanel(new GridLayout(1, 3));
        this.centerPanel.add(this.robotPanel);
        this.centerPanel.add(this.cardPanel);
        return this.centerPanel;
    }

    private JPanel createPayloadWarningPanel() {
        this.payloadWarningLabel = new JLabel(HTML.html((String)this.textResource.payloadUnsetWarning()), MoveImageResource.formWarning(), 0);
        this.payloadWarningLabel.setForeground(Color.RED);
        this.payloadWarningLabel.setVisible(false);
        JPanel payloadWarningPanel = new JPanel();
        payloadWarningPanel.setLayout(new BoxLayout(payloadWarningPanel, 1));
        payloadWarningPanel.setAlignmentX(0.0f);
        payloadWarningPanel.setBorder(new EmptyBorder(20, 10, 0, 10));
        payloadWarningPanel.add(this.payloadWarningLabel);
        return payloadWarningPanel;
    }

    private JPanel createTopPanel() {
        this.titleLabel = new JLabel();
        this.titleLabel.setBorder(new EmptyBorder(20, 20, 0, 20));
        this.titleLabel.setFont(new Font("Dialog", 1, 24));
        this.titleLabel.setText(this.textResource.tabAutomoveTitle());
        this.titleLabel.setHorizontalAlignment(0);
        this.autoMoveLabel = new JLabel();
        this.autoMoveLabel.setBorder(new EmptyBorder(20, 20, 0, 20));
        this.autoMoveLabel.setText(this.textResource.automoveExplanationG5());
        this.autoMoveLabel.setHorizontalAlignment(0);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.setAlignmentX(0.0f);
        topPanel.add(this.titleLabel);
        topPanel.add(this.autoMoveLabel);
        return topPanel;
    }

    private JPanel createSpacer() {
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(100, 200));
        return spacer;
    }

    CardLayout createCardLayout() {
        return new CardLayout();
    }

    private void autoMoveButtonPressed(boolean isRealRobot) {
        if (isRealRobot && !this.isAutoMoving && this.autoMoveButton.isEnabled()) {
            this.autoMoveButtonPressed = true;
            this.startAutoMove();
            this.isAutoMoving = true;
        } else if (!isRealRobot) {
            this.isAutoMoving = false;
            this.moveRobotControllerRPC.sendSetRealRobot();
            this.requestSimAutomaticMoveRun = false;
        }
    }

    private void autoMoveButtonReleased(boolean isRealRobot) {
        if (!this.isNear && isRealRobot) {
            this.autoMoveButtonPressed = false;
            this.stopAutomaticMove();
        }
        if (this.isAutoMoving && !isRealRobot) {
            this.autoMoveButton.setEnabled(true);
            this.isAutoMoving = false;
        }
    }

    private void manualButtonActionPerformed() {
        if (this.manualButton.isEnabled()) {
            this.exitCard(() -> this.stackCurrentCardAndSwitchTo(MoveTab.class, new RequestManualMove(this.targetJointPosition)));
        }
    }

    @Override
    public void continuePressed() {
        this.exitCard(() -> {
            this.onComplete();
            this.moveRequestCallback = null;
            this.navigateBack();
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, MAIN_PANEL);
        });
    }

    private void onComplete() {
        AutoMoveCallback autoMoveCallback = this.moveRequestCallback;
        SwingUtil.invokeLater(() -> {
            if (autoMoveCallback != null) {
                autoMoveCallback.onComplete();
            }
        });
    }

    @Override
    public void exitPressed() {
        this.doExitForCard();
    }

    private void doExitForCard() {
        this.exitCard(() -> {
            this.onCancel();
            this.moveRequestCallback = null;
            this.targetJointPosition.set(this.oldTargetJointPosition);
            this.navigateBack();
        });
    }

    private void onCancel() {
        AutoMoveCallback autoMoveCallback = this.moveRequestCallback;
        SwingUtil.invokeLater(() -> {
            if (autoMoveCallback != null) {
                autoMoveCallback.onCancel();
            }
        });
    }

    private void exitCard(Runnable runnable) {
        this.stopProgram();
        this.unsubscribeFromRobotEvents();
        this.resetUI();
        this.recreateRobotSimulationState();
        SimRealStateListener simRealStateListener = new SimRealStateListener(runnable);
        EventNotificationService.register((Object)simRealStateListener, RobotStateListener.class, (Object)simRealStateListener);
    }

    private void unsubscribeFromRobotEvents() {
        this.armModeInfoCompositeSubscription.dispose();
        this.armModeInfoCompositeSubscription = Subscription.NULL;
    }

    private void stopProgram() {
        if (this.automaticMoveRunning) {
            ControllerSocketSender.sendStopProgram();
            this.automaticMoveRunning = false;
        }
    }

    private void resetUI() {
        this.autoMoveButton.setEnabled(false);
        this.manualButton.setEnabled(false);
        this.exitButtonAction.setEnabled(false);
        this.robotCanvas3D.setVisible(false);
        this.targetPose = null;
        this.robotMoveSpeed = null;
    }

    private class SimRealStateListener
    implements RobotStateListener {
        Runnable navigation;

        public SimRealStateListener(Runnable navigation) {
            this.navigation = navigation;
        }

        public void updateRobotState(RobotState robotState) {
            if (robotState.real == AutoMoveTabSubPanelImpl.this.onEnterWasRealRobot) {
                EventNotificationService.unregister((Object)this, RobotStateListener.class);
                this.navigation.run();
            }
        }
    }

    private static class ArmModeComposite {
        private final Arm arm;
        private final RobotMode robotMode;

        ArmModeComposite(Arm arm, RobotMode robotMode) {
            this.arm = arm;
            this.robotMode = robotMode;
        }
    }

    private class ExitButtonAction
    extends AbstractAction {
        ExitButtonAction() {
            this.putValue("Name", AutoMoveTabSubPanelImpl.this.textResource.Cancel());
            this.putValue("SmallIcon", MoveImageResource.gtkCancel());
            this.putValue("InternalName", AutoMoveTab.EXIT_BUTTON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoMoveTabSubPanelImpl.this.doExitForCard();
        }
    }

    private final class DisplayShadowRobot
    implements Runnable {
        private final JointPositionVector targetPositionFinal;
        private final Pose6d targetPoseFinal;

        private DisplayShadowRobot(JointPositionVector targetPositionFinal, Pose6d targetPoseFinal) {
            this.targetPositionFinal = targetPositionFinal;
            this.targetPoseFinal = targetPoseFinal;
        }

        @Override
        public void run() {
            if (this.targetPositionFinal != null) {
                AutoMoveTabSubPanelImpl.this.robotCanvas3D.setShadowRobotJointAngleVector(this.targetPositionFinal);
            } else if (this.targetPoseFinal != null) {
                AutoMoveTabSubPanelImpl.this.robotCanvas3D.setShadowRobotJointAngleVector(RobotState.getLatestRobotState().jointPosition);
            }
        }
    }

    private final class UpdateTCPAndJointAngles
    implements Runnable {
        private final Arm arm;

        private UpdateTCPAndJointAngles(Arm arm) {
            this.arm = arm;
        }

        @Override
        public void run() {
            AutoMoveTabSubPanelImpl.this.robotCanvas3D.setJointAngleVector(this.arm.getActualJointsPosition());
        }
    }
}

