/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove;

import com.ur.move.automove.AutoMovingStateState;
import com.ur.move.automove.PressAndHoldButtonState;
import com.ur.move.automove.RunningState;
import com.ur.move.automove.SimAutomaticMoveRequestState;
import com.ur.move.automove.State;
import javax.inject.Singleton;

@Singleton
public class AutoRunningState {
    private State<RunningState> runningState = new State<RunningState>(RunningState.NOT_RUNNING);
    private State<SimAutomaticMoveRequestState> simAutomaticMoveRequestState = new State<SimAutomaticMoveRequestState>(SimAutomaticMoveRequestState.REQUESTED);
    private State<PressAndHoldButtonState> pressAndHoldButtonState = new State<PressAndHoldButtonState>(PressAndHoldButtonState.NOT_PRESSED);
    private State<AutoMovingStateState> autoMovingStateStateState = new State<AutoMovingStateState>(AutoMovingStateState.NOT_MOVING);

    void start() {
        this.runningState.set(RunningState.RUNNING);
    }

    void stop() {
        this.runningState.set(RunningState.NOT_RUNNING);
    }

    boolean isAutoMoveRunning() {
        return this.runningState.is(RunningState.RUNNING);
    }

    void startAutomoving() {
        this.autoMovingStateStateState.set(AutoMovingStateState.AUTOMOVING);
    }

    void stopAutomoving() {
        this.autoMovingStateStateState.set(AutoMovingStateState.NOT_MOVING);
    }

    boolean isAutoMoving() {
        return this.autoMovingStateStateState.is(AutoMovingStateState.AUTOMOVING);
    }

    void requestSimAutomaticMove() {
        this.simAutomaticMoveRequestState.set(SimAutomaticMoveRequestState.REQUESTED);
    }

    void cancelSimAutomaticMoveRequest() {
        this.simAutomaticMoveRequestState.set(SimAutomaticMoveRequestState.NOT_REQUESTED);
    }

    boolean isSimAutomaticMoveRequested() {
        return this.simAutomaticMoveRequestState.is(SimAutomaticMoveRequestState.REQUESTED);
    }

    void pressPressAndHold() {
        this.pressAndHoldButtonState.set(PressAndHoldButtonState.PRESSED);
    }

    void releasePressAndHold() {
        this.pressAndHoldButtonState.set(PressAndHoldButtonState.NOT_PRESSED);
    }

    boolean isPressAndHoldButtonPressed() {
        return this.pressAndHoldButtonState.is(PressAndHoldButtonState.PRESSED);
    }
}

