/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove;

import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.RobotMode;
import com.ur.monitor.requirements.RunningRobotRequirement;
import com.ur.move.ControllerSocketSender;
import com.ur.move.MoveTab;
import com.ur.move.RequestManualMove;
import com.ur.move.automove.AutoMoveActionResult;
import com.ur.move.automove.AutoMoveContinuePanel;
import com.ur.move.automove.AutoMoveDone;
import com.ur.move.automove.AutoMoveDoneUiExtension;
import com.ur.move.automove.AutoMoveTabSubPanel;
import com.ur.move.automove.AutoMoveTitleComposite;
import com.ur.move.automove.AutoRunningState;
import com.ur.move.automove.MoveButtonsPanelCallback;
import com.ur.move.automove.MoveButtonsPanelCreator;
import com.ur.move.automove.MoveRobotControllerRPC;
import com.ur.move.automove.requestmove.ThreePositionDeviceManager;
import com.ur.move.poseeditor.PoseRequest;
import com.ur.move.resources.MoveImageResource;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.initializerobot.RobotInitializationService;
import com.ur.polyscope.move.AutoMoveCallback;
import com.ur.polyscope.move.MoveRequest;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.safety.threepositiondevice.ThreePositionConfiguration;
import com.ur.polyscope.safety.threepositiondevice.ThreePositionDevice;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.viewfacade.program.ProgramUiControl;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.swing.CardPanel;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogOnScreen;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.constants.runtime.ControlMode;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

@Singleton
public class ImprovedAutoMoveTabSubPanel
extends CardPanel
implements AutoMoveDone,
MoveButtonsPanelCallback,
AutoMoveTabSubPanel,
ThreePositionDeviceManager {
    private static final String MAIN_PANEL = "main_panel";
    private final JointPositionVector realRobotJointPosition = new JointPositionVector();
    private final RunningRobotRequirement runningRobotRequirement;
    private final MoveRobotControllerRPC moveRobotControllerRPC;
    private final RobotCanvas3DFactory robotCanvas3DFactory;
    private final PayloadService payloadService;
    private final TextResource textResource;
    private final MessageDialogCreator dialogCreator;
    private final HelpIdAssigner helpIdAssigner;
    private final DialogOnScreen moveDialog;
    private final ProgramUiControl programUiControl;
    private final AutoMoveContinuePanel continuePanel;
    private final Set<AutoMoveDoneUiExtension> autoMoveDoneUiExtensions;
    private final Recipe<ArmModeComposite> armModeCompositeRecipe;
    private final InverseKinematicProviderExt inverseKinematicProviderExt;
    private final UserAccessControl userAccessControl;
    private final ThreePositionConfiguration threePositionConfiguration;
    protected JLabel autoMoveLabel;
    private final RobotInitializationService initializationRobotDialog;
    private RobotCanvas3D robotCanvas3D;
    private final JointPositionVector oldTargetJointPosition = new JointPositionVector();
    private JointPositionVector targetJointPosition = new JointPositionVector();
    private Pose6d targetPose;
    private Speed robotMoveSpeed;
    final AutoRunningState runningState;
    private boolean isDrivenByPose;
    private boolean isAPoseRequestWithJointPosition;
    private boolean onEnterWasRealRobot;
    private boolean isNear;
    private JPanel cardPanel;
    private JPanel robotPanel;
    private JPanel centerPanel;
    private JLabel titleLabel;
    private JLabel illustrationLabel;
    private JLabel payloadWarningLabel;
    private AutoMoveDoneUiExtension activeAutoMoveDoneUiExtension;
    private Subscription armModeCompositeSubscription;
    private AutoMoveCallback moveRequestCallback;
    protected final MoveButtonsPanelCreator moveButtonsPanel;
    private final Recipe<ThreePositionDevice> threePositionDeviceRecipe;
    private final AtomicReference<Object> enterObjectReference = new AtomicReference<Object>(null);

    @Inject
    protected ImprovedAutoMoveTabSubPanel(MoveRobotControllerRPC moveRobotControllerRPC, RobotCanvas3DFactory robotCanvas3DFactory, RunningRobotRequirement runningRobotRequirement, RobotInitializationService initializationRobotDialog, @Source(value=Arm.class) Recipe<Arm> armRecipe, @Source(value=RobotMode.class) Recipe<RobotMode> robotModeRecipe, @Source(value=ThreePositionDevice.class) Recipe<ThreePositionDevice> threePositionDeviceRecipe, DialogOnScreen moveDialog, ProgramUiControl programUiControl, AutoMoveContinuePanel continuePanel, Set<AutoMoveDoneUiExtension> autoMoveDoneUiExtensions, PayloadService payloadService, ViewContext viewContext, InverseKinematicProviderExt inverseKinematicProviderExt, UserAccessControl userAccessControl, ThreePositionConfiguration threePositionConfiguration) {
        this.moveRobotControllerRPC = moveRobotControllerRPC;
        this.robotCanvas3DFactory = robotCanvas3DFactory;
        this.runningRobotRequirement = runningRobotRequirement;
        this.initializationRobotDialog = initializationRobotDialog;
        this.dialogCreator = viewContext.getDialogCreator();
        this.moveDialog = moveDialog;
        this.programUiControl = programUiControl;
        this.continuePanel = continuePanel;
        this.autoMoveDoneUiExtensions = autoMoveDoneUiExtensions;
        this.payloadService = payloadService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.inverseKinematicProviderExt = inverseKinematicProviderExt;
        this.userAccessControl = userAccessControl;
        this.threePositionConfiguration = threePositionConfiguration;
        this.moveButtonsPanel = new MoveButtonsPanelCreator(viewContext, this);
        this.runningState = new AutoRunningState();
        this.threePositionDeviceRecipe = threePositionDeviceRecipe;
        this.initComponents();
        this.initHelpIds();
        this.armModeCompositeRecipe = Recipe.combineLatest(armRecipe, robotModeRecipe, ArmModeComposite::new);
    }

    @Override
    public void handleActionButton(ThreePositionDevice threePositionDevice) {
        OperationalMode operationalMode = this.userAccessControl.getCurrentOperationalMode();
        if (this.isDeviceTriggeredInManualMode(threePositionDevice, operationalMode) || this.isAutomaticOperationalMode(operationalMode)) {
            this.setButtonStates();
            return;
        }
        this.moveButtonsPanel.setAllMovementButtonState(false);
    }

    private boolean isDeviceTriggeredInManualMode(ThreePositionDevice threePositionDevice, OperationalMode operationalMode) {
        return threePositionDevice.isTriggered() && operationalMode.equals((Object)OperationalMode.MANUAL);
    }

    private boolean isAutomaticOperationalMode(OperationalMode operationalMode) {
        return operationalMode.equals((Object)OperationalMode.AUTOMATIC);
    }

    private void setButtonStates() {
        if (this.isPressAndHoldButtonPressed()) {
            this.disableButtons(this.moveButtonsPanel.manualButton, this.moveButtonsPanel.singleClickMove);
        } else if (this.isAutomaticMoveRunning()) {
            this.disableButtons(this.moveButtonsPanel.manualButton, this.moveButtonsPanel.holdToMoveButton);
        } else {
            this.moveButtonsPanel.setAllMovementButtonState(true);
        }
    }

    private void disableButtons(JButton ... buttons) {
        for (JButton button : buttons) {
            button.setEnabled(false);
        }
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.moveButtonsPanel.holdToMoveButton, "gui:automovetab_auto_button");
        this.helpIdAssigner.assignHelpId((JComponent)this.moveButtonsPanel.manualButton, "gui:automovetab_manual_button");
        this.helpIdAssigner.assignHelpId((JComponent)this.robotPanel, "gui:automovetab_animation");
        this.helpIdAssigner.assignHelpId((JComponent)this.titleLabel, "gui:automovetab_explained");
    }

    private void updateRobotState(ArmModeComposite composite) {
        Arm arm = composite.arm;
        RobotMode robotMode = composite.robotMode;
        if (this.shouldAbortAutomove(robotMode.isReal())) {
            this.stopAutomove();
        }
        this.updateNear(arm);
        this.moveButtonsPanel.handleButtonState(robotMode);
        boolean isRobotInRunningState = this.isRobotInRunningState(robotMode);
        if (this.isRobotAtRequestedPosition(arm, robotMode)) {
            this.handleRobotAtRequestedPosition();
        } else if (this.isFreedriveEnabled(robotMode)) {
            this.handleFreedriveEnabled();
        } else if (!robotMode.isProgramRunning() && !this.runningState.isPressAndHoldButtonPressed()) {
            this.handleProgramNotRunning(isRobotInRunningState, arm, robotMode);
        } else {
            this.handleElseCondition();
        }
        this.robotCanvas3D.addQueue((Runnable)new UpdateTCPAndJointAngles(arm));
    }

    private void stopAutomove() {
        this.runningState.releasePressAndHold();
        this.stopAutomaticMove();
    }

    private void handleRobotAtRequestedPosition() {
        this.activeAutoMoveDoneUiExtension.updateActionName();
        this.showCard(this.activeAutoMoveDoneUiExtension.getClass().getName());
        this.updateTitleAndDescription();
    }

    private void handleFreedriveEnabled() {
        this.runningState.releasePressAndHold();
    }

    private void handleProgramNotRunning(boolean isRobotInRunningState, Arm arm, RobotMode robotMode) {
        if (!robotMode.isSecurityStopped() && isRobotInRunningState) {
            this.sendSimulatedMoveProgram(arm);
        }
        this.updateTextAndIllustration();
        this.showCard(MAIN_PANEL);
    }

    private void handleElseCondition() {
        this.updateTextAndIllustration();
        this.showCard(MAIN_PANEL);
    }

    private void showCard(String cardName) {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show(this.cardPanel, cardName);
    }

    private void updateTitleAndDescription() {
        this.titleLabel.setIcon(this.activeAutoMoveDoneUiExtension.getIcon());
        this.titleLabel.setText(HTML.html((String)HTML.h1((String)this.activeAutoMoveDoneUiExtension.getTitle())));
        this.titleLabel.setHorizontalAlignment(0);
        this.autoMoveLabel.setText(HTML.html((String)this.activeAutoMoveDoneUiExtension.getDescription()));
        this.autoMoveLabel.setHorizontalAlignment(0);
    }

    private boolean isFreedriveEnabled(RobotMode robotMode) {
        return robotMode.getControlMode().equals((Object)ControlMode.TEACH);
    }

    private boolean shouldAbortAutomove(boolean isRealRobot) {
        if (this.moveButtonsPanel.isSingleClickRunning() && this.runningState.isAutoMoveRunning()) {
            return false;
        }
        boolean dialogShowed = this.runningState.isAutoMoveRunning() && this.moveDialog.isShowingADialog();
        boolean automoveButtonNotPressed = this.runningState.isAutoMoveRunning() && !this.runningState.isPressAndHoldButtonPressed() && isRealRobot;
        return dialogShowed || automoveButtonNotPressed;
    }

    private void updateNear(Arm arm) {
        this.isNear = false;
        if (this.isDrivenByPose()) {
            Pose6d currentPose = new Pose6d(arm.getTool().getCartesianInfo().getTool());
            boolean bl = this.isNear = Pose6dTransformUtils.aggregatedDistanceTo((Pose6d)currentPose, (Pose6d)this.targetPose) < 0.005;
            if (this.targetJointPosition != null) {
                this.isNear &= arm.getActualJointsPosition().epsilonEquals(this.targetJointPosition, 0.005);
            }
        } else if (arm.getActualJointsPosition().epsilonEquals(this.targetJointPosition, 0.005)) {
            this.isNear = true;
        }
    }

    private boolean isDrivenByPose() {
        return this.isDrivenByPose;
    }

    public void setDrivenByPose(boolean drivenByPose) {
        this.isDrivenByPose = drivenByPose;
    }

    boolean isRobotAtRequestedPosition(Arm arm, RobotMode robotMode) {
        return arm.isRealRobot() && !robotMode.isProgramRunning() && this.isNear;
    }

    protected void updateTextAndIllustration() {
        OperationalMode operationalMode = this.userAccessControl.getCurrentOperationalMode();
        if (this.threePositionConfiguration.isConfigured() && operationalMode.equals((Object)OperationalMode.MANUAL)) {
            this.handle3PETextAndIllustration();
            this.moveButtonsPanel.singleClickMove.setVisible(true);
        } else {
            this.autoMoveLabel.setText(this.textResource.automoveExplanationG5());
            this.setTPIllustrationVisible(false);
            this.moveButtonsPanel.singleClickMove.setVisible(false);
        }
        this.titleLabel.setIcon(null);
        this.titleLabel.setText(this.textResource.tabAutomoveTitle());
    }

    private void handle3PETextAndIllustration() {
        if (this.threePositionConfiguration.isSafetyIOConfigured()) {
            this.updateExternal3PETextAndIllustration();
            return;
        }
        this.autoMoveLabel.setText(this.textResource.automoveExplanation3pe());
        this.setTPIllustrationVisible(true);
    }

    private void updateExternal3PETextAndIllustration() {
        this.autoMoveLabel.setText(this.textResource.automoveExplanationExternal3pe());
        this.setTPIllustrationVisible(false);
    }

    private boolean isBackFromManualMove(Object o) {
        return o == null && this.activeAutoMoveDoneUiExtension != null;
    }

    public Object exit() {
        this.unsubscribeFromRobotEvents();
        this.robotCanvas3D.exit();
        return super.exit();
    }

    public void enter(Object o) {
        o = this.storeAndGetLastestEnterObject(o);
        this.manageButtonActivationWith3PE(this.threePositionDeviceRecipe);
        this.programUiControl.stopProgram();
        this.moveButtonsPanel.exitButtonAction.setEnabled(true);
        this.onEnterWasRealRobot = RobotState.getLatestRobotState().real;
        this.isAPoseRequestWithJointPosition = false;
        this.runningState.stopAutomoving();
        if (!this.isBackFromManualMove(o)) {
            this.activeAutoMoveDoneUiExtension = this.continuePanel;
        }
        String subTitle = this.textResource.NewPosition();
        if (o instanceof AutoMoveTitleComposite) {
            AutoMoveTitleComposite otc = (AutoMoveTitleComposite)o;
            subTitle = otc.title;
            o = otc.o;
        }
        this.moveButtonsPanel.setSubTitle(subTitle);
        this.moveButtonsPanel.setInitialAutoMoveButton();
        this.handleHoldToMoveButtonText(subTitle);
        if (o instanceof AutoMoveActionResult) {
            AutoMoveActionResult autoMoveActionResult = (AutoMoveActionResult)o;
            this.activeAutoMoveDoneUiExtension = autoMoveActionResult.getAutoMoveDoneUiExtension();
            this.oldTargetJointPosition.set(this.targetJointPosition);
            this.targetJointPosition.set(autoMoveActionResult.getDesiredPosition());
        } else if (o instanceof JointPositionVector) {
            this.oldTargetJointPosition.set(this.targetJointPosition);
            this.targetJointPosition.set((JointPositionVector)o);
        } else if (o instanceof Pose6d) {
            Point3d r;
            this.targetPose = (Pose6d)o;
            Point3d p = new Point3d((Tuple3d)this.targetPose.getPos());
            JointPositionVector jpv = this.inverseKinematicProviderExt.getInverseKinematicsMoveL(p, r = new Point3d((Tuple3d)this.targetPose.getRot()), RobotState.getLatestRobotState().jointPosition);
            if (jpv != null) {
                this.targetJointPosition = jpv;
            }
        } else if (o instanceof PoseRequest) {
            PoseRequest poseRequest = (PoseRequest)o;
            this.targetPose = poseRequest.getTargetToolPose();
            if (poseRequest.getTargetJointPosition() != null) {
                this.targetJointPosition = poseRequest.getTargetJointPosition();
                this.isAPoseRequestWithJointPosition = true;
            }
        } else if (o instanceof MoveRequest) {
            MoveRequest moveRequest = (MoveRequest)o;
            this.moveRequestCallback = moveRequest.getCallback();
            this.robotMoveSpeed = moveRequest.getSpeed().orElse(null);
            if (moveRequest.getTargetJointConfiguration() != null) {
                this.oldTargetJointPosition.set(this.targetJointPosition);
                this.targetJointPosition.set(new JointPositionVector(moveRequest.getTargetJointConfiguration().asArray()));
            }
            if (moveRequest.getTargetPose() != null) {
                this.targetPose = new Pose6d(moveRequest.getTargetPose().asArray());
                JointPositionVector jpv = this.inverseKinematicProviderExt.getInverseKinematics(this.targetPose, RobotState.getLatestRobotState().jointPosition);
                if (jpv != null) {
                    this.targetJointPosition = jpv;
                }
            }
        }
        this.setDrivenByPose(this.targetPose != null);
        this.runningState.requestSimAutomaticMove();
        this.initializationRobotDialog.initializeRobot(true);
        this.robotCanvas3D.setVisible(true);
        this.robotCanvas3D.enter();
        this.robotCanvas3D.addQueue((Runnable)new DisplayShadowRobot(this.targetJointPosition, this.targetPose));
        this.armModeCompositeSubscription = this.armModeCompositeRecipe.subscribe(armModeComposite -> {
            this.updateRobotState((ArmModeComposite)armModeComposite);
            this.updateAutoMove((ArmModeComposite)armModeComposite);
        });
        this.setPayloadWarningVisible(this.showPayloadWarning());
    }

    private Object storeAndGetLastestEnterObject(Object o) {
        if (o == null) {
            return this.enterObjectReference.get();
        }
        this.enterObjectReference.set(o);
        return o;
    }

    private void handleHoldToMoveButtonText(String subTitle) {
        if (this.threePositionConfiguration.isConfigured() && this.userAccessControl.getCurrentOperationalMode() == OperationalMode.MANUAL) {
            this.moveButtonsPanel.holdToMoveButton.setText(this.textResource.tabAutomoveHoldToMoveRobot());
        } else {
            this.moveButtonsPanel.holdToMoveButton.setText("<html>" + this.textResource.tabAutomoveMoveRobotTo() + ":<br/>" + subTitle + "</html>");
        }
    }

    private void setPayloadWarningVisible(boolean visible) {
        this.payloadWarningLabel.setVisible(visible);
    }

    protected boolean showPayloadWarning() {
        return this.payloadService.getInstallationDefaultPayload().getMass().equals((Object)Weight.ZERO);
    }

    private void updateAutoMove(ArmModeComposite composite) {
        Arm arm = composite.arm;
        if (this.isPressAndHoldButtonPressed()) {
            this.holdToMoveButtonPressed(arm.isRealRobot());
        } else if (this.moveButtonsPanel.isSingleClickRunning()) {
            this.singleClickMoveButtonPressed(arm.isRealRobot());
        } else if (this.runningState.isAutoMoving() && !this.isPressAndHoldButtonPressed()) {
            this.holdToMoveButtonReleased(arm.isRealRobot());
        }
    }

    private void setTPIllustrationVisible(boolean visible) {
        if (visible) {
            this.centerPanel.add((Component)this.illustrationLabel, 1);
        } else {
            this.centerPanel.remove(this.illustrationLabel);
        }
        this.centerPanel.validate();
        this.centerPanel.repaint();
    }

    private boolean isRobotInRunningState(RobotMode robotMode) {
        return com.ur.view.constants.dev.RobotMode.RUNNING.equals((Object)robotMode.getRobotMode());
    }

    private void sendSimulatedMoveProgram(Arm robotArm) {
        if (robotArm.isRealRobot()) {
            this.moveRobotControllerRPC.sendSetSimulatedRobot();
            this.runningState.requestSimAutomaticMove();
        } else {
            this.realRobotJointPosition.set(robotArm.getActualJointsPosition());
            if (!this.realRobotJointPosition.epsilonEquals(this.targetJointPosition, 0.005)) {
                if (this.runningState.isSimAutomaticMoveRequested()) {
                    this.runningState.cancelSimAutomaticMoveRequest();
                    if (this.realRobotJointPosition.isUndefined() || this.targetJointPosition.isUndefined() && this.targetPose == null) {
                        this.showCannotMoveToUndefinedPositionError();
                    } else if (this.isDrivenByPose()) {
                        this.moveRobotControllerRPC.sendSimulatedRobotProgram(this.realRobotJointPosition, this.targetPose, this.robotMoveSpeed);
                    } else {
                        this.moveRobotControllerRPC.sendSimulatedRobotProgram(this.targetJointPosition);
                    }
                }
            } else {
                this.moveRobotControllerRPC.sendSetRealRobot();
            }
        }
    }

    private void showCannotMoveToUndefinedPositionError() {
        this.dialogCreator.showMessageDialog(new DialogMessage(this.textResource.Message(), this.textResource.cannotAutomoveToUndefinedPosition()), MessageDialogType.MESSAGE, new OkDialogListener());
    }

    @Override
    public void startAutoMove() {
        Log.debug((String)"start automatic move");
        if (this.runningRobotRequirement.checkAndNotify()) {
            this.moveButtonsPanel.manualButton.setEnabled(false);
            this.moveButtonsPanel.disableAutoButtons();
            this.programUiControl.stopProgram();
            this.sendMoveProgram();
            this.runningState.start();
        }
    }

    @Override
    public void stopAutomaticMove() {
        if (this.runningState.isAutoMoveRunning()) {
            Log.debug((String)"stop automatic move");
            if (this.isDrivenByPose()) {
                ControllerSocketSender.sendStopLinear(1.5);
            } else {
                ControllerSocketSender.sendStopJoint(1.5);
            }
            this.runningState.stop();
            this.moveButtonsPanel.manualButton.setEnabled(true);
        }
    }

    private boolean isPressAndHoldButtonPressed() {
        return this.moveButtonsPanel.holdToMoveButton.getModel().isPressed();
    }

    @Override
    public boolean isPressAndHoldButtonInPressedState() {
        return this.runningState.isPressAndHoldButtonPressed();
    }

    @Override
    public boolean isAutomaticMoveRunning() {
        return this.runningState.isAutoMoveRunning();
    }

    private void sendMoveProgram() {
        if (this.isDrivenByPose() && this.isAPoseRequestWithJointPosition) {
            this.moveRobotControllerRPC.sendMoveLProgram(this.targetPose, this.targetJointPosition, this.robotMoveSpeed);
        } else if (this.isDrivenByPose()) {
            this.moveRobotControllerRPC.sendMoveLProgram(this.targetPose, null, this.robotMoveSpeed);
        } else {
            this.moveRobotControllerRPC.sendMoveJProgram(this.targetJointPosition);
        }
        this.runningState.requestSimAutomaticMove();
    }

    private void recreateRobotSimulationState() {
        if (this.onEnterWasRealRobot) {
            this.moveRobotControllerRPC.sendSetRealRobot();
        } else {
            this.moveRobotControllerRPC.sendSetSimulatedRobot();
        }
    }

    private void initComponents() {
        this.illustrationLabel = new JLabel(MoveImageResource.autoMove3pe());
        this.illustrationLabel.setPreferredSize(new Dimension(246, 181));
        JPanel mainPanel = this.createMainPanel(this.createTopPanel(), this.createCenterPanel());
        this.setName(this.textResource.tabAutomove());
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.add(mainPanel, "Center");
    }

    private JPanel createMainPanel(JPanel topPanel, JPanel centerPanel) {
        JPanel outerCenterPanel = new JPanel(new BorderLayout());
        outerCenterPanel.add((Component)centerPanel, "Center");
        outerCenterPanel.add((Component)this.createPayloadWarningPanel(), "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)outerCenterPanel, "Center");
        mainPanel.add((Component)this.createSpacer(), "West");
        mainPanel.add((Component)this.createSpacer(), "East");
        return mainPanel;
    }

    private JPanel createCenterPanel() {
        this.robotCanvas3D = this.robotCanvas3DFactory.buildMetalRobot();
        this.robotCanvas3D.setDebugName("G5 Automove 3D Canvas");
        this.robotCanvas3D.showStaticElements(Arrays.asList(VisualizerElementType.PAYLOAD_COG, VisualizerElementType.TCP));
        this.robotPanel = new JPanel();
        this.robotPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.robotPanel.setLayout(new BorderLayout());
        this.robotPanel.add(this.robotCanvas3D.getComponent());
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(this.createCardLayout());
        this.cardPanel.add((Component)this.moveButtonsPanel, MAIN_PANEL);
        for (AutoMoveDoneUiExtension autoMoveDoneUiExtension : this.autoMoveDoneUiExtensions) {
            autoMoveDoneUiExtension.bind(this);
            JPanel panel = autoMoveDoneUiExtension.createPanel();
            this.cardPanel.add((Component)panel, panel.getClass().getName());
        }
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show(this.cardPanel, MAIN_PANEL);
        this.centerPanel = new JPanel(new GridLayout(1, 3));
        this.centerPanel.add(this.robotPanel);
        this.centerPanel.add(this.cardPanel);
        return this.centerPanel;
    }

    private JPanel createPayloadWarningPanel() {
        this.payloadWarningLabel = new JLabel(HTML.html((String)this.textResource.payloadUnsetWarning()), MoveImageResource.formWarning(), 0);
        this.payloadWarningLabel.setForeground(Color.RED);
        this.payloadWarningLabel.setVisible(false);
        JPanel payloadWarningPanel = new JPanel();
        payloadWarningPanel.setLayout(new BoxLayout(payloadWarningPanel, 1));
        payloadWarningPanel.setAlignmentX(0.0f);
        payloadWarningPanel.setBorder(new EmptyBorder(20, 10, 0, 10));
        payloadWarningPanel.add(this.payloadWarningLabel);
        return payloadWarningPanel;
    }

    private JPanel createTopPanel() {
        this.titleLabel = new JLabel();
        this.titleLabel.setBorder(new EmptyBorder(20, 20, 0, 20));
        this.titleLabel.setFont(new Font("Dialog", 1, 24));
        this.titleLabel.setText(this.textResource.tabAutomoveTitle());
        this.titleLabel.setHorizontalAlignment(0);
        this.autoMoveLabel = new JLabel();
        this.autoMoveLabel.setBorder(new EmptyBorder(20, 20, 0, 20));
        this.autoMoveLabel.setText(this.textResource.automoveExplanationG5());
        this.autoMoveLabel.setHorizontalAlignment(0);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.setAlignmentX(0.0f);
        topPanel.add(this.titleLabel);
        topPanel.add(this.autoMoveLabel);
        return topPanel;
    }

    private JPanel createSpacer() {
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(100, 200));
        return spacer;
    }

    CardLayout createCardLayout() {
        return new CardLayout();
    }

    void holdToMoveButtonPressed(boolean isRealRobot) {
        this.handleButtonPress(isRealRobot, this.moveButtonsPanel.holdToMoveButton.isEnabled());
    }

    void singleClickMoveButtonPressed(boolean isRealRobot) {
        this.handleButtonPress(isRealRobot, true);
    }

    private void handleButtonPress(boolean isRealRobot, boolean shouldStartAutoMove) {
        if (isRealRobot && !this.runningState.isAutoMoving() && shouldStartAutoMove) {
            this.runningState.pressPressAndHold();
            this.startAutoMove();
            this.runningState.startAutomoving();
        } else if (!isRealRobot) {
            this.runningState.stopAutomoving();
            this.moveRobotControllerRPC.sendSetRealRobot();
            this.runningState.cancelSimAutomaticMoveRequest();
        }
    }

    private void holdToMoveButtonReleased(boolean isRealRobot) {
        if (!this.isNear && isRealRobot) {
            this.runningState.releasePressAndHold();
            this.stopAutomaticMove();
        }
        if (this.runningState.isAutoMoving() && !isRealRobot) {
            this.moveButtonsPanel.holdToMoveButton.setEnabled(true);
            this.runningState.stopAutomoving();
        }
    }

    @Override
    public void manualButtonActionPerformed() {
        RequestManualMove requestManualMove = new RequestManualMove(this.targetJointPosition);
        if (this.moveButtonsPanel.manualButton.isEnabled()) {
            this.exitCard(() -> this.stackCurrentCardAndSwitchTo(MoveTab.class, requestManualMove));
        }
    }

    @Override
    public void continuePressed() {
        this.exitCard(() -> {
            this.onComplete();
            this.moveRequestCallback = null;
            this.navigateBack();
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, MAIN_PANEL);
        });
    }

    private void onComplete() {
        AutoMoveCallback autoMoveCallback = this.moveRequestCallback;
        SwingUtil.invokeLater(() -> {
            if (autoMoveCallback != null) {
                autoMoveCallback.onComplete();
            }
        });
    }

    @Override
    public void exitPressed() {
        this.doExitForCard();
    }

    @Override
    public void doExitForCard() {
        this.exitCard(() -> {
            this.onCancel();
            this.moveRequestCallback = null;
            this.targetJointPosition.set(this.oldTargetJointPosition);
            this.navigateBack();
        });
    }

    private void onCancel() {
        AutoMoveCallback autoMoveCallback = this.moveRequestCallback;
        SwingUtil.invokeLater(() -> {
            if (autoMoveCallback != null) {
                autoMoveCallback.onCancel();
            }
        });
    }

    private void exitCard(Runnable runnable) {
        this.stopProgram();
        this.unsubscribeFromRobotEvents();
        this.resetUI();
        this.recreateRobotSimulationState();
        SimRealStateListener simRealStateListener = new SimRealStateListener(runnable);
        EventNotificationService.register((Object)simRealStateListener, RobotStateListener.class, (Object)simRealStateListener);
    }

    private void unsubscribeFromRobotEvents() {
        this.armModeCompositeSubscription.dispose();
        this.armModeCompositeSubscription = Subscription.NULL;
    }

    private void stopProgram() {
        if (this.runningState.isAutoMoveRunning()) {
            ControllerSocketSender.sendStopProgram();
            this.runningState.stop();
        }
    }

    private void resetUI() {
        this.moveButtonsPanel.holdToMoveButton.setEnabled(false);
        this.moveButtonsPanel.manualButton.setEnabled(false);
        this.moveButtonsPanel.exitButtonAction.setEnabled(false);
        this.robotCanvas3D.setVisible(false);
        this.targetPose = null;
        this.robotMoveSpeed = null;
    }

    private class SimRealStateListener
    implements RobotStateListener {
        Runnable navigation;

        public SimRealStateListener(Runnable navigation) {
            this.navigation = navigation;
        }

        public void updateRobotState(RobotState robotState) {
            if (robotState.real == ImprovedAutoMoveTabSubPanel.this.onEnterWasRealRobot) {
                EventNotificationService.unregister((Object)this, RobotStateListener.class);
                this.navigation.run();
            }
        }
    }

    private static class ArmModeComposite {
        private final Arm arm;
        private final RobotMode robotMode;

        ArmModeComposite(Arm arm, RobotMode robotMode) {
            this.arm = arm;
            this.robotMode = robotMode;
        }
    }

    private final class DisplayShadowRobot
    implements Runnable {
        private final JointPositionVector targetPositionFinal;
        private final Pose6d targetPoseFinal;

        private DisplayShadowRobot(JointPositionVector targetPositionFinal, Pose6d targetPoseFinal) {
            this.targetPositionFinal = targetPositionFinal;
            this.targetPoseFinal = targetPoseFinal;
        }

        @Override
        public void run() {
            if (this.targetPositionFinal != null) {
                ImprovedAutoMoveTabSubPanel.this.robotCanvas3D.setShadowRobotJointAngleVector(this.targetPositionFinal);
            } else if (this.targetPoseFinal != null) {
                ImprovedAutoMoveTabSubPanel.this.robotCanvas3D.setShadowRobotJointAngleVector(RobotState.getLatestRobotState().jointPosition);
            }
        }
    }

    private final class UpdateTCPAndJointAngles
    implements Runnable {
        private final Arm arm;

        private UpdateTCPAndJointAngles(Arm arm) {
            this.arm = arm;
        }

        @Override
        public void run() {
            ImprovedAutoMoveTabSubPanel.this.robotCanvas3D.setJointAngleVector(this.arm.getActualJointsPosition());
        }
    }
}

