/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove;

import com.ur.log.logentry.robotmessage.SafetyModeCategory;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.monitor.model.RobotMode;
import com.ur.move.automove.AutoMoveTab;
import com.ur.move.automove.MoveButtonsPanelCallback;
import com.ur.move.automove.button.LockableMoveButton;
import com.ur.move.automove.button.SingleClickMove;
import com.ur.move.resources.MoveImageResource;
import com.ur.move.resources.TextResource;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.ControlMode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class MoveButtonsPanelCreator
extends JPanel {
    private final TextResource textResource;
    private final WidgetFactory widgetFactory;
    private final MoveButtonsPanelCallback callback;
    SingleClickMove singleClickMove;
    LockableMoveButton holdToMoveButton;
    LockableMoveButton manualButton;
    ExitButtonAction exitButtonAction;

    public MoveButtonsPanelCreator(ViewContext viewContext, MoveButtonsPanelCallback callback) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.widgetFactory = viewContext.createWidgetFactory();
        this.callback = callback;
        this.exitButtonAction = new ExitButtonAction();
        this.initComponents();
    }

    boolean isSingleClickRunning() {
        return this.singleClickMove.isButtonClickedToMove();
    }

    private void initComponents() {
        this.singleClickMove = new SingleClickMove(this.textResource, MoveButtonsPanelCreator.createButtonDimension(), this.callback);
        this.holdToMoveButton = new LockableMoveButton();
        this.holdToMoveButton.setName(AutoMoveTab.AUTO_MOVE_BUTTON);
        this.holdToMoveButton.setText(this.textResource.Auto());
        this.holdToMoveButton.setHorizontalAlignment(0);
        this.holdToMoveButton.setMaximumSize(MoveButtonsPanelCreator.createButtonDimension());
        this.holdToMoveButton.setMinimumSize(MoveButtonsPanelCreator.createButtonDimension());
        this.holdToMoveButton.setPreferredSize(MoveButtonsPanelCreator.createButtonDimension());
        this.holdToMoveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (MoveButtonsPanelCreator.this.callback.isPressAndHoldButtonInPressedState()) {
                    MoveButtonsPanelCreator.this.holdToMoveButton.getModel().setPressed(false);
                }
            }
        });
        this.manualButton = new LockableMoveButton();
        this.manualButton.setName(AutoMoveTab.MANUAL_MOVE_BUTTON);
        this.manualButton.setText(this.textResource.Manual());
        this.manualButton.setIcon(MoveImageResource.moveBlack());
        this.manualButton.setIconTextGap(16);
        this.manualButton.setHorizontalAlignment(0);
        this.manualButton.setMaximumSize(MoveButtonsPanelCreator.createButtonDimension());
        this.manualButton.setPreferredSize(MoveButtonsPanelCreator.createButtonDimension());
        this.manualButton.setMinimumSize(MoveButtonsPanelCreator.createButtonDimension());
        this.manualButton.addActionListener(evt -> this.callback.manualButtonActionPerformed());
        JButton exitButton = this.widgetFactory.createButton((Action)this.exitButtonAction);
        exitButton.setIconTextGap(16);
        exitButton.setHorizontalAlignment(0);
        exitButton.setMaximumSize(MoveButtonsPanelCreator.createButtonDimension());
        exitButton.setPreferredSize(MoveButtonsPanelCreator.createButtonDimension());
        exitButton.setMinimumSize(MoveButtonsPanelCreator.createButtonDimension());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        gb.insets = new Insets(0, 0, 0, 0);
        gb.anchor = 11;
        this.add((Component)this.singleClickMove, gb);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 1;
        gb.insets = new Insets(10, 0, 0, 0);
        gb.anchor = 11;
        this.add((Component)this.holdToMoveButton, gb);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 2;
        gb.insets = new Insets(10, 0, 0, 0);
        gb.anchor = 11;
        this.add((Component)this.manualButton, gb);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 3;
        gb.insets = new Insets(10, 0, 0, 0);
        gb.anchor = 11;
        this.add((Component)exitButton, gb);
    }

    private boolean isHoldToMoveButtonPressed() {
        return this.holdToMoveButton.getModel().isPressed();
    }

    void disableAutoButtons() {
        this.holdToMoveButton.setEnabled(this.isHoldToMoveButtonPressed());
        this.singleClickMove.setEnabled(!this.isHoldToMoveButtonPressed() && this.isSingleClickRunning());
    }

    void setAllMovementButtonState(boolean state) {
        this.holdToMoveButton.setEnabled(state);
        this.manualButton.setEnabled(state);
        this.singleClickMove.setEnabled(state);
    }

    void setSubTitle(String subTitle) {
        this.singleClickMove.setSubTitle(subTitle);
    }

    void setInitialAutoMoveButton() {
        this.singleClickMove.setInitialAutoMoveButton();
    }

    private static Dimension createButtonDimension() {
        return new Dimension(320, 70);
    }

    void handleButtonState(RobotMode robotMode) {
        if (robotMode.getControlMode().equals((Object)ControlMode.TEACH)) {
            this.handleButtonEnablement(true);
            return;
        }
        SafetyModeCategory safetyModeCategory = SafetyModes.getSafetyModeCategory((SafetyMode)robotMode.getSafetyMode());
        EnumSet<SafetyModeCategory> triggerModes = EnumSet.of(SafetyModeCategory.THREE_POSITION_ENABLING_STOP, SafetyModeCategory.PROTECTIVE_STOP, SafetyModeCategory.FAULT, SafetyModeCategory.EMERGENCY_STOP, SafetyModeCategory.SAFEGUARD_STOP);
        boolean lockEnablement = triggerModes.contains(safetyModeCategory);
        this.handleButtonEnablement(lockEnablement);
    }

    private void handleButtonEnablement(boolean lockEnablement) {
        if (lockEnablement) {
            this.lockButtonEnablement();
            return;
        }
        this.unlockButtonEnablement();
    }

    private void lockButtonEnablement() {
        this.singleClickMove.lockEnablement();
        this.holdToMoveButton.lockEnablement();
        this.manualButton.lockEnablement();
    }

    private void unlockButtonEnablement() {
        this.singleClickMove.unlockEnablement();
        this.holdToMoveButton.unlockEnablement();
        this.manualButton.unlockEnablement();
    }

    protected class ExitButtonAction
    extends AbstractAction {
        ExitButtonAction() {
            this.putValue("Name", MoveButtonsPanelCreator.this.textResource.Cancel());
            this.putValue("SmallIcon", this.getScaledIcon());
            this.putValue("InternalName", AutoMoveTab.EXIT_BUTTON);
        }

        private Icon getScaledIcon() {
            ImageIcon imageIcon = (ImageIcon)MoveImageResource.cancel();
            Image image = imageIcon.getImage();
            Image scaledInstance = image.getScaledInstance(38, 38, 4);
            imageIcon.setImage(scaledInstance);
            return imageIcon;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoveButtonsPanelCreator.this.callback.doExitForCard();
        }
    }
}

