/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.automove.RobotMoveSpeedConverter;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.util.logging.Log;
import javax.inject.Inject;

public class MoveRobotControllerRPC {
    private static final String INKOGNITO = "def inkognito():\n";
    private static final String END = "end\n";
    private static final String RESET_REVOLUTION_COUNTER = "reset_revolution_counter(qNear=%s)\n";
    private JointConfigurationSettings jointConfigurationSettings;
    private ControllerInterface controllerInterface;
    private final PayloadService payloadService;
    private final RobotMoveSpeedConverter robotMoveSpeedConverter;

    @Inject
    public MoveRobotControllerRPC(JointConfigurationSettings jointConfigurationSettings, ControllerInterface controllerInterface, PayloadService payloadService) {
        this.jointConfigurationSettings = jointConfigurationSettings;
        this.controllerInterface = controllerInterface;
        this.payloadService = payloadService;
        this.robotMoveSpeedConverter = new RobotMoveSpeedConverter();
    }

    public void sendSetRealRobot() {
        this.controllerInterface.runScript("set real\n");
    }

    public void sendSetSimulatedRobot() {
        PayloadComponent activePayload = this.payloadService.getActivePayload();
        this.controllerInterface.runScript("set sim\n");
        if (activePayload != null) {
            this.sendSetToolPayload((DomainComponent)activePayload);
        }
    }

    public void sendSimulatedRobotProgram(JointPositionVector targetPosition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(INKOGNITO);
        String resetResolutionCounter = String.format(RESET_REVOLUTION_COUNTER, targetPosition);
        stringBuilder.append("  ").append(resetResolutionCounter);
        stringBuilder.append("  ").append("initialPos = get_actual_joint_positions()\n");
        stringBuilder.append("  while True:\n");
        stringBuilder.append("    set_pos(initialPos)\n");
        stringBuilder.append("    movej(").append(targetPosition).append(")\n");
        stringBuilder.append("    sync()\n");
        stringBuilder.append("  ").append(END);
        stringBuilder.append(END);
        this.controllerInterface.runScript(stringBuilder.toString());
    }

    public void sendSimulatedRobotProgram(JointPositionVector initialPosition, Pose6d targetPose, Speed robotMoveSpeed) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(INKOGNITO);
        stringBuilder.append("  while True:\n");
        stringBuilder.append("    set_pos(").append(initialPosition).append(")\n");
        String moveLWithSpeedProgram = this.getMoveLWithSpeedProgram(targetPose, robotMoveSpeed);
        stringBuilder.append(moveLWithSpeedProgram);
        stringBuilder.append("    sync()\n");
        stringBuilder.append("  ").append(END);
        stringBuilder.append(END);
        this.controllerInterface.runScript(stringBuilder.toString());
    }

    public void sendMoveJProgram(JointPositionVector targetPosition) {
        double velocity = this.jointConfigurationSettings.getVJointDefault() / 2.0;
        double acceleration = this.jointConfigurationSettings.getAJointDefault() / 4.0;
        if (acceleration <= 0.0 || velocity <= 0.0) {
            Log.warning((String)("Both a and v needs to be positive. a = " + acceleration + " v = " + velocity));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(INKOGNITO);
        String resetResolutionCounter = String.format(RESET_REVOLUTION_COUNTER, targetPosition);
        stringBuilder.append("    ").append(resetResolutionCounter);
        stringBuilder.append("    movej(").append(targetPosition).append(", a =").append(acceleration).append(", v=").append(velocity).append(")\n");
        stringBuilder.append(END);
        this.controllerInterface.runScript(stringBuilder.toString());
    }

    public void sendMoveLProgram(Pose6d targetPose, JointPositionVector qNear, Speed robotMoveSpeed) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(INKOGNITO);
        if (qNear != null) {
            String resetResolutionCounter = String.format(RESET_REVOLUTION_COUNTER, qNear);
            stringBuilder.append("    ").append(resetResolutionCounter);
        }
        String moveLWithSpeedProgram = this.getMoveLWithSpeedProgram(targetPose, robotMoveSpeed);
        stringBuilder.append(moveLWithSpeedProgram);
        stringBuilder.append(END);
        Log.info((String)stringBuilder.toString());
        this.controllerInterface.runScript(stringBuilder.toString());
    }

    public void sendSetToolPayload(DomainComponent payloadComponent) {
        ScriptWriter scriptWriter = new ScriptWriter();
        scriptWriter.defineSecondary("set_payload");
        payloadComponent.writeScript(scriptWriter);
        scriptWriter.end();
        if (!this.controllerInterface.runScript(scriptWriter.generateScript())) {
            Log.warning((String)"Can't set active payload. Controller command failed.");
        }
    }

    private String getMoveLWithSpeedProgram(Pose6d targetPose, Speed robotMoveSpeed) {
        StringBuilder stringBuilder = new StringBuilder();
        double toolSpeed = this.robotMoveSpeedConverter.getToolSpeedInControllerFormat(robotMoveSpeed);
        stringBuilder.append("    movel(").append(targetPose).append(", a=0.1").append(", v=").append(toolSpeed).append(")\n");
        return stringBuilder.toString();
    }
}

