/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove.button;

import com.ur.move.automove.AutoMoveTab;
import com.ur.move.automove.MoveButtonsPanelCallback;
import com.ur.move.automove.button.LockableMoveButton;
import com.ur.move.resources.MoveImageResource;
import com.ur.move.resources.TextResource;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class SingleClickMove
extends LockableMoveButton {
    private final TextResource textResource;
    private String subTitle;
    boolean isButtonClickedToMove;
    private final MoveButtonsPanelCallback callback;

    public SingleClickMove(TextResource textResource, Dimension buttonDimension, MoveButtonsPanelCallback callback) {
        this.textResource = textResource;
        this.setName(AutoMoveTab.MOVE_ROBOT_TO_BUTTON);
        this.setText(textResource.Auto());
        this.setIcon(MoveImageResource.playIcon());
        this.setIconTextGap(16);
        this.setHorizontalAlignment(0);
        this.setMaximumSize(buttonDimension);
        this.setMinimumSize(buttonDimension);
        this.setPreferredSize(buttonDimension);
        this.setVisible(false);
        this.setFocusPainted(false);
        this.isButtonClickedToMove = false;
        this.callback = callback;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SingleClickMove.this.toggleAutoMove();
            }
        });
    }

    public boolean isButtonClickedToMove() {
        return this.isButtonClickedToMove;
    }

    public void toggleAutoMove() {
        boolean bl = this.isButtonClickedToMove = !this.isButtonClickedToMove;
        if (this.canAutoMove()) {
            this.startAutoMove();
        } else if (this.callback.isAutomaticMoveRunning()) {
            this.stopAutoMove();
        }
    }

    private boolean canAutoMove() {
        return this.isEnabled() && this.isButtonClickedToMove && !this.callback.isAutomaticMoveRunning();
    }

    private void startAutoMove() {
        this.setRunningAutoMoveButton();
        this.callback.startAutoMove();
    }

    private void stopAutoMove() {
        this.setInitialAutoMoveButton();
        this.callback.stopAutomaticMove();
    }

    public void setInitialAutoMoveButton() {
        this.setText(this.createAutomoveButtonText());
        this.setIcon(MoveImageResource.playIcon());
        this.isButtonClickedToMove = false;
    }

    private void setRunningAutoMoveButton() {
        this.setText(this.textResource.Stop());
        this.setIcon(MoveImageResource.stopBlack());
    }

    private String createAutomoveButtonText() {
        return "<html>" + this.textResource.tabAutomoveMoveRobotTo() + ":<br>" + this.subTitle + "</html>";
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    @Override
    public void lockEnablement() {
        super.lockEnablement();
        this.handleSafetyTriggeredState();
    }

    private void handleSafetyTriggeredState() {
        if (this.isButtonClickedToMove) {
            this.setInitialAutoMoveButton();
        }
    }
}

