/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove.requestmove;

import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.view.constants.dev.JointType;
import javax.inject.Inject;

public class JointConfigurationValidator {
    private JointConfigurationSettings jointConfigurationSettings;

    @Inject
    JointConfigurationValidator(JointConfigurationSettings jointConfigurationSettings) {
        this.jointConfigurationSettings = jointConfigurationSettings;
    }

    public boolean isValid(JointConfiguration jointConfiguration) {
        double[] maxLimit = this.jointConfigurationSettings.getJointMaxLimit();
        double[] minLimit = this.jointConfigurationSettings.getJointMinLimit();
        double[] joints = jointConfiguration.asArray();
        for (int i = 0; i < maxLimit.length; ++i) {
            if (this.isWrist3(i) && this.jointConfigurationSettings.infiniteRevolutionsForWrist3() || !(joints[i] < minLimit[i]) && !(joints[i] > maxLimit[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isWrist3(int id) {
        return JointType.WRIST3 == JointType.byId((int)id);
    }
}

