/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove.requestmove;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.automove.RobotMoveSpeedConverter;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.move.MoveRequest;
import com.ur.polyscope.viewfacade.program.ProgramUiControl;
import javax.inject.Inject;

class MoveRobot {
    private final ControllerInterface controllerInterface;
    private final ProgramUiControl programUiControl;
    private final RobotMoveSpeedConverter robotMoveSpeedConverter;

    @Inject
    public MoveRobot(ControllerInterface controllerInterface, ProgramUiControl programUiControl) {
        this.controllerInterface = controllerInterface;
        this.programUiControl = programUiControl;
        this.robotMoveSpeedConverter = new RobotMoveSpeedConverter();
    }

    public void moveRobotToTarget(MoveRequest moveRequest) {
        if (this.hasPoseOnly(moveRequest)) {
            Pose6d targetPose = new Pose6d(moveRequest.getTargetPose().asArray());
            double toolSpeedForPose = this.getToolSpeedForPose(moveRequest);
            StringBuilder sb = new StringBuilder();
            sb.append("movel(");
            sb.append(targetPose.toString());
            sb.append(", a=0.1");
            sb.append(", v=").append(toolSpeedForPose).append(")");
            sb.append("\n");
            this.controllerInterface.runScript(sb.toString());
        } else {
            JointPositionVector targetJpv = new JointPositionVector(moveRequest.getTargetJointConfiguration().asArray());
            StringBuilder sb = new StringBuilder();
            sb.append("movej(");
            sb.append(targetJpv.toString());
            sb.append(", a=0.3, v=0.1)");
            sb.append("\n");
            this.controllerInterface.runScript(sb.toString());
        }
    }

    private boolean hasPoseOnly(MoveRequest moveRequest) {
        return moveRequest.getTargetPose() != null && moveRequest.getTargetJointConfiguration() == null;
    }

    public void stopProgram() {
        this.programUiControl.stopProgram();
    }

    private double getToolSpeedForPose(MoveRequest moveRequest) {
        return this.robotMoveSpeedConverter.getToolSpeedInControllerFormat(moveRequest.getSpeed().orElse(null));
    }
}

