/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove.requestmove;

import com.ur.monitor.model.Arm;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.MoveRequestImpl;
import com.ur.move.automove.AlreadyAtPositionCallback;
import com.ur.move.automove.AutoMoveTab;
import com.ur.move.automove.requestmove.MoveRobot;
import com.ur.move.automove.requestmove.ValidateMove;
import com.ur.polyscope.move.MoveRequest;
import com.ur.polyscope.move.MoveRequestErrorType;
import com.ur.polyscope.move.RobotMovement;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.swing.FlipManager;
import com.ur.swing.FlipManagerProvider;
import com.ur.swing.SwingUtil;
import javax.inject.Inject;
import javax.inject.Provider;

public class RobotMovementImpl
implements RobotMovement {
    private final ValidateMove movementValidation;
    private MoveRobot moveRobot;
    private final Provider<FlipManager> fmProvider;
    private final AlreadyAtPositionCallback alreadyAtPositionCallback;

    @Inject
    public RobotMovementImpl(ValidateMove movementValidation, MoveRobot moveRobot, FlipManagerProvider flipManager, AlreadyAtPositionCallback alreadyAtPositionCallback) {
        this.movementValidation = movementValidation;
        this.moveRobot = moveRobot;
        this.fmProvider = flipManager;
        this.alreadyAtPositionCallback = alreadyAtPositionCallback;
    }

    public void moveTo(MoveRequest moveRequest) {
        if (this.movementValidation.robotNotRunning()) {
            moveRequest.getCallback().onCancel();
            return;
        }
        this.moveRobot.stopProgram();
        Arm robotArm = this.movementValidation.currentArm();
        if (this.movementValidation.isNearTarget(moveRequest, robotArm)) {
            if (this.movementValidation.isAlreadyAtTarget(moveRequest, robotArm)) {
                this.moveRobot.moveRobotToTarget(moveRequest);
                moveRequest.getCallback().onComplete();
                this.alreadyAtPositionCallback.call();
            } else {
                this.moveRobot.moveRobotToTarget(moveRequest);
                moveRequest.getCallback().onComplete();
            }
            return;
        }
        if (this.movementValidation.hasPoseAndQNear(moveRequest)) {
            this.moveRobotUsingPoseAndQNear(moveRequest, robotArm);
            return;
        }
        if (this.movementValidation.hasPoseOnly(moveRequest)) {
            this.moveRobotUsingPose(moveRequest, robotArm);
            return;
        }
        if (this.movementValidation.hasJointConfiguration(moveRequest)) {
            this.moveRobotUsingJointConfiguration(moveRequest);
        }
    }

    private void moveRobotUsingJointConfiguration(MoveRequest moveRequest) {
        if (this.movementValidation.validJointConfiguration(moveRequest)) {
            this.doSwitchToAutoMoveTab(moveRequest);
        } else {
            this.invokeLaterOnError(moveRequest, MoveRequestErrorType.INVALID_JOINT_POSITIONS);
        }
    }

    private void doSwitchToAutoMoveTab(MoveRequest moveRequest) {
        FlipManager fm = (FlipManager)this.fmProvider.get();
        Thread t = new Thread(() -> fm.stackCurrentCardAndSwitchTo(AutoMoveTab.class, (Object)moveRequest));
        t.start();
    }

    protected void invokeLaterOnError(MoveRequest moveRequest, MoveRequestErrorType moveRequestErrorType) {
        SwingUtil.invokeLater(() -> moveRequest.getCallback().onError(moveRequestErrorType));
    }

    private void moveRobotUsingPoseAndQNear(MoveRequest moveRequest, Arm robotArm) {
        JointPositionVector qNear = new JointPositionVector(moveRequest.getTargetJointConfiguration().asArray());
        this.switchToAutoMoveUsingPose(moveRequest, robotArm.getActualJointsPosition(), qNear);
    }

    private void moveRobotUsingPose(MoveRequest moveRequest, Arm robotArm) {
        this.switchToAutoMoveUsingPose(moveRequest, robotArm.getActualJointsPosition(), robotArm.getActualJointsPosition());
    }

    private void switchToAutoMoveUsingPose(MoveRequest moveRequest, JointPositionVector currentPosition, JointPositionVector qNear) {
        JointPositionVector qTargetComputed = this.movementValidation.getInverseKinematics(moveRequest, qNear);
        if (qTargetComputed == null) {
            this.invokeLaterOnError(moveRequest, MoveRequestErrorType.UNREACHABLE_POSE);
            return;
        }
        if (this.movementValidation.isReachableByMoveL(moveRequest, currentPosition, qTargetComputed)) {
            this.doSwitchToAutoMoveTab(new MoveRequestImpl(null, moveRequest.getTargetPose(), moveRequest.getCallback(), moveRequest.getSpeed().orElse(null)));
            return;
        }
        this.doSwitchToAutoMoveTab(new MoveRequestImpl(new JointConfiguration(qTargetComputed.getJoints()), null, moveRequest.getCallback()));
    }
}

