/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.automove.requestmove;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.Joint;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.requirements.RunningRobotRequirement;
import com.ur.move.KinematicsController;
import com.ur.move.automove.requestmove.JointConfigurationValidator;
import com.ur.polyscope.move.MoveRequest;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import javax.inject.Provider;

class ValidateMove {
    private static final double AT_TARGET_DIST = 1.0E-5;
    private static final double AT_TARGET_RAD = 1.0E-4;
    private static final double NEAR_TARGET_DIST = 0.005;
    private static final double NEAR_TARGET_RAD = 0.005;
    private RunningRobotRequirement runningRobotRequirement;
    private KinematicsController kinematicsController;
    private Provider<Arm> recipeArm;
    private JointConfigurationValidator jointConfigurationValidator;

    @Inject
    public ValidateMove(RunningRobotRequirement runningRobotRequirement, KinematicsController kinematicsController, @Source(value=Arm.class) Recipe<Arm> recipeArm, JointConfigurationValidator jointConfigurationValidator) {
        this.runningRobotRequirement = runningRobotRequirement;
        this.kinematicsController = kinematicsController;
        this.recipeArm = recipeArm.lastProvider();
        this.jointConfigurationValidator = jointConfigurationValidator;
    }

    public boolean robotNotRunning() {
        return !this.runningRobotRequirement.checkAndNotify();
    }

    public boolean isNearTarget(MoveRequest moveRequest, Arm arm) {
        return this.isEpsilonFromTarget(moveRequest, arm, 0.005, 0.005);
    }

    public boolean isAlreadyAtTarget(MoveRequest moveRequest, Arm arm) {
        return this.isEpsilonFromTarget(moveRequest, arm, 1.0E-5, 1.0E-4);
    }

    private boolean isEpsilonFromTarget(MoveRequest moveRequest, Arm arm, double poseEpsilon, double jointEpsilon) {
        JointPositionVector targetJPV;
        Pose6d targetPose;
        JointPositionVector currentJPV = this.getCurrentJPV(arm);
        Pose6d currentPose = this.kinematicsController.getTCPPose(currentJPV);
        if (this.hasPoseAndQNear(moveRequest)) {
            targetPose = new Pose6d(moveRequest.getTargetPose().asArray());
            targetJPV = new JointPositionVector(moveRequest.getTargetJointConfiguration().asArray());
        } else if (this.hasPoseOnly(moveRequest)) {
            targetPose = new Pose6d(moveRequest.getTargetPose().asArray());
            targetJPV = this.kinematicsController.getInverseKinematics(targetPose, currentJPV);
        } else {
            targetJPV = new JointPositionVector(moveRequest.getTargetJointConfiguration().asArray());
            targetPose = this.kinematicsController.getTCPPose(targetJPV);
        }
        if (currentPose == null || targetPose == null || targetJPV == null) {
            Log.error((String)"Failed to query via HMC call");
            return false;
        }
        return this.isEpsilonThereByPose6d(targetPose, currentPose, poseEpsilon) && this.isEpsilonThereByJPV(targetJPV, currentJPV, jointEpsilon);
    }

    private JointPositionVector getCurrentJPV(Arm arm) {
        JointPositionVector result = new JointPositionVector();
        for (Joint joint : arm.getJoints()) {
            result.setJoint(joint.getJointType(), joint.getTargetPosition());
        }
        return result;
    }

    private boolean isEpsilonThereByPose6d(Pose6d targetPose, Pose6d currentPose, double epsilon) {
        return Pose6dTransformUtils.aggregatedDistanceTo((Pose6d)currentPose, (Pose6d)targetPose) < epsilon;
    }

    private boolean isEpsilonThereByJPV(JointPositionVector targetPosition, JointPositionVector currentPosition, double epsilon) {
        return currentPosition.epsilonEquals(targetPosition, epsilon);
    }

    public boolean hasPoseOnly(MoveRequest moveRequest) {
        return moveRequest.getTargetPose() != null && moveRequest.getTargetJointConfiguration() == null;
    }

    public boolean hasPoseAndQNear(MoveRequest moveRequest) {
        return moveRequest.getTargetPose() != null && moveRequest.getTargetJointConfiguration() != null;
    }

    public boolean hasJointConfiguration(MoveRequest moveRequest) {
        return moveRequest.getTargetJointConfiguration() != null;
    }

    public JointPositionVector getInverseKinematics(MoveRequest moveRequest, JointPositionVector qNear) {
        return this.kinematicsController.getInverseKinematics(new Pose6d(moveRequest.getTargetPose().asArray()), qNear);
    }

    public boolean isReachableByMoveL(MoveRequest moveRequest, JointPositionVector currentPosition, JointPositionVector qTargetComputed) {
        return this.kinematicsController.canBeReachByMoveL(new Pose6d(moveRequest.getTargetPose().asArray()), currentPosition, qTargetComputed);
    }

    public Arm currentArm() {
        return (Arm)this.recipeArm.get();
    }

    public boolean validJointConfiguration(MoveRequest moveRequest) {
        return this.jointConfigurationValidator.isValid(moveRequest.getTargetJointConfiguration());
    }
}

