/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.freedrive;

import com.ur.lang.react.Consumer;
import com.ur.monitor.model.RobotMode;
import com.ur.move.MoveToolPanel;
import com.ur.move.PositionPanel;
import com.ur.view.constants.runtime.ControlMode;
import java.util.Objects;

public class DisableJogWhenInFreedrive
implements Consumer<RobotMode> {
    private final MoveToolPanel moveToolPanel;
    private final PositionPanel positionPanel;
    private ControlMode currentControlMode = null;

    public DisableJogWhenInFreedrive(MoveToolPanel moveToolPanel, PositionPanel positionPanel) {
        this.moveToolPanel = moveToolPanel;
        this.positionPanel = positionPanel;
    }

    public void accept(RobotMode robotMode) {
        if (Objects.isNull(robotMode)) {
            return;
        }
        ControlMode newControlMode = robotMode.getControlMode();
        if (this.hasSwitchedToFreedrive(newControlMode)) {
            this.moveToolPanel.updateAndShowDisabledPanels();
            this.positionPanel.updateAndShowDisabledButtons();
        } else if (this.hasFreedriveEnded(newControlMode)) {
            this.moveToolPanel.update();
            this.positionPanel.update();
        }
        this.currentControlMode = newControlMode;
    }

    private boolean hasSwitchedToFreedrive(ControlMode newControlMode) {
        return newControlMode == ControlMode.TEACH && this.currentControlMode != ControlMode.TEACH;
    }

    private boolean hasFreedriveEnded(ControlMode newControlMode) {
        return this.currentControlMode == ControlMode.TEACH && newControlMode != ControlMode.TEACH;
    }
}

