/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.freedrive;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.move.freedrive.FreedriveModeAvailability;
import com.ur.polyscope.security.Privileges;
import com.ur.security.Privilege;
import javax.inject.Inject;

public class FreeDriveButtonAction
implements DashBoardAction {
    private static final ScriptActionDefinitionParser FREE_DRIVE_MODE = new ScriptActionDefinitionParser("freedrivemode <arg>");
    private final Privilege<FreedriveModeAvailability> privilege;

    @Inject
    public FreeDriveButtonAction(Privileges privileges) {
        this.privilege = privileges.getPrivilege(FreedriveModeAvailability.POINT);
    }

    public boolean canHandleMessage(String input) {
        return FREE_DRIVE_MODE.isMatch(input);
    }

    public String execute(String input) {
        String setting = FREE_DRIVE_MODE.getArgument(0, input);
        try {
            switch (Setting.valueOf(setting.toUpperCase())) {
                case ENABLED: {
                    return this.setEnabled();
                }
                case RESTRICTED: {
                    return this.setRestricted();
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return String.format("Failed to configure freedrive button.", new Object[0]);
    }

    protected String setRestricted() {
        this.privilege.addMaximumRestriction((Object)this, (Enum)FreedriveModeAvailability.ONLY_IN_REDUCED_MODE);
        return "Freedrive button is now only available in reduced mode.";
    }

    protected String setEnabled() {
        this.privilege.removeRestrictions((Object)this);
        return "Freedrive button is now enabled in both reduced and normal mode.";
    }

    public static enum Setting {
        ENABLED,
        RESTRICTED;


        public String getSetting() {
            return this.name().toLowerCase();
        }
    }
}

