/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.freedrive;

import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.robotmessage.SafetyModeCategory;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.monitor.RobotState;
import com.ur.monitor.requirements.AbstractRobotRequirement;
import com.ur.monitor.requirements.FailedRequirementListener;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import javax.inject.Inject;

public class FreeDriveRobotRequirement
extends AbstractRobotRequirement {
    @Inject
    public FreeDriveRobotRequirement(FailedRequirementListener failedRequirementListener) {
        super(failedRequirementListener);
    }

    protected boolean isFulfilled() {
        return this.allowedRobotModes(RobotState.getLatestRobotState().robotMode) && this.allowedSafetyModes(RobotState.getLatestRobotState().masterSafetyState);
    }

    protected boolean allowedRobotModes(RobotMode robotMode) {
        return EqualsUtil.equalsOneOf((Object)robotMode, (Object[])new RobotMode[]{RobotMode.RUNNING, RobotMode.IDLE, RobotMode.BACKDRIVE});
    }

    protected boolean allowedSafetyModes(SafetyMode safetyMode) {
        SafetyModeCategory safetyModeCategory = SafetyModes.getSafetyModeCategory((SafetyMode)safetyMode);
        return EqualsUtil.equalsOneOf((Object)safetyModeCategory, (Object[])new SafetyModeCategory[]{SafetyModeCategory.NORMAL, SafetyModeCategory.REDUCED, SafetyModeCategory.RECOVERY, SafetyModeCategory.VALIDATE_JOINT_ID, SafetyModeCategory.EMERGENCY_STOP});
    }
}

