/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.internal;

import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.move.freedrive.FreedriveModeAvailability;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.controllerinterface.ControllerSocketListener;
import com.ur.polyscope.security.Privileges;
import com.ur.security.Privilege;
import com.ur.security.PrivilegeLevelChangeListener;
import com.ur.util.event.EventNotificationService;

public class ControllerTeachButton {
    private static Privilege<FreedriveModeAvailability> freedriveModePrivilege = new Privilege.Null((Enum)FreedriveModeAvailability.DENIED);
    private static boolean physicalTeachButtonEnabled = true;
    private static boolean physicalTeachButtonCurrentlyEnabled = true;
    private static ControllerInterface controllerInterface;

    public static void initTeachButton(Privileges privileges, ControllerInterface controllerInterface) {
        ControllerTeachButton.controllerInterface = controllerInterface;
        EventNotificationService.register(null, RobotStateListener.class, (Object)new RobotStateListener(){

            public void updateRobotState(RobotState robotState) {
                ControllerTeachButton.updateTeachButton();
            }
        });
        EventNotificationService.register(null, ControllerSocketListener.class, (Object)new ControllerSocketListener(){

            public void socketEvent(boolean connected) {
                if (connected) {
                    ControllerTeachButton.doUpdateTeachButton();
                }
            }
        });
        freedriveModePrivilege = privileges.getPrivilege(FreedriveModeAvailability.POINT);
        freedriveModePrivilege.addLevelChangeListener((PrivilegeLevelChangeListener)new PrivilegeLevelChangeListener<FreedriveModeAvailability>(){

            public void levelChanged(FreedriveModeAvailability oldLevel, FreedriveModeAvailability newLevel) {
                ControllerTeachButton.updateTeachButton();
            }
        });
    }

    public static void setControllerInterface(ControllerInterface controllerInterface) {
        ControllerTeachButton.controllerInterface = controllerInterface;
    }

    public static void forTestingSetFreedriveModePrivilege(Privilege<FreedriveModeAvailability> privilege) {
        freedriveModePrivilege = privilege;
    }

    public static void setPhysicalTeachButtonEnabled(boolean enable) {
        physicalTeachButtonEnabled = enable;
        ControllerTeachButton.updateTeachButton();
    }

    private static void updateTeachButton() {
        boolean newEnabled = physicalTeachButtonEnabled;
        switch ((FreedriveModeAvailability)freedriveModePrivilege.getLevel()) {
            case ALWAYS: {
                break;
            }
            case ONLY_IN_REDUCED_MODE: {
                if (RobotState.getLatestRobotState().reducedModeActive) break;
                newEnabled = false;
                break;
            }
            default: {
                newEnabled = false;
            }
        }
        if (newEnabled != physicalTeachButtonCurrentlyEnabled) {
            physicalTeachButtonCurrentlyEnabled = newEnabled;
            ControllerTeachButton.doUpdateTeachButton();
        }
    }

    private static void doUpdateTeachButton() {
        controllerInterface.runScript("set teach button enabled " + (physicalTeachButtonCurrentlyEnabled ? "True" : "False") + "\n");
        if (!physicalTeachButtonCurrentlyEnabled) {
            ControllerTeachButton.sendSetFreedriveMode(false);
        }
    }

    public static void sendSetFreedriveMode(boolean enable) {
        controllerInterface.runScript("set freedrive mode " + (enable ? "True" : "False") + "\n");
    }
}

