/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.poseeditor;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.JointType;
import com.ur.move.PositionReference;
import com.ur.move.poseeditor.PoseRequest;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.swing.CardPanel;

public abstract class FeaturePoseEditorPanel
extends CardPanel {
    public static final String X_INPUT_FIELD = "XInputField.FeaturePoseEditorPanel";
    public static final String Y_INPUT_FIELD = "YInputField.FeaturePoseEditorPanel";
    public static final String Z_INPUT_FIELD = "ZInputField.FeaturePoseEditorPanel";
    public static final String RX_INPUT_FIELD = "RXInputField.FeaturePoseEditorPanel";
    public static final String RY_INPUT_FIELD = "RYInputField.FeaturePoseEditorPanel";
    public static final String RZ_INPUT_FIELD = "RZInputField.FeaturePoseEditorPanel";
    public static final String FEATURES_COMBO_BOX = "featuresComboBox.PoseEditorPanel";
    public static final String ROTATION_TYPE_COMBO_BOX = "rotationTypeComboBox.PoseEditorPanel";
    protected static final double MIN_POSITION_INCREASE_DECREASE = 0.01;
    protected static final double MAX_POSITION_INCREASE_DECREASE = 15.0;
    protected final FeaturesLookup featureLookup;

    public FeaturePoseEditorPanel(FeaturesLookup featureLookup) {
        this.featureLookup = featureLookup;
    }

    public void show(PositionReference positionReference, CardPanel panel) {
        if (positionReference == null || positionReference.isUndefined()) {
            this.show(panel);
        } else {
            this.showPanel(this.createPoseRequest(positionReference), panel);
        }
    }

    public void show(CardPanel panel) {
        JointPositionVector jointPosition = new JointPositionVector(RobotState.getLatestRobotState().jointPosition);
        this.showPanel(this.createPoseRequest(jointPosition), panel);
    }

    private PoseRequest createPoseRequest(JointPositionVector jointPositionVector) {
        PoseRequest poseRequest = new PoseRequest();
        poseRequest.setCurrentJointPosition(jointPositionVector);
        return poseRequest;
    }

    protected abstract PoseRequest createPoseRequest(PositionReference var1);

    private void showPanel(PoseRequest poseRequest, CardPanel panel) {
        panel.stackCurrentCardAndSwitchTo(((Object)((Object)this)).getClass(), (Object)poseRequest);
    }

    protected static enum ValueToEdit {
        NONE(-1),
        X_COORD(0),
        Y_COORD(1),
        Z_COORD(2),
        X_ROT(3),
        Y_ROT(4),
        Z_ROT(5),
        JOINT1(6),
        JOINT2(7),
        JOINT3(8),
        JOINT4(9),
        JOINT5(10),
        JOINT6(11);

        private final int id;

        private ValueToEdit(int id) {
            this.id = id;
        }

        public boolean isRotation() {
            return this.id >= 3 && this.id < 6;
        }

        public boolean isCoordinate() {
            return this.id >= 0 && this.id < 3;
        }

        public boolean isJoint() {
            return this.id > 5;
        }

        public JointType getJoint() {
            if (this.isJoint()) {
                return JointType.fromJointNumber((int)(this.id - 6));
            }
            throw new RuntimeException("No matching jointNumber for " + (this.id - 6));
        }
    }
}

