/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.poseeditor;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.RobotMode;
import com.ur.move.FeatureVisualization;
import com.ur.move.OKCancelConfirmationListener;
import com.ur.move.PositionReference;
import com.ur.move.TransparentFeatureVisualization;
import com.ur.move.UpdateGeomPoseStrategy;
import com.ur.move.internal.ControllerRequirement;
import com.ur.move.poseeditor.FeaturePoseEditorPanel;
import com.ur.move.poseeditor.PoseRequest;
import com.ur.move.poseeditor.RobotView3DPanelImpl;
import com.ur.move.resources.MoveImageResource;
import com.ur.move.resources.TextResource;
import com.ur.move.viewfacade.MoveCameraView;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentation;
import com.ur.polyscope.internaltcp.rotation.RotationRepresentationFactory;
import com.ur.polyscope.valueobjects.Angle;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.polyscope.viewfacade.lang.IHideousJTextTranslator;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.viewfacade.program.ProgramUiControl;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.polyscope.visualizer.panel.ElementsVisualizerAggregator;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CloseListener;
import com.ur.swing.CompletedListener;
import com.ur.swing.FormBuilder;
import com.ur.swing.InputOperation;
import com.ur.swing.LongPressListener;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogOnScreen;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.number.NumberField;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.number.NumberPicker;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.media.j3d.Transform3D;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.vecmath.Vector3d;

@Singleton
public class FeaturePoseEditorPanelImpl
extends FeaturePoseEditorPanel
implements RobotStateListener,
OKCancelConfirmationListener {
    private int maxCountBetweenAccelerations = 3;
    private int acceleration = 2;
    private int countBetweenAcceleration = 0;
    private double positionIncreaseDecrease = 0.01;
    private double minRotationIncreaseDecrease = 8.726646259971648E-4;
    private double maxRotationIncreaseDecrease = 0.04363323129985824;
    private double rotationIncreaseDecrease = this.minRotationIncreaseDecrease;
    private final JTextField[] coordinateValueTextFields = new JTextField[6];
    private final HelpIdAssigner helpIdAssigner;
    private final ProgramUiControl programUiControl;
    private final ViewContext viewContext;
    private final IHideousJTextTranslator jTextTranslator;
    private final ErrorDialogCreator errorDialogCreator;
    private final MessageDialogCreator messageDialogCreator;
    private final DialogOnScreen dialogOnScreen;
    private RobotView3DPanelImpl robotPanel;
    private final ControllerRequirement controllerRequirement;
    private String unreachableToolPoseErrorMessage;
    private boolean updating;
    private RobotState lastRobotState = null;
    private boolean isInitialized = false;
    private RotationRepresentation rotationRepresentation = null;
    private Pose6d targetFeaturePose6d = null;
    private ViewableGeomFeature targetFeaturePose = null;
    private boolean performUpdateOfTextField = false;
    private JPanel featurePanel;
    private JComboBox geomFeaturesComboBox;
    private JComboBox rotationTypeComboBox;
    private JPanel toolPositionPanel;
    private NumberField toolRXValueTextField;
    private NumberField toolRYValueTextField;
    private NumberField toolRZValueTextField;
    private NumberField toolXValueTextField;
    private NumberField toolYValueTextField;
    private NumberField toolZValueTextField;
    private JLabel unreachableInfoLabel;
    private TextResource textResource;
    private UpdateGeomPoseStrategy updateGeomPoseStrategy;
    private ProgramVisualization programVisualization;
    private ProgramVisualization vgProgramVisualization;
    private ViewableGeomFeature vg;
    private boolean hideInfoMessage = true;
    private ValidationStrategy rangeValidator;
    private static final int XYZ_VALUE_RANGE_MAX = 100000;
    public static final String UNREACHABLE_INFO_LABEL = "UnreachableInfoLabel.FeaturePoseEditorPanel";
    private final FeatureVisualization featureVisualization = new FeatureVisualization();
    private final TransparentFeatureVisualization transparentFeatureVisualization = new TransparentFeatureVisualization();
    private final InverseKinematicProviderExt inverseKinematicProviderExt;

    @Inject
    public FeaturePoseEditorPanelImpl(ElementsVisualizerAggregator elementsVisualizerAggregator, FeaturesLookup featureLookup, ControllerRequirement controllerRequirement, RobotCanvas3DFactory robotCanvas3DFactory, HelpIdAssigner helpIdAssigner, ProgramUiControl programUiControl, ViewContext viewContext, ErrorDialogCreator errorDialogCreator, MessageDialogCreator messageDialogCreator, DialogOnScreen dialogOnScreen, IHideousJTextTranslator jTextTranslator, ControllerInterface controllerInterface, UpdateGeomPoseStrategy updateGeomPoseStrategy, @Source(value=RobotMode.class) Recipe<RobotMode> robotModeRecipe, InverseKinematicProviderExt inverseKinematicProviderExt) {
        super(featureLookup);
        this.controllerRequirement = controllerRequirement;
        this.helpIdAssigner = helpIdAssigner;
        this.programUiControl = programUiControl;
        this.viewContext = viewContext;
        this.errorDialogCreator = errorDialogCreator;
        this.messageDialogCreator = messageDialogCreator;
        this.dialogOnScreen = dialogOnScreen;
        this.jTextTranslator = jTextTranslator;
        this.updateGeomPoseStrategy = updateGeomPoseStrategy;
        this.inverseKinematicProviderExt = inverseKinematicProviderExt;
        robotModeRecipe.distinctUntilChanged().executeOnUIThread().subscribe((Consumer)new Consumer<RobotMode>(){

            public void accept(RobotMode newValue) {
                FeaturePoseEditorPanelImpl.this.hideInfoMessage = newValue.getRobotMode() == com.ur.view.constants.dev.RobotMode.NO_CONTROLLER || newValue.getRobotMode() == com.ur.view.constants.dev.RobotMode.DISCONNECTED || newValue.getRobotMode() == com.ur.view.constants.dev.RobotMode.POWER_OFF;
            }
        });
        try {
            this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
            this.rangeValidator = ValidationFactory.getRangeValidator((double)-100000.0, (double)100000.0, (String)this.textResource.valueOutOfRange(-100000.0, "", 100000.0));
            this.robotPanel = new RobotView3DPanelImpl(elementsVisualizerAggregator, this, robotCanvas3DFactory, viewContext, controllerInterface, inverseKinematicProviderExt);
            this.initComponents();
            this.addJComponentsToArrays();
            this.initializeRotationTypeComboBox();
            this.translateGUILabels();
            this.setupKeyboardShortcuts();
            this.robotPanel.setActive(false);
            RobotCanvas3D robotCanvas3D = this.robotPanel.robotCanvas3D;
            this.programVisualization = new ProgramVisualization(robotCanvas3D.isActualCanvas());
            this.programVisualization.setPointsVisibleState(true);
            this.programVisualization.setCoordinateSystemsVisibleState(true);
            if (robotCanvas3D.isActualCanvas()) {
                robotCanvas3D.addNodeToScene(this.programVisualization.getElementNode());
            }
            this.vgProgramVisualization = new ProgramVisualization(robotCanvas3D.isActualCanvas());
            this.vgProgramVisualization.setPointsVisibleState(true);
            this.vgProgramVisualization.setCoordinateSystemsVisibleState(true);
            if (robotCanvas3D.isActualCanvas()) {
                robotCanvas3D.addNodeToScene(this.vgProgramVisualization.getElementNode());
                robotCanvas3D.showElements(Arrays.asList(VisualizerElementType.CONSTRAINED_FREE_DRIVE, VisualizerElementType.PAYLOAD_COG, VisualizerElementType.TCP), Arrays.asList(this.featureVisualization, this.transparentFeatureVisualization));
            }
            this.setComponentNames();
            this.initHelpIds();
        }
        catch (Exception e) {
            Log.error((String)"Ignoring for tests");
        }
    }

    private void setComponentNames() {
        this.coordinateValueTextFields[0].setName("XInputField.FeaturePoseEditorPanel");
        this.coordinateValueTextFields[1].setName("YInputField.FeaturePoseEditorPanel");
        this.coordinateValueTextFields[2].setName("ZInputField.FeaturePoseEditorPanel");
        this.coordinateValueTextFields[3].setName("RXInputField.FeaturePoseEditorPanel");
        this.coordinateValueTextFields[4].setName("RYInputField.FeaturePoseEditorPanel");
        this.coordinateValueTextFields[5].setName("RZInputField.FeaturePoseEditorPanel");
        this.geomFeaturesComboBox.setName("featuresComboBox.PoseEditorPanel");
        this.rotationTypeComboBox.setName("rotationTypeComboBox.PoseEditorPanel");
    }

    private void addJComponentsToArrays() {
        this.coordinateValueTextFields[0] = this.toolXValueTextField;
        this.coordinateValueTextFields[1] = this.toolYValueTextField;
        this.coordinateValueTextFields[2] = this.toolZValueTextField;
        this.coordinateValueTextFields[3] = this.toolRXValueTextField;
        this.coordinateValueTextFields[4] = this.toolRYValueTextField;
        this.coordinateValueTextFields[5] = this.toolRZValueTextField;
        this.setTextFieldProperties(this.coordinateValueTextFields);
    }

    private void setTextFieldProperties(JTextField[] textFields) {
        for (JTextField each : textFields) {
            each.setColumns(6);
            each.setFocusable(false);
            each.setRequestFocusEnabled(false);
            each.setHorizontalAlignment(4);
        }
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.geomFeaturesComboBox, "gui:poseeditor_feature_tool_position");
        this.helpIdAssigner.assignHelpId((JComponent)this.robotPanel, "gui:poseeditor_3drobot");
    }

    private void setRotationIncreaseDecrease(RotationRepresentation.RotationType oldRotRep, RotationRepresentation.RotationType newRotRep) {
        if (oldRotRep == RotationRepresentation.RotationType.ANGLES_DEGREES || oldRotRep == RotationRepresentation.RotationType.VECTOR_DEGREES) {
            this.minRotationIncreaseDecrease *= Math.PI / 180;
            this.maxRotationIncreaseDecrease *= Math.PI / 180;
            this.rotationIncreaseDecrease = this.minRotationIncreaseDecrease;
        }
        if (newRotRep == RotationRepresentation.RotationType.ANGLES_DEGREES || newRotRep == RotationRepresentation.RotationType.VECTOR_DEGREES) {
            this.minRotationIncreaseDecrease *= 57.29577951308232;
            this.maxRotationIncreaseDecrease *= 57.29577951308232;
            this.rotationIncreaseDecrease = this.minRotationIncreaseDecrease;
        }
    }

    private void handleNewToolFeaturePose(Pose6d newToolPose) {
        if (newToolPose.equals((Object)this.targetFeaturePose6d)) {
            return;
        }
        this.targetFeaturePose6d = newToolPose;
        this.rotationRepresentation.setValues(this.rotationRepresentation.computeRotation(this.targetFeaturePose6d.getRot()));
        this.setToolPositionValueTextFields(this.robotPanel.getCurrentToolFeaturePose(), false);
    }

    private ViewableGeomFeature initGeomFeatures(ViewableGeomFeature selectedJoggableGeomFeature) {
        DefaultComboBoxModel<GeomFeature> model = new DefaultComboBoxModel<GeomFeature>(this.featureLookup.getFeatureContainer().getJoggableGeomNodes());
        for (int i = 0; i < model.getSize(); ++i) {
            ViewableGeomFeature j = (ViewableGeomFeature)model.getElementAt(i);
            if (!"View".equals(j.getName())) continue;
            model.removeElementAt(i);
        }
        this.geomFeaturesComboBox.setModel(model);
        this.featureLookup.getFeatureContainer().getToolViewFeature().setOnline(false);
        selectedJoggableGeomFeature = (ViewableGeomFeature)this.geomFeaturesComboBox.getItemAt(0);
        this.geomFeaturesComboBox.setSelectedItem(selectedJoggableGeomFeature);
        return selectedJoggableGeomFeature;
    }

    private void setupKeyboardShortcuts() {
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "Escape");
        actionMap.put("Escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FeaturePoseEditorPanelImpl.this.cancelAction();
            }
        });
    }

    @Override
    protected PoseRequest createPoseRequest(PositionReference positionReference) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(Object o) {
        super.enter(o);
        this.updating = true;
        try {
            this.robotPanel.setActive(true);
            this.robotPanel.showOkCancelPanel();
            if (o instanceof ViewableGeomFeature) {
                this.isInitialized = false;
                this.vg = (ViewableGeomFeature)o;
                this.vg.setHighPlaneTransparency();
                this.vg.setProgramVisualization(this.vgProgramVisualization);
                this.transparentFeatureVisualization.setPosition(this.vg);
                this.targetFeaturePose6d = new Pose6d(this.vg.getSpatialPose().asArray());
                this.targetFeaturePose = this.updateGeomPoseStrategy.deepClonePlane(this.vg);
                this.targetFeaturePose.makeNewPositionReferences();
                this.targetFeaturePose.setDefaultPlaneTransparency();
                this.targetFeaturePose.setProgramVisualization(this.programVisualization);
                this.featureVisualization.setPosition(this.targetFeaturePose);
                this.programUiControl.stopProgram();
                ViewableGeomFeature selectedJoggableGeomFeature = this.initGeomFeatures(this.vg);
                this.lastRobotState = RobotState.getLatestRobotState().clone();
                this.featureLookup.getFeatureContainer().getToolViewFeature().setTransformAccordingToRobotState(this.lastRobotState.tool);
                this.robotPanel.setJoggableGeomFeature(selectedJoggableGeomFeature, false, true);
                this.robotPanel.enableOk(true);
                this.robotPanel.updateRobot2JointPosition(this.lastRobotState.jointPosition);
                this.rotationRepresentation.resetState();
                Vector3d rotation = this.rotationRepresentation.computeRotation(this.targetFeaturePose6d.getRot());
                this.rotationRepresentation.setValues(rotation);
                this.setToolPositionValueTextFields(this.targetFeaturePose6d, false);
                Transform3D baseInitialCamera = this.robotPanel.getJoggableGeomFeature().getCameraTransform();
                Transform3D featureTransform = Pose6dTransformUtils.getTransform3D((Pose6d)new Pose6d(this.vg.getSpatialPose().asArray()));
                this.centerCameraOnObjects(baseInitialCamera, featureTransform);
                this.setToolErrorMessage(this.inverseKinematicProviderExt.getInverseKinematics(this.targetFeaturePose6d, this.robotPanel.getCurrentJointPostionVector(), RobotState.getLatestRobotState().tcpOffset, false) != null);
            } else if (o != null) {
                Log.error((String)("Class of argument not supported: " + o.getClass()), (Throwable)new Exception());
            }
            this.updateValidators();
            EventNotificationService.register((Object)this, RobotStateListener.class, (Object)this);
        }
        finally {
            this.updating = false;
        }
    }

    private void centerCameraOnObjects(Transform3D cameraTransformation, Transform3D featureTransformation) {
        double zoomOffset = 2.8;
        Vector3d cameraPositionVector = Pose6dTransformUtils.getPos((Transform3D)cameraTransformation);
        Vector3d featurePositionVector = Pose6dTransformUtils.getPos((Transform3D)featureTransformation);
        double halfDistanceToFeatureY = featurePositionVector.getY() / 2.0;
        double halfDistanceToFeatureZ = featurePositionVector.getZ() / 2.0;
        double halfDistanceToFeatureX = featurePositionVector.getX() / 2.0;
        this.robotPanel.getJoggableGeomFeature().moveView(halfDistanceToFeatureX - cameraPositionVector.getX() + zoomOffset, halfDistanceToFeatureY - cameraPositionVector.getY(), halfDistanceToFeatureZ - cameraPositionVector.getZ());
    }

    public void updateRobotState(RobotState robotState) {
        if (!this.isInitialized) {
            this.isInitialized = this.robotPanel.initializeRobotGraphics(this.robotPanel.getCurrentJointPostionVector());
            if (this.isInitialized) {
                JointPositionVector jvpTarget = RobotState.getLatestRobotState().targetJointPosition;
                if (jvpTarget != null) {
                    this.robotPanel.updateRobot2JointPosition(jvpTarget);
                }
                this.setToolPositionValueTextFields(this.targetFeaturePose6d, false);
            }
        }
        boolean bl = this.performUpdateOfTextField = !this.performUpdateOfTextField;
        if (this.performUpdateOfTextField && this.robotPanel.getJoggableGeomFeature() instanceof MoveCameraView) {
            this.handleNewToolFeaturePose(this.robotPanel.updateToolFeaturePose());
        }
    }

    private void updateValidators() {
    }

    private void exitScreen() {
        this.featureLookup.getFeatureContainer().getToolViewFeature().setOnline(true);
        this.targetFeaturePose.setShowAxes(false);
        this.vg.setDefaultPlaneTransparency();
        this.targetFeaturePose.applyShowAxesChoice(this.programVisualization);
        this.targetFeaturePose.applyShowAxesChoice(this.robotPanel.getProgramVisualization());
        this.targetFeaturePose.removeAllSubscribers();
        this.programVisualization.clearVisualization();
        this.vgProgramVisualization.clearVisualization();
        this.robotPanel.clearVisualization();
    }

    public Object exit() {
        EventNotificationService.unregister((Object)this, RobotStateListener.class);
        this.robotPanel.setActive(false);
        return super.exit();
    }

    private void setToolPositionValueTextFields(Pose6d toolFeaturePose, boolean useRotationRepresentationValues) {
        this.toolXValueTextField.setValue((Object)Length.from((double)toolFeaturePose.getX(), (Length.Unit)Length.Unit.M));
        this.toolXValueTextField.setErrorValidationStrategy(new ValidationStrategy[]{this.rangeValidator});
        this.toolYValueTextField.setValue((Object)Length.from((double)toolFeaturePose.getY(), (Length.Unit)Length.Unit.M));
        this.toolYValueTextField.setErrorValidationStrategy(new ValidationStrategy[]{this.rangeValidator});
        this.toolZValueTextField.setValue((Object)Length.from((double)toolFeaturePose.getZ(), (Length.Unit)Length.Unit.M));
        this.toolZValueTextField.setErrorValidationStrategy(new ValidationStrategy[]{this.rangeValidator});
        if (useRotationRepresentationValues) {
            this.setToolRotationValueTextFields(this.rotationRepresentation.getValues());
        } else {
            Vector3d rotation = this.rotationRepresentation.computeRotation(toolFeaturePose.getRot());
            this.rotationRepresentation.setValues(rotation);
            this.setToolRotationValueTextFields(rotation);
        }
    }

    private void setToolRotationValueTextFields(Vector3d rotation) {
        Angle.Unit unit = this.getAngleUnitForRotationType(this.rotationRepresentation.getRotationType());
        this.toolRXValueTextField.setValue((Object)Angle.from((double)rotation.x, (Angle.Unit)unit));
        this.toolRYValueTextField.setValue((Object)Angle.from((double)rotation.y, (Angle.Unit)unit));
        this.toolRZValueTextField.setValue((Object)Angle.from((double)rotation.z, (Angle.Unit)unit));
    }

    private void initializeRotationTypeComboBox() {
        DefaultComboBoxModel<RotationRepresentation> comboBoxModel = new DefaultComboBoxModel<RotationRepresentation>();
        for (RotationRepresentation rr : RotationRepresentationFactory.createAll()) {
            comboBoxModel.addElement(rr);
        }
        try {
            this.rotationRepresentation = (RotationRepresentation)comboBoxModel.getSelectedItem();
        }
        catch (Exception exp) {
            Log.error((String)("Item not of type RotationRepresentation: " + comboBoxModel.getSelectedItem().getClass()), (Throwable)exp);
            this.geomFeaturesComboBox.setSelectedIndex(0);
            this.robotPanel.setJoggableGeomFeature((ViewableGeomFeature)this.geomFeaturesComboBox.getItemAt(0), false, true);
        }
        this.rotationTypeComboBox.setModel(comboBoxModel);
    }

    private void translateGUILabels() {
        this.jTextTranslator.translateJText(this.featurePanel);
        this.jTextTranslator.translateJText(this.toolPositionPanel);
        this.unreachableToolPoseErrorMessage = this.textResource.unreachableFeature();
        this.unreachableInfoLabel.setText(" ");
    }

    private void initComponents() {
        WidgetFactory factory = this.viewContext.createWidgetFactory();
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        JPanel emptyNorthPanel = new JPanel();
        JPanel centerPanel = new JPanel();
        JPanel centerPanel2 = new JPanel();
        JPanel featureCoordinateJointPanel = new JPanel();
        JPanel featureCoordinatePanel = new JPanel();
        this.featurePanel = new JPanel();
        this.geomFeaturesComboBox = new JComboBox();
        JLabel positionHeader = new JLabel(this.textResource.jointPositions());
        this.toolYValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(FeaturePoseEditorPanel.ValueToEdit.Y_COORD), UnitsValueConverterFactory.getLengthConverter());
        this.toolXValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(FeaturePoseEditorPanel.ValueToEdit.X_COORD), UnitsValueConverterFactory.getLengthConverter());
        this.toolZValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(FeaturePoseEditorPanel.ValueToEdit.Z_COORD), UnitsValueConverterFactory.getLengthConverter());
        this.toolRXValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(FeaturePoseEditorPanel.ValueToEdit.X_ROT), UnitsValueConverterFactory.getAngleConverter((boolean)true));
        this.toolRYValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(FeaturePoseEditorPanel.ValueToEdit.Y_ROT), UnitsValueConverterFactory.getAngleConverter((boolean)true));
        this.toolRZValueTextField = factory.createNumberField((ActionListener)new TextFieldActionListener(FeaturePoseEditorPanel.ValueToEdit.Z_ROT), UnitsValueConverterFactory.getAngleConverter((boolean)true));
        JButton addToToolXButton = new JButton();
        JButton addToToolYButton = new JButton();
        JButton addToToolZButton = new JButton();
        JButton addToToolRXButton = new JButton();
        JButton addToToolRYButton = new JButton();
        JButton addToToolRZButton = new JButton();
        JButton subtractFromToolXButton = new JButton();
        JButton subtractFromToolYButton = new JButton();
        JButton subtractFromToolZButton = new JButton();
        JButton subtractFromToolRXButton = new JButton();
        JButton subtractFromToolRYButton = new JButton();
        JButton subtractFromToolRZButton = new JButton();
        this.rotationTypeComboBox = new JComboBox();
        this.unreachableInfoLabel = new JLabel();
        this.unreachableInfoLabel.setName(UNREACHABLE_INFO_LABEL);
        JPanel buttonsSouthPanel = new JPanel();
        JPanel safetyWarningPanel = new JPanel();
        this.setMinimumSize(new Dimension(944, 538));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        emptyNorthPanel.setMinimumSize(new Dimension(800, 10));
        emptyNorthPanel.setOpaque(false);
        emptyNorthPanel.setPreferredSize(new Dimension(800, 10));
        emptyNorthPanel.setLayout(new FlowLayout(2));
        this.add(emptyNorthPanel);
        centerPanel.setMinimumSize(new Dimension(200, 400));
        centerPanel.setPreferredSize(new Dimension(222, 77));
        centerPanel.setRequestFocusEnabled(false);
        centerPanel.setLayout(new BorderLayout());
        centerPanel2.setLayout(new BorderLayout());
        featureCoordinateJointPanel.setLayout(new BorderLayout());
        featureCoordinatePanel.setLayout(new BorderLayout());
        this.featurePanel.setBorder(BorderFactory.createTitledBorder("Feature"));
        this.featurePanel.setLayout(new BorderLayout());
        this.geomFeaturesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"No feature"}));
        this.geomFeaturesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturePoseEditorPanelImpl.this.geomFeaturesComboBoxActionPerformed();
            }
        });
        String x = "<html><font color=\"red\"><b>X</b></font></html>";
        String y = "<html><font color=\"lime\"><b>Y</b></font></html>";
        String z = "<html><font color=\"blue\"><b>Z</b></font></html>";
        String rx = "<html><font color=\"red\"><b>RX</b></font></html>";
        String ry = "<html><font color=\"lime\"><b>RY</b></font></html>";
        String rz = "<html><font color=\"blue\"><b>RZ</b></font></html>";
        this.toolPositionPanel = formBuilder.componentWithLabel(x, (JComponent)this.toolXValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolXButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolXButton, new FormBuilder.PanelConstraints[0]).end().componentWithLabel(y, (JComponent)this.toolYValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolYButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolYButton, new FormBuilder.PanelConstraints[0]).end().componentWithLabel(z, (JComponent)this.toolZValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolZButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolZButton, new FormBuilder.PanelConstraints[0]).end().end().component((JComponent)this.rotationTypeComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().end().componentWithLabel(rx, (JComponent)this.toolRXValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolRXButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolRXButton, new FormBuilder.PanelConstraints[0]).end().componentWithLabel(ry, (JComponent)this.toolRYValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolRYButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolRYButton, new FormBuilder.PanelConstraints[0]).end().componentWithLabel(rz, (JComponent)this.toolRZValueTextField, new FormBuilder.PanelConstraints[0]).component((JComponent)addToToolRZButton, new FormBuilder.PanelConstraints[0]).component((JComponent)subtractFromToolRZButton, new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.unreachableInfoLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS, FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().groupColumns(new int[]{3, 4}).getPanel();
        this.toolPositionPanel.setBorder(BorderFactory.createTitledBorder("Tool_Position"));
        this.toolXValueTextField.setText("-1800.00");
        this.toolYValueTextField.setText("-1800.00");
        this.toolZValueTextField.setText("-1800.00");
        this.toolRXValueTextField.setText("-80.0000");
        this.toolRYValueTextField.setText("-00.0000");
        this.toolRZValueTextField.setText("-80.0000");
        this.initializeIncrementButton(addToToolXButton, FeaturePoseEditorPanel.ValueToEdit.X_COORD, (JTextField)this.toolXValueTextField);
        this.initializeIncrementButton(addToToolYButton, FeaturePoseEditorPanel.ValueToEdit.Y_COORD, (JTextField)this.toolYValueTextField);
        this.initializeIncrementButton(addToToolZButton, FeaturePoseEditorPanel.ValueToEdit.Z_COORD, (JTextField)this.toolZValueTextField);
        this.initializeIncrementButton(addToToolRXButton, FeaturePoseEditorPanel.ValueToEdit.X_ROT, (JTextField)this.toolRXValueTextField);
        this.initializeIncrementButton(addToToolRYButton, FeaturePoseEditorPanel.ValueToEdit.Y_ROT, (JTextField)this.toolRYValueTextField);
        this.initializeIncrementButton(addToToolRZButton, FeaturePoseEditorPanel.ValueToEdit.Z_ROT, (JTextField)this.toolRZValueTextField);
        this.initializeDecrementButton(subtractFromToolXButton, FeaturePoseEditorPanel.ValueToEdit.X_COORD, (JTextField)this.toolXValueTextField);
        this.initializeDecrementButton(subtractFromToolYButton, FeaturePoseEditorPanel.ValueToEdit.Y_COORD, (JTextField)this.toolYValueTextField);
        this.initializeDecrementButton(subtractFromToolZButton, FeaturePoseEditorPanel.ValueToEdit.Z_COORD, (JTextField)this.toolZValueTextField);
        this.initializeDecrementButton(subtractFromToolRXButton, FeaturePoseEditorPanel.ValueToEdit.X_ROT, (JTextField)this.toolRXValueTextField);
        this.initializeDecrementButton(subtractFromToolRYButton, FeaturePoseEditorPanel.ValueToEdit.Y_ROT, (JTextField)this.toolRYValueTextField);
        this.initializeDecrementButton(subtractFromToolRZButton, FeaturePoseEditorPanel.ValueToEdit.Z_ROT, (JTextField)this.toolRZValueTextField);
        this.rotationTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Rotation Vector Rad", "Rotation Vector Deg", "RPY Deg", "RPY Rad"}));
        this.rotationTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturePoseEditorPanelImpl.this.rotationTypeComboBoxActionPerformed();
            }
        });
        positionHeader.setFont(this.viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD));
        this.unreachableInfoLabel.setFont(new Font("DejaVu Sans", 0, 13));
        this.unreachableInfoLabel.setLabelFor(centerPanel);
        buttonsSouthPanel.setMinimumSize(new Dimension(800, 39));
        buttonsSouthPanel.setOpaque(false);
        buttonsSouthPanel.setPreferredSize(new Dimension(800, 40));
        buttonsSouthPanel.setLayout(new FlowLayout(2));
        safetyWarningPanel.setPreferredSize(new Dimension(560, 29));
        JPanel featureInsetPanel = new JPanel(new BorderLayout());
        featureInsetPanel.setBorder(BorderFactory.createEmptyBorder(0, UIManager.getInt("Form.indentSize"), 5, 0));
        featureInsetPanel.add((Component)this.geomFeaturesComboBox, "Center");
        this.featurePanel.add((Component)featureInsetPanel, "Center");
        featureCoordinatePanel.add((Component)this.featurePanel, "North");
        featureCoordinatePanel.add((Component)this.toolPositionPanel, "Center");
        featureCoordinateJointPanel.add((Component)featureCoordinatePanel, "Center");
        centerPanel2.add((Component)featureCoordinateJointPanel, "East");
        centerPanel2.add((Component)this.robotPanel, "Center");
        centerPanel.add((Component)centerPanel2, "Center");
        this.add(centerPanel);
        buttonsSouthPanel.add(safetyWarningPanel);
        this.add(buttonsSouthPanel);
    }

    private void initializeIncrementButton(JButton button, FeaturePoseEditorPanel.ValueToEdit value, JTextField field) {
        button.setIcon(MoveImageResource.gtkAdd());
        this.initializeChangeValueButton(button, value, InputOperation.ADD, field);
    }

    private void initializeDecrementButton(JButton button, FeaturePoseEditorPanel.ValueToEdit value, JTextField field) {
        button.setIcon(MoveImageResource.gtkRemove());
        this.initializeChangeValueButton(button, value, InputOperation.SUBTRACT, field);
    }

    private void initializeChangeValueButton(JButton button, FeaturePoseEditorPanel.ValueToEdit value, InputOperation operation, JTextField field) {
        button.setPreferredSize(new Dimension(35, 24));
        button.setMaximumSize(new Dimension(35, 24));
        button.setMinimumSize(new Dimension(35, 24));
        button.setRequestFocusEnabled(false);
        button.addMouseListener((MouseListener)((Object)new AddSubtractValueListener(value, operation, button, field, this)));
        button.setFocusPainted(false);
    }

    @Override
    public void cancelAction() {
        if (!this.isVisible()) {
            return;
        }
        this.exitScreen();
        this.navigateBack();
    }

    private void geomFeaturesComboBoxActionPerformed() {
        if (this.updating) {
            return;
        }
        try {
            ViewableGeomFeature newSelectedJoggableGeomFeature = (ViewableGeomFeature)this.geomFeaturesComboBox.getSelectedItem();
            this.targetFeaturePose6d = this.robotPanel.calculateNewToolFeaturePose(this.robotPanel.getJoggableGeomFeature(), newSelectedJoggableGeomFeature, this.targetFeaturePose6d);
            this.robotPanel.setJoggableGeomFeature(newSelectedJoggableGeomFeature, true, true);
            this.setToolPositionValueTextFields(this.targetFeaturePose6d, false);
        }
        catch (Exception e) {
            Log.error((String)"Something that was not a JoggableGeomFeature was in the geomFeaturesComboBox", (Throwable)e);
        }
    }

    private Angle.Unit getAngleUnitForRotationType(RotationRepresentation.RotationType rotationType) {
        Angle.Unit unit = Angle.Unit.DEGREES;
        if (rotationType == RotationRepresentation.RotationType.ANGLES_RADIANS || rotationType == RotationRepresentation.RotationType.VECTOR_RADIANS) {
            unit = Angle.Unit.RADIANS;
        }
        return unit;
    }

    private void updateToolPositionData(double inputValue, FeaturePoseEditorPanel.ValueToEdit value, InputOperation inputOperation) {
        Vector3d rotationComponent = this.rotationRepresentation.getValues();
        Angle.Unit unit = this.getAngleUnitForRotationType(this.rotationRepresentation.getRotationType());
        switch (value) {
            case X_COORD: {
                double newValue;
                this.targetFeaturePose6d.getPos().x = newValue = inputOperation.getNewValue(this.targetFeaturePose6d.getPos().x, Units.convert_to_m((double)inputValue));
                this.toolXValueTextField.setValue((Object)Length.from((double)newValue, (Length.Unit)Length.Unit.M));
                break;
            }
            case Y_COORD: {
                double newValue;
                this.targetFeaturePose6d.getPos().y = newValue = inputOperation.getNewValue(this.targetFeaturePose6d.getPos().y, Units.convert_to_m((double)inputValue));
                this.toolYValueTextField.setValue((Object)Length.from((double)newValue, (Length.Unit)Length.Unit.M));
                break;
            }
            case Z_COORD: {
                double newValue;
                this.targetFeaturePose6d.getPos().z = newValue = inputOperation.getNewValue(this.targetFeaturePose6d.getPos().z, Units.convert_to_m((double)inputValue));
                this.toolZValueTextField.setValue((Object)Length.from((double)newValue, (Length.Unit)Length.Unit.M));
                break;
            }
            case X_ROT: {
                double newValue = inputOperation.getNewValue(rotationComponent.x, inputValue);
                this.toolRXValueTextField.setValue((Object)Angle.from((double)newValue, (Angle.Unit)unit));
                rotationComponent.x = newValue;
                break;
            }
            case Y_ROT: {
                double newValue = inputOperation.getNewValue(rotationComponent.y, inputValue);
                this.toolRYValueTextField.setValue((Object)Angle.from((double)newValue, (Angle.Unit)unit));
                rotationComponent.y = newValue;
                break;
            }
            case Z_ROT: {
                double newValue = inputOperation.getNewValue(rotationComponent.z, inputValue);
                this.toolRZValueTextField.setValue((Object)Angle.from((double)newValue, (Angle.Unit)unit));
                rotationComponent.z = newValue;
                break;
            }
            default: {
                Log.error((String)("Value of gettingCoordinate = " + (Object)((Object)value) + " not supported"));
                Thread.dumpStack();
                return;
            }
        }
        this.targetFeaturePose6d.setRot(this.rotationRepresentation.getRotationVector(rotationComponent));
        this.updateGeomPoseStrategy.setPosition(this.targetFeaturePose, this.robotPanel.getJoggableGeomFeature().transformPoseInFeatureFrameToPoseInBaseFrame(this.targetFeaturePose6d), this.robotPanel.getCurrentJointPostionVector());
        this.rotationRepresentation.setValues(rotationComponent);
        this.programVisualization.clearVisualization();
        this.targetFeaturePose.setProgramVisualization(this.programVisualization);
        this.featureVisualization.setPosition(this.targetFeaturePose);
        this.setToolPositionValueTextFields(this.targetFeaturePose6d, true);
        this.setToolErrorMessage(this.inverseKinematicProviderExt.getInverseKinematics(this.targetFeaturePose6d, this.robotPanel.getCurrentJointPostionVector(), RobotState.getLatestRobotState().tcpOffset, false) != null);
    }

    private void setToolErrorMessage(boolean reachable) {
        if (reachable || this.hideInfoMessage || this.targetFeaturePose.isUndefined()) {
            this.unreachableInfoLabel.setText(" ");
            this.unreachableInfoLabel.setIcon(null);
        } else {
            this.unreachableInfoLabel.setText(this.unreachableToolPoseErrorMessage);
            this.unreachableInfoLabel.setIcon(MoveImageResource.metalInfo());
        }
    }

    @Override
    public void okAction() {
        if (!this.isVisible()) {
            return;
        }
        this.updateGeomPoseStrategy.setPosition(this.vg, this.robotPanel.getJoggableGeomFeature().transformPoseInFeatureFrameToPoseInBaseFrame(this.targetFeaturePose6d), this.robotPanel.getCurrentJointPostionVector());
        this.exitScreen();
        this.navigateBack();
    }

    private void rotationTypeComboBoxActionPerformed() {
        try {
            RotationRepresentation newSelectedRotationRepresentation = (RotationRepresentation)this.rotationTypeComboBox.getSelectedItem();
            RotationRepresentation.RotationType oldRotType = this.rotationRepresentation.getRotationType();
            assert (newSelectedRotationRepresentation != null);
            Vector3d rotation = newSelectedRotationRepresentation.computeRotation(this.rotationRepresentation.getRotationMatrix());
            newSelectedRotationRepresentation.setValues(rotation);
            this.rotationRepresentation = newSelectedRotationRepresentation;
            this.setRotationIncreaseDecrease(oldRotType, this.rotationRepresentation.getRotationType());
            this.setValueConvertersOnRotationFields(this.rotationRepresentation.getRotationType());
            this.setToolRotationValueTextFields(rotation);
        }
        catch (Exception e) {
            Log.error((String)"Something that was not a RotationRepresentation was in the rotationTypeComboBox: ", (Throwable)e);
        }
    }

    private void setValueConvertersOnRotationFields(RotationRepresentation.RotationType rotationType) {
        if (rotationType == RotationRepresentation.RotationType.ANGLES_DEGREES || rotationType == RotationRepresentation.RotationType.VECTOR_DEGREES) {
            this.toolRXValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter());
            this.toolRYValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter());
            this.toolRZValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter());
        } else {
            this.toolRXValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter((boolean)true));
            this.toolRYValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter((boolean)true));
            this.toolRZValueTextField.setValueConverter(UnitsValueConverterFactory.getAngleConverter((boolean)true));
        }
    }

    private void userEnteredInput(JTextField textField, FeaturePoseEditorPanel.ValueToEdit coordinate, InputOperation operation) {
        this.userEnteredInput(textField, coordinate, operation, null);
    }

    private void userEnteredInput(JTextField textField, FeaturePoseEditorPanel.ValueToEdit coordinate, InputOperation operation, JTextField inputValueTextField) {
        try {
            double inputValue = PrimitiveUtils.parseDouble((String)(inputValueTextField == null ? textField.getText() : inputValueTextField.getText()));
            if (!coordinate.isJoint()) {
                this.updateToolPositionData(inputValue, coordinate, operation);
            }
        }
        catch (NumberFormatException ex1) {
            this.messageDialogCreator.showMessageDialog(new DialogMessage(this.textResource.Message(), this.textResource.notANumber()), MessageDialogType.MESSAGE, new OkDialogListener());
        }
        catch (Exception ex2) {
            Log.error((String)"Invalid number entered ", (Throwable)ex2);
            this.errorDialogCreator.showErrorDialog(new ErrorMessage(this.textResource.Error(), ex2.getMessage()), new OkDialogListener());
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        private FeaturePoseEditorPanel.ValueToEdit valueToEdit;

        public TextFieldActionListener(FeaturePoseEditorPanel.ValueToEdit valueToEdit) {
            this.valueToEdit = valueToEdit;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField source = (JTextField)e.getSource();
            FeaturePoseEditorPanelImpl.this.userEnteredInput(source, this.valueToEdit, InputOperation.VALUE);
        }
    }

    private class AddSubtractValueListener
    extends LongPressListener
    implements RobotStateListener {
        private FeaturePoseEditorPanel.ValueToEdit value;
        private InputOperation operation;
        private JButton button;
        private JTextField field;
        private FeaturePoseEditorPanelImpl panel;

        AddSubtractValueListener(FeaturePoseEditorPanel.ValueToEdit value, InputOperation operation, JButton button, JTextField field, FeaturePoseEditorPanelImpl panel) {
            super(150);
            this.value = value;
            this.operation = operation;
            this.button = button;
            this.field = field;
            this.panel = panel;
        }

        public void onShortPress() {
            if (this.panel.controllerRequirement.checkAndNotify()) {
                this.jumpToOnScreenKeyPad();
            }
        }

        public void onLongPress() {
            EventNotificationService.unregister((Object)this.panel);
            EventNotificationService.register((Object)((Object)this), RobotStateListener.class, (Object)((Object)this));
        }

        public void updateRobotState(RobotState robotState) {
            if (!this.panel.controllerRequirement.checkAndNotify()) {
                this.panel.performUpdateOfTextField = !this.panel.performUpdateOfTextField;
                if (this.panel.performUpdateOfTextField && this.panel.robotPanel.getJoggableGeomFeature() instanceof MoveCameraView) {
                    this.panel.handleNewToolFeaturePose(this.panel.robotPanel.updateToolFeaturePose());
                }
            }
            if (FeaturePoseEditorPanelImpl.this.dialogOnScreen.isShowingADialog()) {
                this.mouseReleased(null);
                return;
            }
            if (this.value.isCoordinate()) {
                this.handlePositionIncreaseDecrease(this.value, this.operation);
            }
            if (this.value.isRotation()) {
                this.handleRotationIncreaseDecrease(this.value, this.operation);
            }
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            EventNotificationService.register((Object)this.panel, RobotStateListener.class, (Object)this.panel);
            EventNotificationService.unregister((Object)((Object)this));
            this.button.setSelected(false);
            FeaturePoseEditorPanelImpl.this.positionIncreaseDecrease = 0.01;
            FeaturePoseEditorPanelImpl.this.rotationIncreaseDecrease = FeaturePoseEditorPanelImpl.this.minRotationIncreaseDecrease;
            FeaturePoseEditorPanelImpl.this.countBetweenAcceleration = 0;
        }

        private void jumpToOnScreenKeyPad() {
            final JTextField textField = new JTextField("0");
            textField.selectAll();
            final BindingRegistration registration = NumberFieldUtils.bindValidator((JTextField)textField, (ValidationStrategy)this.getValidationStrategy(), (ValidationStrategy)ValidationStrategy.ALWAYS_VALID);
            NumberPicker numberPicker = new NumberPicker(textField, true);
            numberPicker.setMode(((NumberField)this.field).getMode());
            numberPicker.addCloseListener(new CloseListener(){

                public void onClose() {
                    registration.removeRegistration();
                }
            });
            numberPicker.addCompletedListener((CompletedListener)new CompletedListener.Template(){

                public void requestApply() {
                    AddSubtractValueListener.this.panel.userEnteredInput(AddSubtractValueListener.this.field, AddSubtractValueListener.this.value, AddSubtractValueListener.this.operation, textField);
                }
            });
            numberPicker.showKeypad((JComponent)this.field);
        }

        private ValidationStrategy getValidationStrategy() {
            return ValidationStrategy.ALWAYS_VALID;
        }

        private void handlePositionIncreaseDecrease(FeaturePoseEditorPanel.ValueToEdit value, InputOperation operation) {
            if (FeaturePoseEditorPanelImpl.this.positionIncreaseDecrease < 15.0) {
                FeaturePoseEditorPanelImpl.this.countBetweenAcceleration++;
                if (FeaturePoseEditorPanelImpl.this.countBetweenAcceleration > FeaturePoseEditorPanelImpl.this.maxCountBetweenAccelerations) {
                    FeaturePoseEditorPanelImpl.this.positionIncreaseDecrease = FeaturePoseEditorPanelImpl.this.positionIncreaseDecrease * (double)FeaturePoseEditorPanelImpl.this.acceleration;
                    FeaturePoseEditorPanelImpl.this.countBetweenAcceleration = 0;
                }
            } else {
                FeaturePoseEditorPanelImpl.this.positionIncreaseDecrease = 15.0;
            }
            FeaturePoseEditorPanelImpl.this.updateToolPositionData(FeaturePoseEditorPanelImpl.this.positionIncreaseDecrease, value, operation);
        }

        private void handleRotationIncreaseDecrease(FeaturePoseEditorPanel.ValueToEdit value, InputOperation operation) {
            if (FeaturePoseEditorPanelImpl.this.rotationIncreaseDecrease < FeaturePoseEditorPanelImpl.this.maxRotationIncreaseDecrease) {
                FeaturePoseEditorPanelImpl.this.countBetweenAcceleration++;
                if (FeaturePoseEditorPanelImpl.this.countBetweenAcceleration > FeaturePoseEditorPanelImpl.this.maxCountBetweenAccelerations) {
                    FeaturePoseEditorPanelImpl.this.rotationIncreaseDecrease = FeaturePoseEditorPanelImpl.this.rotationIncreaseDecrease * (double)FeaturePoseEditorPanelImpl.this.acceleration;
                    FeaturePoseEditorPanelImpl.this.countBetweenAcceleration = 0;
                }
            } else {
                FeaturePoseEditorPanelImpl.this.rotationIncreaseDecrease = FeaturePoseEditorPanelImpl.this.maxRotationIncreaseDecrease;
            }
            FeaturePoseEditorPanelImpl.this.updateToolPositionData(FeaturePoseEditorPanelImpl.this.rotationIncreaseDecrease, value, operation);
        }
    }
}

