/*
 * Decompiled with CFR 0.152.
 */
package com.ur.move.poseeditor;

import com.ur.lang.StringUtils;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.JointType;
import com.ur.monitor.model.Pose6d;
import com.ur.move.JointPositionMessageProvider;
import com.ur.move.PositionReference;
import com.ur.move.poseeditor.PoseEditorListener;
import com.ur.move.poseeditor.PoseRequest;
import com.ur.move.viewfacade.MoveMotionDefiningNode;
import com.ur.move.viewfacade.MovePositionNode;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.joint.JointPositionRangeProvider;
import com.ur.polyscope.tcp.TCP;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.swing.CardPanel;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class PoseEditorPanel
extends CardPanel {
    public static final String JOINT_1_INPUT_Field = "joint1InputField.PoseEditorPanel";
    public static final String JOINT_2_INPUT_Field = "joint2InputField.PoseEditorPanel";
    public static final String JOINT_3_INPUT_Field = "joint3InputField.PoseEditorPanel";
    public static final String JOINT_4_INPUT_Field = "joint4InputField.PoseEditorPanel";
    public static final String JOINT_5_INPUT_Field = "joint5InputField.PoseEditorPanel";
    public static final String JOINT_6_INPUT_Field = "joint6InputField.PoseEditorPanel";
    public static final String TOOL_X_INPUT_Field = "toolXInputField.PoseEditorPanel";
    public static final String TOOL_Y_INPUT_Field = "toolYInputField.PoseEditorPanel";
    public static final String TOOL_Z_INPUT_Field = "toolZInputField.PoseEditorPanel";
    public static final String TOOL_RX_INPUT_Field = "toolRXInputField.PoseEditorPanel";
    public static final String TOOL_RY_INPUT_Field = "toolRYInputField.PoseEditorPanel";
    public static final String TOOL_RZ_INPUT_Field = "toolRZInputField.PoseEditorPanel";
    public static final String FEATURES_COMBO_BOX = "featuresComboBox.PoseEditorPanel";
    public static final String ROTATION_TYPE_COMBO_BOX = "rotationTypeComboBox.PoseEditorPanel";
    protected static final double minJointIncreaseDecrease = 0.005;
    protected static final double maxJointIncreaseDecrease = 2.5;
    protected static final double minPositionIncreaseDecrease = 0.01;
    protected static final double maxPositionIncreaseDecrease = 15.0;
    protected static List<ValueToEdit> JOINT_LIST = Arrays.asList(ValueToEdit.JOINT1, ValueToEdit.JOINT2, ValueToEdit.JOINT3, ValueToEdit.JOINT4, ValueToEdit.JOINT5, ValueToEdit.JOINT6);
    protected final JointConfigurationSettings jointConfigurationSettings;
    protected final JointPositionRangeProvider jointPositionRangeProvider;
    protected final FeaturesLookup featureLookup;
    protected final JointPositionMessageProviderAggregator messageProvider;
    protected PoseEditorListener poseListener = null;

    public PoseEditorPanel(Set<JointPositionMessageProvider> messageProvider, JointPositionRangeProvider jointPositionRangeProvider, JointConfigurationSettings jointConfigurationSettings, FeaturesLookup featureLookup) {
        this.jointConfigurationSettings = jointConfigurationSettings;
        this.jointPositionRangeProvider = jointPositionRangeProvider;
        this.featureLookup = featureLookup;
        this.messageProvider = new JointPositionMessageProviderAggregator(messageProvider);
    }

    private void setPoseListener(PoseEditorListener listener) {
        this.poseListener = listener;
    }

    public void show(PositionReference positionReference, PoseEditorListener listener, CardPanel panel) {
        if (positionReference == null || positionReference.isUndefined()) {
            this.show(listener, panel);
        } else {
            this.showPanel(this.createPoseRequest(positionReference), listener, panel);
        }
    }

    public void show(PoseEditorListener listener, CardPanel panel) {
        JointPositionVector jointPosition = new JointPositionVector(RobotState.getLatestRobotState().jointPosition);
        this.showPanel(this.createPoseRequest(jointPosition), listener, panel);
    }

    protected PoseRequest createPoseRequest(JointPositionVector jointPositionVector) {
        PoseRequest poseRequest = new PoseRequest();
        poseRequest.setCurrentJointPosition(jointPositionVector);
        return poseRequest;
    }

    protected abstract PoseRequest createPoseRequest(PositionReference var1);

    protected TCP getTCPFromPositionReference(PositionReference positionReference) {
        MoveMotionDefiningNode node;
        TCP tcp = null;
        if (positionReference instanceof MovePositionNode && (node = ((MovePositionNode)((Object)positionReference)).getMotionDefiningNode()) != null && node.getTcpReference() != null && node.getTcpReference().dereference() != null) {
            tcp = (TCP)node.getTcpReference().dereference();
        }
        return tcp;
    }

    private void showPanel(PoseRequest poseRequest, PoseEditorListener poseEditorListener, CardPanel panel) {
        this.setPoseListener(poseEditorListener);
        panel.stackCurrentCardAndSwitchTo(((Object)((Object)this)).getClass(), (Object)poseRequest);
    }

    protected static class JointPositionMessageProviderAggregator
    implements JointPositionMessageProvider {
        private Set<JointPositionMessageProvider> messageProviders;

        public JointPositionMessageProviderAggregator(Set<JointPositionMessageProvider> messageProviders) {
            this.messageProviders = messageProviders;
        }

        @Override
        public String getWarningMessage(JointPositionVector jointPositions, Pose6d toolPose) {
            String result = "";
            for (JointPositionMessageProvider each : this.messageProviders) {
                if (StringUtils.isNullOrEmpty((String)each.getWarningMessage(jointPositions, toolPose))) continue;
                result = each.getWarningMessage(jointPositions, toolPose);
            }
            return result;
        }
    }

    protected static enum ValueToEdit {
        NONE(-1),
        X_COORD(0),
        Y_COORD(1),
        Z_COORD(2),
        X_ROT(3),
        Y_ROT(4),
        Z_ROT(5),
        JOINT1(6),
        JOINT2(7),
        JOINT3(8),
        JOINT4(9),
        JOINT5(10),
        JOINT6(11);

        private final int id;

        private ValueToEdit(int id) {
            this.id = id;
        }

        public boolean isRotation() {
            return this.id >= 3 && this.id < 6;
        }

        public boolean isCoordinate() {
            return this.id >= 0 && this.id < 3;
        }

        public boolean isJoint() {
            return this.id > 5;
        }

        public JointType getJoint() {
            if (this.isJoint()) {
                return JointType.fromJointNumber((int)(this.id - 6));
            }
            throw new RuntimeException("No matching jointNumber for " + (this.id - 6));
        }
    }
}

